/*
 * Decompiled with CFR 0.152.
 */
package com.mongodb.client.internal;

import com.mongodb.AutoEncryptionSettings;
import com.mongodb.ClientSessionOptions;
import com.mongodb.Function;
import com.mongodb.MongoClientException;
import com.mongodb.MongoClientSettings;
import com.mongodb.MongoDriverInformation;
import com.mongodb.ReadPreference;
import com.mongodb.TransactionOptions;
import com.mongodb.assertions.Assertions;
import com.mongodb.client.ChangeStreamIterable;
import com.mongodb.client.ClientSession;
import com.mongodb.client.ListDatabasesIterable;
import com.mongodb.client.MongoClient;
import com.mongodb.client.MongoDatabase;
import com.mongodb.client.MongoIterable;
import com.mongodb.client.SynchronousContextProvider;
import com.mongodb.client.internal.ChangeStreamIterableImpl;
import com.mongodb.client.internal.Crypts;
import com.mongodb.client.internal.ListDatabasesIterableImpl;
import com.mongodb.client.internal.MongoClientDelegate;
import com.mongodb.client.internal.MongoDatabaseImpl;
import com.mongodb.client.internal.OperationExecutor;
import com.mongodb.connection.ClusterDescription;
import com.mongodb.connection.SocketSettings;
import com.mongodb.connection.SocketStreamFactory;
import com.mongodb.connection.StreamFactory;
import com.mongodb.connection.StreamFactoryFactory;
import com.mongodb.diagnostics.logging.Logger;
import com.mongodb.diagnostics.logging.Loggers;
import com.mongodb.internal.client.model.changestream.ChangeStreamLevel;
import com.mongodb.internal.connection.ClientMetadataHelper;
import com.mongodb.internal.connection.Cluster;
import com.mongodb.internal.connection.DefaultClusterFactory;
import com.mongodb.internal.connection.InternalConnectionPoolSettings;
import com.mongodb.internal.event.EventListenerHelper;
import com.mongodb.internal.session.ServerSessionPool;
import com.mongodb.lang.Nullable;
import java.util.Collections;
import java.util.List;
import org.bson.BsonDocument;
import org.bson.Document;
import org.bson.UuidRepresentation;
import org.bson.codecs.configuration.CodecRegistries;
import org.bson.codecs.configuration.CodecRegistry;
import org.bson.conversions.Bson;

public final class MongoClientImpl
implements MongoClient {
    private static final Logger LOGGER = Loggers.getLogger((String)"client");
    private final MongoClientSettings settings;
    private final MongoDriverInformation mongoDriverInformation;
    private final MongoClientDelegate delegate;

    public MongoClientImpl(MongoClientSettings settings, MongoDriverInformation mongoDriverInformation) {
        this(MongoClientImpl.createCluster(settings, mongoDriverInformation), mongoDriverInformation, settings, null);
    }

    public MongoClientImpl(Cluster cluster, MongoDriverInformation mongoDriverInformation, MongoClientSettings settings, @Nullable OperationExecutor operationExecutor) {
        this.settings = (MongoClientSettings)Assertions.notNull((String)"settings", (Object)settings);
        this.mongoDriverInformation = mongoDriverInformation;
        AutoEncryptionSettings autoEncryptionSettings = settings.getAutoEncryptionSettings();
        if (settings.getContextProvider() != null && !(settings.getContextProvider() instanceof SynchronousContextProvider)) {
            throw new IllegalArgumentException("The contextProvider must be an instance of " + SynchronousContextProvider.class.getName() + " when using the synchronous driver");
        }
        this.delegate = new MongoClientDelegate((Cluster)Assertions.notNull((String)"cluster", (Object)cluster), CodecRegistries.withUuidRepresentation((CodecRegistry)settings.getCodecRegistry(), (UuidRepresentation)settings.getUuidRepresentation()), this, operationExecutor, autoEncryptionSettings == null ? null : Crypts.createCrypt(this, autoEncryptionSettings), settings.getServerApi(), (SynchronousContextProvider)settings.getContextProvider());
        LOGGER.info(String.format("MongoClient with metadata %s created with settings %s", ClientMetadataHelper.createClientMetadataDocument((String)settings.getApplicationName(), (MongoDriverInformation)mongoDriverInformation).toJson(), settings));
    }

    @Override
    public MongoDatabase getDatabase(String databaseName) {
        return new MongoDatabaseImpl(databaseName, this.delegate.getCodecRegistry(), this.settings.getReadPreference(), this.settings.getWriteConcern(), this.settings.getRetryWrites(), this.settings.getRetryReads(), this.settings.getReadConcern(), this.settings.getUuidRepresentation(), this.settings.getAutoEncryptionSettings(), this.delegate.getOperationExecutor());
    }

    @Override
    public MongoIterable<String> listDatabaseNames() {
        return this.createListDatabaseNamesIterable(null);
    }

    @Override
    public MongoIterable<String> listDatabaseNames(ClientSession clientSession) {
        Assertions.notNull((String)"clientSession", (Object)clientSession);
        return this.createListDatabaseNamesIterable(clientSession);
    }

    @Override
    public ListDatabasesIterable<Document> listDatabases() {
        return this.listDatabases((Class<T>)Document.class);
    }

    public <T> ListDatabasesIterable<T> listDatabases(Class<T> clazz) {
        return this.createListDatabasesIterable(null, clazz);
    }

    @Override
    public ListDatabasesIterable<Document> listDatabases(ClientSession clientSession) {
        return this.listDatabases(clientSession, (Class<T>)Document.class);
    }

    public <T> ListDatabasesIterable<T> listDatabases(ClientSession clientSession, Class<T> clazz) {
        Assertions.notNull((String)"clientSession", (Object)clientSession);
        return this.createListDatabasesIterable(clientSession, clazz);
    }

    @Override
    public ClientSession startSession() {
        return this.startSession(ClientSessionOptions.builder().defaultTransactionOptions(TransactionOptions.builder().readConcern(this.settings.getReadConcern()).writeConcern(this.settings.getWriteConcern()).build()).build());
    }

    @Override
    public ClientSession startSession(ClientSessionOptions options) {
        ClientSession clientSession = this.delegate.createClientSession((ClientSessionOptions)Assertions.notNull((String)"options", (Object)options), this.settings.getReadConcern(), this.settings.getWriteConcern(), this.settings.getReadPreference());
        if (clientSession == null) {
            throw new MongoClientException("Sessions are not supported by the MongoDB cluster to which this client is connected");
        }
        return clientSession;
    }

    @Override
    public void close() {
        this.delegate.close();
    }

    @Override
    public ChangeStreamIterable<Document> watch() {
        return this.watch(Collections.emptyList());
    }

    @Override
    public <TResult> ChangeStreamIterable<TResult> watch(Class<TResult> resultClass) {
        return this.watch(Collections.emptyList(), resultClass);
    }

    @Override
    public ChangeStreamIterable<Document> watch(List<? extends Bson> pipeline) {
        return this.watch(pipeline, Document.class);
    }

    @Override
    public <TResult> ChangeStreamIterable<TResult> watch(List<? extends Bson> pipeline, Class<TResult> resultClass) {
        return this.createChangeStreamIterable(null, pipeline, resultClass);
    }

    @Override
    public ChangeStreamIterable<Document> watch(ClientSession clientSession) {
        return this.watch(clientSession, Collections.emptyList(), Document.class);
    }

    @Override
    public <TResult> ChangeStreamIterable<TResult> watch(ClientSession clientSession, Class<TResult> resultClass) {
        return this.watch(clientSession, Collections.emptyList(), resultClass);
    }

    @Override
    public ChangeStreamIterable<Document> watch(ClientSession clientSession, List<? extends Bson> pipeline) {
        return this.watch(clientSession, pipeline, Document.class);
    }

    @Override
    public <TResult> ChangeStreamIterable<TResult> watch(ClientSession clientSession, List<? extends Bson> pipeline, Class<TResult> resultClass) {
        Assertions.notNull((String)"clientSession", (Object)clientSession);
        return this.createChangeStreamIterable(clientSession, pipeline, resultClass);
    }

    @Override
    public ClusterDescription getClusterDescription() {
        return this.delegate.getCluster().getCurrentDescription();
    }

    private <TResult> ChangeStreamIterable<TResult> createChangeStreamIterable(@Nullable ClientSession clientSession, List<? extends Bson> pipeline, Class<TResult> resultClass) {
        return new ChangeStreamIterableImpl<TResult>(clientSession, "admin", this.settings.getCodecRegistry(), this.settings.getReadPreference(), this.settings.getReadConcern(), this.delegate.getOperationExecutor(), pipeline, resultClass, ChangeStreamLevel.CLIENT, this.settings.getRetryReads());
    }

    public Cluster getCluster() {
        return this.delegate.getCluster();
    }

    public CodecRegistry getCodecRegistry() {
        return this.delegate.getCodecRegistry();
    }

    private static Cluster createCluster(MongoClientSettings settings, @Nullable MongoDriverInformation mongoDriverInformation) {
        Assertions.notNull((String)"settings", (Object)settings);
        return new DefaultClusterFactory().createCluster(settings.getClusterSettings(), settings.getServerSettings(), settings.getConnectionPoolSettings(), InternalConnectionPoolSettings.builder().build(), MongoClientImpl.getStreamFactory(settings, false), MongoClientImpl.getStreamFactory(settings, true), settings.getCredential(), EventListenerHelper.getCommandListener((List)settings.getCommandListeners()), settings.getApplicationName(), mongoDriverInformation, settings.getCompressorList(), settings.getServerApi());
    }

    private static StreamFactory getStreamFactory(MongoClientSettings settings, boolean isHeartbeat) {
        SocketSettings socketSettings;
        StreamFactoryFactory streamFactoryFactory = settings.getStreamFactoryFactory();
        SocketSettings socketSettings2 = socketSettings = isHeartbeat ? settings.getHeartbeatSocketSettings() : settings.getSocketSettings();
        if (streamFactoryFactory == null) {
            return new SocketStreamFactory(socketSettings, settings.getSslSettings());
        }
        return streamFactoryFactory.create(socketSettings, settings.getSslSettings());
    }

    private <T> ListDatabasesIterable<T> createListDatabasesIterable(@Nullable ClientSession clientSession, Class<T> clazz) {
        return new ListDatabasesIterableImpl<T>(clientSession, clazz, this.delegate.getCodecRegistry(), ReadPreference.primary(), this.delegate.getOperationExecutor(), this.settings.getRetryReads());
    }

    private MongoIterable<String> createListDatabaseNamesIterable(@Nullable ClientSession clientSession) {
        return this.createListDatabasesIterable(clientSession, BsonDocument.class).nameOnly(true).map(new Function<BsonDocument, String>(){

            public String apply(BsonDocument result) {
                return result.getString((Object)"name").getValue();
            }
        });
    }

    public ServerSessionPool getServerSessionPool() {
        return this.delegate.getServerSessionPool();
    }

    public OperationExecutor getOperationExecutor() {
        return this.delegate.getOperationExecutor();
    }

    public MongoClientSettings getSettings() {
        return this.settings;
    }

    public MongoDriverInformation getMongoDriverInformation() {
        return this.mongoDriverInformation;
    }
}

