/*
 * Decompiled with CFR 0.152.
 */
package io.apicurio.registry.types;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonValue;
import io.quarkus.runtime.annotations.RegisterForReflection;
import java.util.HashMap;
import java.util.Map;

@RegisterForReflection
public enum RoleType {
    READ_ONLY("READ_ONLY"),
    DEVELOPER("DEVELOPER"),
    ADMIN("ADMIN");

    private final String value;
    private static final Map<String, RoleType> CONSTANTS;

    private RoleType(String value) {
        this.value = value;
    }

    public String toString() {
        return this.value;
    }

    @JsonValue
    public String value() {
        return this.value;
    }

    @JsonCreator
    public static RoleType fromValue(String value) {
        RoleType constant = CONSTANTS.get(value);
        if (constant == null) {
            throw new IllegalArgumentException(value);
        }
        return constant;
    }

    static {
        CONSTANTS = new HashMap<String, RoleType>();
        for (RoleType c : RoleType.values()) {
            CONSTANTS.put(c.value, c);
        }
    }
}

