/*
 * Decompiled with CFR 0.152.
 */
package io.apicurio.rest.client.handler;

import com.fasterxml.jackson.core.JacksonException;
import com.fasterxml.jackson.core.JsonParseException;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.JsonNode;
import java.io.IOException;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;

public class RegistryDateDeserializer
extends JsonDeserializer<Date> {
    private static final SimpleDateFormat DATE_FORMATTER = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ssZ");

    public Date deserialize(JsonParser parser, DeserializationContext context) throws IOException, JacksonException {
        JsonNode node = (JsonNode)parser.getCodec().readTree(parser);
        String date = node.textValue();
        if (date != null && date.endsWith("Z")) {
            date = date.replace("Z", "+0000");
        }
        try {
            return DATE_FORMATTER.parse(date);
        }
        catch (ParseException parseException) {
            throw new JsonParseException(parser, "Failed to parse date (not a supported format).");
        }
    }
}

