/*
 * Decompiled with CFR 0.152.
 */
package io.apicurio.datamodels.cmd.commands;

import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import io.apicurio.datamodels.cmd.AbstractCommand;
import io.apicurio.datamodels.cmd.ICommand;
import io.apicurio.datamodels.compat.LoggerCompat;
import io.apicurio.datamodels.compat.MarshallCompat;
import io.apicurio.datamodels.core.models.Document;
import java.util.List;

public class AggregateCommand
extends AbstractCommand {
    public String name;
    @JsonDeserialize(using=MarshallCompat.NullableJsonNodeDeserializer.class)
    public Object info;
    @JsonSerialize(using=MarshallCompat.CommandListSerializer.class)
    @JsonDeserialize(using=MarshallCompat.CommandListDeserializer.class)
    public List<ICommand> _commands;

    AggregateCommand() {
    }

    AggregateCommand(String name, Object info, List<ICommand> commands) {
        this.name = name;
        this.info = info;
        this._commands = commands;
    }

    @Override
    public void execute(Document document) {
        LoggerCompat.info("[AggregateCommand] Executing %d child commands.", this._commands.size());
        this._commands.forEach(command -> command.execute(document));
    }

    @Override
    public void undo(Document document) {
        LoggerCompat.info("[AggregateCommand] Reverting %d child commands.", this._commands.size());
        for (int idx = this._commands.size() - 1; idx >= 0; --idx) {
            ICommand command = this._commands.get(idx);
            command.undo(document);
        }
    }
}

