/*
 * Decompiled with CFR 0.152.
 */
package io.apicurio.datamodels.cmd.commands;

import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.node.ObjectNode;
import io.apicurio.datamodels.Library;
import io.apicurio.datamodels.cmd.AbstractCommand;
import io.apicurio.datamodels.cmd.util.ModelUtils;
import io.apicurio.datamodels.compat.JsonCompat;
import io.apicurio.datamodels.compat.LoggerCompat;
import io.apicurio.datamodels.compat.MarshallCompat;
import io.apicurio.datamodels.core.models.Document;
import io.apicurio.datamodels.core.models.Node;
import io.apicurio.datamodels.core.models.NodePath;
import io.apicurio.datamodels.core.models.common.IPropertyParent;
import io.apicurio.datamodels.core.models.common.Schema;
import java.util.ArrayList;
import java.util.List;

public class DeleteAllPropertiesCommand
extends AbstractCommand {
    public NodePath _schemaPath;
    @JsonDeserialize(contentUsing=MarshallCompat.NullableJsonNodeDeserializer.class)
    public List<Object> _oldProperties;

    DeleteAllPropertiesCommand() {
    }

    DeleteAllPropertiesCommand(IPropertyParent schema) {
        this._schemaPath = Library.createNodePath((Node)((Object)schema));
    }

    @Override
    public void execute(Document document) {
        LoggerCompat.info("[DeleteAllPropertiesCommand] Executing.", new Object[0]);
        this._oldProperties = new ArrayList<Object>();
        IPropertyParent schema = (IPropertyParent)((Object)this._schemaPath.resolve(document));
        if (this.isNullOrUndefined(schema)) {
            return;
        }
        schema.getPropertyNames().forEach(pname -> {
            ObjectNode data = JsonCompat.objectNode();
            JsonCompat.setPropertyString(data, "name", pname);
            JsonCompat.setProperty(data, "schema", Library.writeNode(schema.removeProperty((String)pname)));
            JsonCompat.setPropertyBoolean(data, "required", schema.isPropertyRequired((String)pname));
            schema.unsetPropertyRequired((String)pname);
            this._oldProperties.add(data);
        });
    }

    @Override
    public void undo(Document document) {
        LoggerCompat.info("[DeleteAllPropertiesCommand] Reverting.", new Object[0]);
        if (this.isNullOrUndefined(this._oldProperties) || this._oldProperties.size() == 0) {
            return;
        }
        IPropertyParent schema = (IPropertyParent)((Object)this._schemaPath.resolve(document));
        if (this.isNullOrUndefined(schema)) {
            return;
        }
        this._oldProperties.forEach(oldProp -> {
            String name = JsonCompat.getPropertyString(oldProp, "name");
            Object schemaObj = JsonCompat.getProperty(oldProp, "schema");
            Boolean required = JsonCompat.getPropertyBoolean(oldProp, "required");
            Schema prop = schema.createPropertySchema(name);
            Library.readNode(schemaObj, prop);
            schema.addProperty(name, prop);
            if (ModelUtils.isDefined(required) && required == Boolean.TRUE) {
                schema.setPropertyRequired(name);
            }
        });
    }
}

