/*
 * Decompiled with CFR 0.152.
 */
package io.apicurio.datamodels.cmd.commands;

import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import io.apicurio.datamodels.Library;
import io.apicurio.datamodels.cmd.AbstractCommand;
import io.apicurio.datamodels.compat.LoggerCompat;
import io.apicurio.datamodels.compat.MarshallCompat;
import io.apicurio.datamodels.core.models.Document;
import io.apicurio.datamodels.core.models.Node;
import io.apicurio.datamodels.core.models.NodePath;
import io.apicurio.datamodels.core.models.common.IExample;
import io.apicurio.datamodels.core.models.common.IExamplesParent;
import io.apicurio.datamodels.openapi.v3.models.Oas30Example;
import io.apicurio.datamodels.openapi.v3.models.Oas30MediaType;

public class DeleteExampleCommand_30
extends AbstractCommand {
    public String _exampleName;
    public NodePath _mediaTypePath;
    @JsonDeserialize(using=MarshallCompat.NullableJsonNodeDeserializer.class)
    public Object _oldExample;

    DeleteExampleCommand_30() {
    }

    DeleteExampleCommand_30(Oas30Example example) {
        this._exampleName = example.getName();
        this._mediaTypePath = Library.createNodePath(example.parent());
    }

    @Override
    public void execute(Document document) {
        LoggerCompat.info("[DeleteExampleCommand] Executing.", new Object[0]);
        this._oldExample = null;
        IExamplesParent parent = (IExamplesParent)((Object)this._mediaTypePath.resolve(document));
        if (this.isNullOrUndefined(parent) || this.isNullOrUndefined(parent.getExample(this._exampleName))) {
            LoggerCompat.debug("[DeleteExampleCommand] No example named: " + this._exampleName, new Object[0]);
            return;
        }
        IExample example = parent.removeExample(this._exampleName);
        this._oldExample = Library.writeNode((Node)((Object)example));
    }

    @Override
    public void undo(Document document) {
        LoggerCompat.info("[DeleteExampleCommand] Reverting.", new Object[0]);
        if (this.isNullOrUndefined(this._oldExample)) {
            return;
        }
        Oas30MediaType mediaType = (Oas30MediaType)this._mediaTypePath.resolve(document);
        if (this.isNullOrUndefined(mediaType)) {
            LoggerCompat.info("[DeleteExampleCommand] No media type found.", new Object[0]);
            return;
        }
        IExample example = mediaType.createExample(this._exampleName);
        Library.readNode(this._oldExample, (Node)((Object)example));
        mediaType.addExample(example);
    }
}

