/*
 * Decompiled with CFR 0.152.
 */
package io.apicurio.datamodels.cmd.commands;

import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import io.apicurio.datamodels.Library;
import io.apicurio.datamodels.cmd.AbstractCommand;
import io.apicurio.datamodels.compat.LoggerCompat;
import io.apicurio.datamodels.compat.MarshallCompat;
import io.apicurio.datamodels.compat.NodeCompat;
import io.apicurio.datamodels.core.models.Document;
import io.apicurio.datamodels.core.models.common.Tag;
import java.util.ArrayList;
import java.util.List;

public class DeleteTagCommand
extends AbstractCommand {
    public String _tagName;
    public int _oldIndex;
    @JsonDeserialize(using=MarshallCompat.NullableJsonNodeDeserializer.class)
    public Object _oldTag;

    DeleteTagCommand() {
    }

    DeleteTagCommand(String tagName) {
        this._tagName = tagName;
    }

    @Override
    public void execute(Document document) {
        LoggerCompat.info("[DeleteTagCommand] Executing.", new Object[0]);
        if (this.isNullOrUndefined(document.tags)) {
            return;
        }
        List<Tag> tags = document.tags;
        Tag tag = null;
        for (Tag t : tags) {
            if (!NodeCompat.equals(t.name, this._tagName)) continue;
            tag = t;
        }
        this._oldIndex = tags.indexOf(tag);
        tags.remove(this._oldIndex);
        this._oldTag = Library.writeNode(tag);
    }

    @Override
    public void undo(Document document) {
        LoggerCompat.info("[DeleteTagCommand] Reverting.", new Object[0]);
        if (this.isNullOrUndefined(document.tags)) {
            document.tags = new ArrayList<Tag>();
        }
        Tag tag = document.createTag();
        Library.readNode(this._oldTag, tag);
        if (document.tags.size() >= this._oldIndex) {
            document.tags.add(this._oldIndex, tag);
        } else {
            document.tags.add(tag);
        }
    }
}

