/*
 * Decompiled with CFR 0.152.
 */
package io.apicurio.datamodels.cmd.commands;

import io.apicurio.datamodels.cmd.commands.NewRequestBodyCommand;
import io.apicurio.datamodels.cmd.util.ModelUtils;
import io.apicurio.datamodels.compat.NodeCompat;
import io.apicurio.datamodels.openapi.models.OasOperation;
import io.apicurio.datamodels.openapi.models.OasParameter;
import io.apicurio.datamodels.openapi.v2.models.Oas20Parameter;
import java.util.ArrayList;
import java.util.List;

public class NewRequestBodyCommand_20
extends NewRequestBodyCommand {
    NewRequestBodyCommand_20() {
    }

    NewRequestBodyCommand_20(OasOperation operation) {
        super(operation);
    }

    @Override
    protected boolean hasRequestBody(OasOperation operation) {
        return ModelUtils.isDefined(operation) && operation.getParametersIn("body").size() > 0;
    }

    @Override
    protected void doCreateRequestBody(OasOperation operation) {
        if (this.isNullOrUndefined(operation.parameters)) {
            operation.parameters = new ArrayList<OasParameter>();
        }
        Oas20Parameter param = (Oas20Parameter)operation.createParameter();
        param.in = "body";
        param.name = "body";
        operation.addParameter(param);
    }

    @Override
    protected void doRemoveRequestBody(OasOperation operation) {
        List<OasParameter> parameters = operation.getParameters();
        List<OasParameter> bodyParams = operation.getParametersIn("body");
        for (OasParameter bodyParam : bodyParams) {
            parameters.remove(parameters.indexOf(bodyParam));
        }
        parameters = operation.getParameters();
        if (parameters.size() == 0) {
            NodeCompat.setProperty(operation, "parameters", null);
        }
    }
}

