/*
 * Decompiled with CFR 0.152.
 */
package io.apicurio.datamodels.cmd.util;

import io.apicurio.datamodels.asyncapi.models.AaiSchema;
import io.apicurio.datamodels.cmd.models.SimplifiedType;
import io.apicurio.datamodels.cmd.util.ModelUtils;
import io.apicurio.datamodels.combined.visitors.CombinedVisitorAdapter;
import io.apicurio.datamodels.core.models.DocumentType;
import io.apicurio.datamodels.core.models.common.IDefinition;
import io.apicurio.datamodels.core.models.common.IPropertySchema;
import io.apicurio.datamodels.core.models.common.Parameter;
import io.apicurio.datamodels.core.models.common.Schema;
import io.apicurio.datamodels.openapi.models.OasSchema;
import io.apicurio.datamodels.openapi.v2.models.Oas20Parameter;

public class SetItemsTypeVisitor
extends CombinedVisitorAdapter {
    private SimplifiedType type;

    public SetItemsTypeVisitor(SimplifiedType type) {
        this.type = type;
    }

    @Override
    public void visitSchema(Schema node) {
        if (node.ownerDocument().getDocumentType() == DocumentType.asyncapi2) {
            this.setItems((AaiSchema)node);
        } else {
            this.setItems((OasSchema)node);
        }
    }

    private void setItems(OasSchema node) {
        OasSchema schema = node;
        schema.items = schema.createItemsSchema();
        if (ModelUtils.isDefined(this.type.of)) {
            OasSchema items = (OasSchema)schema.items;
            if (this.type.of.isRef()) {
                items.$ref = this.type.of.type;
            } else {
                items.type = this.type.of.type;
                items.format = this.type.of.as;
            }
        }
    }

    private void setItems(AaiSchema node) {
        AaiSchema schema = node;
        schema.items = schema.createItemsSchema();
        if (ModelUtils.isDefined(this.type.of)) {
            AaiSchema items = (AaiSchema)schema.items;
            if (this.type.of.isRef()) {
                items.$ref = this.type.of.type;
            } else {
                items.type = this.type.of.type;
                items.format = this.type.of.as;
            }
        }
    }

    @Override
    public void visitParameter(Parameter node) {
        if (node.ownerDocument().getDocumentType() == DocumentType.openapi2) {
            Oas20Parameter param = (Oas20Parameter)node;
            param.items = param.createItems();
            if (ModelUtils.isDefined(this.type.of)) {
                param.items.type = this.type.of.type;
                param.items.format = this.type.of.as;
            }
        }
    }

    @Override
    public void visitSchemaDefinition(IDefinition node) {
        this.visitSchema((Schema)((Object)node));
    }

    @Override
    public void visitPropertySchema(IPropertySchema node) {
        this.visitSchema((Schema)((Object)node));
    }

    @Override
    public void visitAdditionalPropertiesSchema(OasSchema node) {
        this.visitSchema(node);
    }

    @Override
    public void visitAllOfSchema(OasSchema node) {
        this.visitSchema(node);
    }

    @Override
    public void visitItemsSchema(OasSchema node) {
        this.visitSchema(node);
    }

    @Override
    public void visitParameterDefinition(IDefinition node) {
        this.visitParameter((Parameter)((Object)node));
    }
}

