/*
 * Decompiled with CFR 0.152.
 */
package io.apicurio.datamodels.core.factories;

import io.apicurio.datamodels.asyncapi.v2.io.Aai20DataModelReader;
import io.apicurio.datamodels.asyncapi.v2.io.Aai20DataModelReaderDispatcher;
import io.apicurio.datamodels.asyncapi.v2.io.Aai20DataModelWriter;
import io.apicurio.datamodels.asyncapi.v2.models.Aai20NodeFactory;
import io.apicurio.datamodels.core.io.DataModelReader;
import io.apicurio.datamodels.core.io.DataModelReaderDispatcher;
import io.apicurio.datamodels.core.io.DataModelWriter;
import io.apicurio.datamodels.core.models.Document;
import io.apicurio.datamodels.core.models.DocumentType;
import io.apicurio.datamodels.core.validation.ValidationProblemsResetVisitor;
import io.apicurio.datamodels.core.validation.ValidationVisitor;
import io.apicurio.datamodels.openapi.v2.io.Oas20DataModelReader;
import io.apicurio.datamodels.openapi.v2.io.Oas20DataModelReaderDispatcher;
import io.apicurio.datamodels.openapi.v2.io.Oas20DataModelWriter;
import io.apicurio.datamodels.openapi.v3.io.Oas30DataModelReader;
import io.apicurio.datamodels.openapi.v3.io.Oas30DataModelReaderDispatcher;
import io.apicurio.datamodels.openapi.v3.io.Oas30DataModelWriter;

public class VisitorFactory {
    private static Aai20NodeFactory aai20NodeFactory = new Aai20NodeFactory();

    public static final ValidationProblemsResetVisitor createValidationProblemsResetVisitor(Document doc) {
        return new ValidationProblemsResetVisitor();
    }

    public static final ValidationVisitor createValidationVisitor(Document doc) {
        return new ValidationVisitor(doc);
    }

    public static final DataModelReader createDataModelReader(DocumentType type) {
        switch (type) {
            case asyncapi2: {
                return new Aai20DataModelReader(aai20NodeFactory);
            }
            case openapi2: {
                return new Oas20DataModelReader();
            }
            case openapi3: {
                return new Oas30DataModelReader();
            }
        }
        throw new RuntimeException("Failed to create a data model reader for type: " + (Object)((Object)type));
    }

    public static DataModelWriter createDataModelWriter(Document doc) {
        switch (doc.getDocumentType()) {
            case asyncapi2: {
                return new Aai20DataModelWriter();
            }
            case openapi2: {
                return new Oas20DataModelWriter();
            }
            case openapi3: {
                return new Oas30DataModelWriter();
            }
        }
        throw new RuntimeException("Failed to create a validation visitor for type: " + (Object)((Object)doc.getDocumentType()));
    }

    public static DataModelReaderDispatcher createDataModelReaderDispatcher(DocumentType type, Object json, DataModelReader reader) {
        switch (type) {
            case asyncapi2: {
                return new Aai20DataModelReaderDispatcher(json, (Aai20DataModelReader)reader);
            }
            case openapi2: {
                return new Oas20DataModelReaderDispatcher(json, (Oas20DataModelReader)reader);
            }
            case openapi3: {
                return new Oas30DataModelReaderDispatcher(json, (Oas30DataModelReader)reader);
            }
        }
        throw new RuntimeException("Failed to create a data model reader dispatcher for type: " + (Object)((Object)type));
    }
}

