/*
 * Decompiled with CFR 0.152.
 */
package io.apicurio.datamodels.core.models;

import io.apicurio.datamodels.core.models.DocumentType;
import io.apicurio.datamodels.core.models.ExtensibleNode;
import io.apicurio.datamodels.core.models.common.ExternalDocumentation;
import io.apicurio.datamodels.core.models.common.IExternalDocumentationParent;
import io.apicurio.datamodels.core.models.common.Info;
import io.apicurio.datamodels.core.models.common.Tag;
import io.apicurio.datamodels.core.visitors.IVisitor;
import java.util.ArrayList;
import java.util.List;

public abstract class Document
extends ExtensibleNode
implements IExternalDocumentationParent {
    public Info info;
    public List<Tag> tags;
    public ExternalDocumentation externalDocs;

    public Document() {
        this._ownerDocument = this;
        this._parent = null;
    }

    public abstract DocumentType getDocumentType();

    @Override
    public void accept(IVisitor visitor) {
        visitor.visitDocument(this);
    }

    public abstract Info createInfo();

    public abstract Tag createTag();

    public Tag addTag(String name, String description) {
        Tag tag = this.createTag();
        tag.name = name;
        tag.description = description;
        if (this.tags == null) {
            this.tags = new ArrayList<Tag>();
        }
        this.tags.add(tag);
        return tag;
    }

    @Override
    public abstract ExternalDocumentation createExternalDocumentation();

    @Override
    public void setExternalDocumentation(ExternalDocumentation externalDocs) {
        this.externalDocs = externalDocs;
    }

    public ExternalDocumentation setExternalDocumentation(String description, String url) {
        ExternalDocumentation ed = this.createExternalDocumentation();
        ed.description = description;
        ed.url = url;
        this.externalDocs = ed;
        return ed;
    }

    @Override
    public boolean isAttached() {
        return true;
    }
}

