/*
 * Decompiled with CFR 0.152.
 */
package io.apicurio.datamodels.core.validation.rules.invalid.value;

import io.apicurio.datamodels.core.models.common.Parameter;
import io.apicurio.datamodels.core.util.VisitorUtil;
import io.apicurio.datamodels.core.validation.ValidationRuleMetaData;
import io.apicurio.datamodels.core.validation.rules.invalid.value.OasInvalidPropertyValueRule;
import io.apicurio.datamodels.core.visitors.ConsumesProducesFinder;
import io.apicurio.datamodels.core.visitors.TraverserDirection;
import io.apicurio.datamodels.openapi.models.OasParameter;
import java.util.ArrayList;
import java.util.List;

public class OasFormDataParamNotAllowedRule
extends OasInvalidPropertyValueRule {
    public OasFormDataParamNotAllowedRule(ValidationRuleMetaData ruleInfo) {
        super(ruleInfo);
    }

    @Override
    public void visitParameter(Parameter node) {
        OasParameter param = (OasParameter)node;
        if (this.equals(param.in, "formData")) {
            ConsumesProducesFinder finder = new ConsumesProducesFinder();
            VisitorUtil.visitTree(node, finder, TraverserDirection.up);
            List<String> consumes = finder.consumes;
            if (!this.hasValue(consumes)) {
                consumes = new ArrayList<String>();
            }
            boolean valid = consumes.indexOf("application/x-www-form-urlencoded") >= 0 || consumes.indexOf("multipart/form-data") >= 0;
            this.reportIfInvalid(valid, node, "consumes", this.map(new String[0]));
        }
    }
}

