/*
 * Decompiled with CFR 0.152.
 */
package io.apicurio.datamodels.core.visitors;

import io.apicurio.datamodels.core.models.Document;
import io.apicurio.datamodels.core.models.ExtensibleNode;
import io.apicurio.datamodels.core.models.Extension;
import io.apicurio.datamodels.core.models.IIndexedNode;
import io.apicurio.datamodels.core.models.IVisitable;
import io.apicurio.datamodels.core.models.Node;
import io.apicurio.datamodels.core.models.ValidationProblem;
import io.apicurio.datamodels.core.models.common.Contact;
import io.apicurio.datamodels.core.models.common.ExternalDocumentation;
import io.apicurio.datamodels.core.models.common.IDefinition;
import io.apicurio.datamodels.core.models.common.Info;
import io.apicurio.datamodels.core.models.common.License;
import io.apicurio.datamodels.core.models.common.OAuthFlow;
import io.apicurio.datamodels.core.models.common.OAuthFlows;
import io.apicurio.datamodels.core.models.common.Operation;
import io.apicurio.datamodels.core.models.common.Parameter;
import io.apicurio.datamodels.core.models.common.Schema;
import io.apicurio.datamodels.core.models.common.SecurityRequirement;
import io.apicurio.datamodels.core.models.common.SecurityScheme;
import io.apicurio.datamodels.core.models.common.Tag;
import io.apicurio.datamodels.core.visitors.ITraverser;
import io.apicurio.datamodels.core.visitors.IVisitor;
import java.util.Collection;

public class Traverser
implements ITraverser,
IVisitor {
    protected IVisitor visitor;

    public Traverser(IVisitor visitor) {
        this.visitor = visitor;
    }

    protected void traverseCollection(Collection<? extends IVisitable> items) {
        if (items != null) {
            items.forEach(node -> this.traverseIfNotNull((IVisitable)node));
        }
    }

    protected void traverseExtensions(ExtensibleNode node) {
        this.traverseCollection(node.getExtensions());
    }

    protected void traverseIndexedNode(IIndexedNode<? extends Node> node) {
        this.traverseCollection(node.getItems());
    }

    protected void traverseValidationProblems(Node node) {
        this.traverseCollection(node.getValidationProblems());
    }

    @Override
    public void traverse(Node node) {
        node.accept(this);
    }

    protected void traverseIfNotNull(IVisitable node) {
        if (node != null) {
            node.accept(this);
        }
    }

    @Override
    public final void visitDocument(Document node) {
        node.accept(this.visitor);
        this.traverseDocument(node);
    }

    protected void traverseDocument(Document node) {
        this.traverseExtensions(node);
        this.traverseValidationProblems(node);
        this.traverseIfNotNull(node.info);
        this.traverseCollection(node.tags);
        this.traverseIfNotNull(node.externalDocs);
    }

    @Override
    public void visitExtension(Extension node) {
        node.accept(this.visitor);
        this.traverseValidationProblems(node);
    }

    @Override
    public void visitValidationProblem(ValidationProblem problem) {
        problem.accept(this.visitor);
    }

    @Override
    public void visitInfo(Info node) {
        node.accept(this.visitor);
        this.traverseIfNotNull(node.contact);
        this.traverseIfNotNull(node.license);
        this.traverseExtensions(node);
        this.traverseValidationProblems(node);
    }

    @Override
    public void visitContact(Contact node) {
        node.accept(this.visitor);
        this.traverseExtensions(node);
        this.traverseValidationProblems(node);
    }

    @Override
    public void visitLicense(License node) {
        node.accept(this.visitor);
        this.traverseExtensions(node);
        this.traverseValidationProblems(node);
    }

    @Override
    public void visitTag(Tag node) {
        node.accept(this.visitor);
        this.traverseIfNotNull(node.externalDocs);
        this.traverseExtensions(node);
        this.traverseValidationProblems(node);
    }

    @Override
    public void visitSecurityRequirement(SecurityRequirement node) {
        node.accept(this.visitor);
        this.traverseValidationProblems(node);
    }

    @Override
    public void visitExternalDocumentation(ExternalDocumentation node) {
        node.accept(this.visitor);
        this.traverseExtensions(node);
        this.traverseValidationProblems(node);
    }

    @Override
    public void visitSchema(Schema node) {
        node.accept(this.visitor);
        this.traverseSchema(node);
        this.traverseExtensions(node);
        this.traverseValidationProblems(node);
    }

    protected void traverseSchema(Schema node) {
    }

    @Override
    public void visitParameter(Parameter node) {
        node.accept(this.visitor);
        this.traverseParameter(node);
        this.traverseExtensions(node);
        this.traverseValidationProblems(node);
    }

    protected void traverseParameter(Parameter node) {
        this.traverseIfNotNull(node.schema);
    }

    @Override
    public void visitParameterDefinition(IDefinition node) {
        this.visitParameter((Parameter)((Object)node));
    }

    @Override
    public void visitOperation(Operation node) {
        node.accept(this.visitor);
        this.traverseOperation(node);
    }

    protected void traverseOperation(Operation node) {
        this.traverseExtensions(node);
        this.traverseValidationProblems(node);
        this.traverseIfNotNull(node.externalDocs);
    }

    @Override
    public void visitSecurityScheme(SecurityScheme node) {
        node.accept(this.visitor);
        this.traverseSecurityScheme(node);
        this.traverseExtensions(node);
        this.traverseValidationProblems(node);
    }

    protected void traverseSecurityScheme(SecurityScheme node) {
    }

    @Override
    public void visitSchemaDefinition(IDefinition node) {
        Schema schema = (Schema)((Object)node);
        this.visitSchema(schema);
    }

    protected void traverseOAuthFlow(OAuthFlow node) {
        node.accept(this.visitor);
        this.traverseExtensions(node);
        this.traverseValidationProblems(node);
    }

    protected void traverseOAuthFlows(OAuthFlows node) {
        node.accept(this.visitor);
        this.traverseIfNotNull(node.implicit);
        this.traverseIfNotNull(node.password);
        this.traverseIfNotNull(node.clientCredentials);
        this.traverseIfNotNull(node.authorizationCode);
        this.traverseExtensions(node);
        this.traverseValidationProblems(node);
    }
}

