/*
 * Decompiled with CFR 0.152.
 */
package io.apicurio.datamodels.openapi.v2.io;

import io.apicurio.datamodels.compat.JsonCompat;
import io.apicurio.datamodels.core.models.Document;
import io.apicurio.datamodels.core.models.common.Operation;
import io.apicurio.datamodels.core.models.common.Parameter;
import io.apicurio.datamodels.core.models.common.Schema;
import io.apicurio.datamodels.core.models.common.SecurityScheme;
import io.apicurio.datamodels.openapi.io.OasDataModelReader;
import io.apicurio.datamodels.openapi.models.OasHeader;
import io.apicurio.datamodels.openapi.models.OasResponse;
import io.apicurio.datamodels.openapi.v2.models.Oas20Definitions;
import io.apicurio.datamodels.openapi.v2.models.Oas20Document;
import io.apicurio.datamodels.openapi.v2.models.Oas20Example;
import io.apicurio.datamodels.openapi.v2.models.Oas20Header;
import io.apicurio.datamodels.openapi.v2.models.Oas20Headers;
import io.apicurio.datamodels.openapi.v2.models.Oas20Items;
import io.apicurio.datamodels.openapi.v2.models.Oas20Operation;
import io.apicurio.datamodels.openapi.v2.models.Oas20Parameter;
import io.apicurio.datamodels.openapi.v2.models.Oas20ParameterDefinition;
import io.apicurio.datamodels.openapi.v2.models.Oas20ParameterDefinitions;
import io.apicurio.datamodels.openapi.v2.models.Oas20Response;
import io.apicurio.datamodels.openapi.v2.models.Oas20ResponseDefinition;
import io.apicurio.datamodels.openapi.v2.models.Oas20ResponseDefinitions;
import io.apicurio.datamodels.openapi.v2.models.Oas20Schema;
import io.apicurio.datamodels.openapi.v2.models.Oas20SchemaDefinition;
import io.apicurio.datamodels.openapi.v2.models.Oas20Scopes;
import io.apicurio.datamodels.openapi.v2.models.Oas20SecurityDefinitions;
import io.apicurio.datamodels.openapi.v2.models.Oas20SecurityScheme;
import java.util.List;

public class Oas20DataModelReader
extends OasDataModelReader {
    @Override
    public void readDocument(Object json, Document node) {
        Oas20Document doc = (Oas20Document)node;
        JsonCompat.consumePropertyString(json, "swagger");
        String host = JsonCompat.consumePropertyString(json, "host");
        String basePath = JsonCompat.consumePropertyString(json, "basePath");
        List<String> schemes = JsonCompat.consumePropertyStringArray(json, "schemes");
        List<String> consumes = JsonCompat.consumePropertyStringArray(json, "consumes");
        List<String> produces = JsonCompat.consumePropertyStringArray(json, "produces");
        Object definitions = JsonCompat.consumeProperty(json, "definitions");
        Object parameters = JsonCompat.consumeProperty(json, "parameters");
        Object responses = JsonCompat.consumeProperty(json, "responses");
        Object securityDefinitions = JsonCompat.consumeProperty(json, "securityDefinitions");
        doc.host = host;
        doc.basePath = basePath;
        doc.schemes = schemes;
        doc.consumes = consumes;
        doc.produces = produces;
        if (definitions != null) {
            doc.definitions = doc.createDefinitions();
            this.readDefinitions(definitions, doc.definitions);
        }
        if (parameters != null) {
            doc.parameters = doc.createParameterDefinitions();
            this.readParameterDefinitions(parameters, doc.parameters);
        }
        if (responses != null) {
            doc.responses = doc.createResponseDefinitions();
            this.readResponseDefinitions(responses, doc.responses);
        }
        if (securityDefinitions != null) {
            doc.securityDefinitions = doc.createSecurityDefinitions();
            this.readSecurityDefinitions(securityDefinitions, doc.securityDefinitions);
        }
        super.readDocument(json, doc);
    }

    public void readDefinitions(Object json, Oas20Definitions node) {
        List<String> names = JsonCompat.keys(json);
        for (String name : names) {
            Object definition = JsonCompat.consumeProperty(json, name);
            Oas20SchemaDefinition definitionModel = node.createSchemaDefinition(name);
            this.readSchema(definition, definitionModel);
            node.addDefinition(name, definitionModel);
        }
    }

    public void readParameterDefinitions(Object json, Oas20ParameterDefinitions node) {
        List<String> names = JsonCompat.keys(json);
        for (String name : names) {
            Object definition = JsonCompat.consumeProperty(json, name);
            Oas20ParameterDefinition definitionModel = node.createParameter(name);
            this.readParameterDefinition(definition, definitionModel);
            node.addParameter(name, definitionModel);
        }
    }

    public void readResponseDefinitions(Object json, Oas20ResponseDefinitions node) {
        List<String> names = JsonCompat.keys(json);
        for (String name : names) {
            Object definition = JsonCompat.consumeProperty(json, name);
            Oas20ResponseDefinition definitionModel = node.createResponse(name);
            this.readResponseDefinition(definition, definitionModel);
            node.addResponse(name, definitionModel);
        }
    }

    public void readParameterDefinition(Object json, Oas20ParameterDefinition node) {
        this.readParameter(json, node);
    }

    public void readResponseDefinition(Object json, Oas20ResponseDefinition node) {
        this.readResponse(json, node);
    }

    @Override
    public void readResponse(Object json, OasResponse node) {
        Oas20Response response = (Oas20Response)node;
        Object headers = JsonCompat.consumeProperty(json, "headers");
        Object schema = JsonCompat.consumeProperty(json, "schema");
        Object examples = JsonCompat.consumeProperty(json, "examples");
        if (headers != null) {
            response.headers = response.createHeaders();
            this.readHeaders(headers, response.headers);
        }
        if (schema != null) {
            response.schema = response.createSchema();
            this.readSchema(schema, response.schema);
        }
        if (examples != null) {
            response.examples = response.createExample();
            this.readExample(examples, response.examples);
        }
        super.readResponse(json, node);
    }

    public void readHeaders(Object json, Oas20Headers node) {
        List<String> names = JsonCompat.keys(json);
        for (String name : names) {
            Object definition = JsonCompat.consumeProperty(json, name);
            Oas20Header definitionModel = node.createHeader(name);
            this.readHeader(definition, definitionModel);
            node.addHeader(name, definitionModel);
        }
    }

    @Override
    public void readHeader(Object json, OasHeader node) {
        Oas20Header header = (Oas20Header)node;
        String type = JsonCompat.consumePropertyString(json, "type");
        String format = JsonCompat.consumePropertyString(json, "format");
        Object items = JsonCompat.consumeProperty(json, "items");
        String collectionFormat = JsonCompat.consumePropertyString(json, "collectionFormat");
        Object default_ = JsonCompat.consumePropertyObject(json, "default");
        Number maximum = JsonCompat.consumePropertyNumber(json, "maximum");
        Boolean exclusiveMaximum = JsonCompat.consumePropertyBoolean(json, "exclusiveMaximum");
        Number minimum = JsonCompat.consumePropertyNumber(json, "minimum");
        Boolean exclusiveMinimum = JsonCompat.consumePropertyBoolean(json, "exclusiveMinimum");
        Number maxLength = JsonCompat.consumePropertyNumber(json, "maxLength");
        Number minLength = JsonCompat.consumePropertyNumber(json, "minLength");
        String pattern = JsonCompat.consumePropertyString(json, "pattern");
        Number maxItems = JsonCompat.consumePropertyNumber(json, "maxItems");
        Number minItems = JsonCompat.consumePropertyNumber(json, "minItems");
        Boolean uniqueItems = JsonCompat.consumePropertyBoolean(json, "uniqueItems");
        List<String> enum_ = JsonCompat.consumePropertyStringArray(json, "enum");
        Number multipleOf = JsonCompat.consumePropertyNumber(json, "multipleOf");
        header.type = type;
        header.format = format;
        header.collectionFormat = collectionFormat;
        header.default_ = default_;
        header.maximum = maximum;
        header.exclusiveMaximum = exclusiveMaximum;
        header.minimum = minimum;
        header.exclusiveMinimum = exclusiveMinimum;
        header.maxLength = maxLength;
        header.minLength = minLength;
        header.pattern = pattern;
        header.maxItems = maxItems;
        header.minItems = minItems;
        header.uniqueItems = uniqueItems;
        header.enum_ = enum_;
        header.multipleOf = multipleOf;
        if (items != null) {
            header.items = header.createItems();
            this.readItems(items, header.items);
        }
        super.readHeader(json, header);
    }

    public void readExample(Object json, Oas20Example node) {
        List<String> contentTypes = JsonCompat.keys(json);
        contentTypes.forEach(ct -> {
            Object example = JsonCompat.consumePropertyObject(json, ct);
            node.addExample((String)ct, example);
        });
    }

    @Override
    public void readParameter(Object json, Parameter node) {
        Oas20Parameter param = (Oas20Parameter)node;
        String type = JsonCompat.consumePropertyString(json, "type");
        String format = JsonCompat.consumePropertyString(json, "format");
        Object items = JsonCompat.consumeProperty(json, "items");
        String collectionFormat = JsonCompat.consumePropertyString(json, "collectionFormat");
        Object default_ = JsonCompat.consumePropertyObject(json, "default");
        Number maximum = JsonCompat.consumePropertyNumber(json, "maximum");
        Boolean exclusiveMaximum = JsonCompat.consumePropertyBoolean(json, "exclusiveMaximum");
        Number minimum = JsonCompat.consumePropertyNumber(json, "minimum");
        Boolean exclusiveMinimum = JsonCompat.consumePropertyBoolean(json, "exclusiveMinimum");
        Number maxLength = JsonCompat.consumePropertyNumber(json, "maxLength");
        Number minLength = JsonCompat.consumePropertyNumber(json, "minLength");
        String pattern = JsonCompat.consumePropertyString(json, "pattern");
        Number maxItems = JsonCompat.consumePropertyNumber(json, "maxItems");
        Number minItems = JsonCompat.consumePropertyNumber(json, "minItems");
        Boolean uniqueItems = JsonCompat.consumePropertyBoolean(json, "uniqueItems");
        List<String> enum_ = JsonCompat.consumePropertyStringArray(json, "enum");
        Number multipleOf = JsonCompat.consumePropertyNumber(json, "multipleOf");
        param.type = type;
        param.format = format;
        param.collectionFormat = collectionFormat;
        param.default_ = default_;
        param.maximum = maximum;
        param.exclusiveMaximum = exclusiveMaximum;
        param.minimum = minimum;
        param.exclusiveMinimum = exclusiveMinimum;
        param.maxLength = maxLength;
        param.minLength = minLength;
        param.pattern = pattern;
        param.maxItems = maxItems;
        param.minItems = minItems;
        param.uniqueItems = uniqueItems;
        param.enum_ = enum_;
        param.multipleOf = multipleOf;
        if (items != null) {
            param.items = param.createItems();
            this.readItems(items, param.items);
        }
        super.readParameter(json, node);
    }

    public void readItems(Object json, Oas20Items node) {
        String type = JsonCompat.consumePropertyString(json, "type");
        String format = JsonCompat.consumePropertyString(json, "format");
        Object items = JsonCompat.consumeProperty(json, "items");
        String collectionFormat = JsonCompat.consumePropertyString(json, "collectionFormat");
        Object default_ = JsonCompat.consumePropertyObject(json, "default");
        Number maximum = JsonCompat.consumePropertyNumber(json, "maximum");
        Boolean exclusiveMaximum = JsonCompat.consumePropertyBoolean(json, "exclusiveMaximum");
        Number minimum = JsonCompat.consumePropertyNumber(json, "minimum");
        Boolean exclusiveMinimum = JsonCompat.consumePropertyBoolean(json, "exclusiveMinimum");
        Number maxLength = JsonCompat.consumePropertyNumber(json, "maxLength");
        Number minLength = JsonCompat.consumePropertyNumber(json, "minLength");
        String pattern = JsonCompat.consumePropertyString(json, "pattern");
        Number maxItems = JsonCompat.consumePropertyNumber(json, "maxItems");
        Number minItems = JsonCompat.consumePropertyNumber(json, "minItems");
        Boolean uniqueItems = JsonCompat.consumePropertyBoolean(json, "uniqueItems");
        List<String> enum_ = JsonCompat.consumePropertyStringArray(json, "enum");
        Number multipleOf = JsonCompat.consumePropertyNumber(json, "multipleOf");
        node.type = type;
        node.format = format;
        node.collectionFormat = collectionFormat;
        node.default_ = default_;
        node.maximum = maximum;
        node.exclusiveMaximum = exclusiveMaximum;
        node.minimum = minimum;
        node.exclusiveMinimum = exclusiveMinimum;
        node.maxLength = maxLength;
        node.minLength = minLength;
        node.pattern = pattern;
        node.maxItems = maxItems;
        node.minItems = minItems;
        node.uniqueItems = uniqueItems;
        node.enum_ = enum_;
        node.multipleOf = multipleOf;
        if (items != null) {
            node.items = node.createItems();
            this.readItems(items, node.items);
        }
        this.readExtensions(json, node);
        this.readExtraProperties(json, node);
    }

    @Override
    public void readSchema(Object json, Schema node) {
        String discriminator;
        Oas20Schema schema = (Oas20Schema)node;
        schema.discriminator = discriminator = JsonCompat.consumePropertyString(json, "discriminator");
        super.readSchema(json, node);
    }

    public void readSecurityDefinitions(Object json, Oas20SecurityDefinitions node) {
        List<String> names = JsonCompat.keys(json);
        for (String name : names) {
            Object schemeJson = JsonCompat.consumeProperty(json, name);
            Oas20SecurityScheme schemeModel = node.createSecurityScheme(name);
            this.readSecurityScheme(schemeJson, schemeModel);
            node.addSecurityScheme(name, schemeModel);
        }
    }

    @Override
    public void readSecurityScheme(Object json, SecurityScheme node) {
        Oas20SecurityScheme scheme = (Oas20SecurityScheme)node;
        String flow = JsonCompat.consumePropertyString(json, "flow");
        String authorizationUrl = JsonCompat.consumePropertyString(json, "authorizationUrl");
        String tokenUrl = JsonCompat.consumePropertyString(json, "tokenUrl");
        Object scopes = JsonCompat.consumeProperty(json, "scopes");
        scheme.flow = flow;
        scheme.authorizationUrl = authorizationUrl;
        scheme.tokenUrl = tokenUrl;
        if (scopes != null) {
            Oas20Scopes scopesModel = scheme.createScopes();
            this.readScopes(scopes, scopesModel);
            scheme.scopes = scopesModel;
        }
        super.readSecurityScheme(json, scheme);
    }

    public void readScopes(Object json, Oas20Scopes node) {
        List<String> scopeNames = JsonCompat.keys(json);
        for (String scopeName : scopeNames) {
            if (scopeName.indexOf("x-") == 0) continue;
            String scopeDescription = JsonCompat.consumePropertyString(json, scopeName);
            node.addScope(scopeName, scopeDescription);
        }
        this.readExtensions(json, node);
    }

    @Override
    public void readOperation(Object json, Operation node) {
        Oas20Operation operation = (Oas20Operation)node;
        List<String> consumes = JsonCompat.consumePropertyStringArray(json, "consumes");
        List<String> produces = JsonCompat.consumePropertyStringArray(json, "produces");
        List<String> schemes = JsonCompat.consumePropertyStringArray(json, "schemes");
        operation.consumes = consumes;
        operation.produces = produces;
        operation.schemes = schemes;
        super.readOperation(json, node);
    }
}

