/*
 * Decompiled with CFR 0.152.
 */
package io.debezium.connector.spanner.task.scaler;

public class TaskScaleCalculator {
    private static final double SCALE_OUT_TASKS_STEP = 0.2;
    private static final double SCALE_IN_TASKS_THRESHOLD = 0.5;

    private TaskScaleCalculator() {
    }

    public static int newTasksCount(int currentTasksCount, int desiredPartitionsTasks, int tasksMax, int tasksMin, long partitionsInWorkCount, long idlingTaskCount) {
        int newTasksCount = Math.max(currentTasksCount, tasksMin);
        int addTaskCount = 0;
        for (newTasksCount = Math.min(newTasksCount, tasksMax); TaskScaleCalculator.partitionTaskRatio(newTasksCount, partitionsInWorkCount) > (double)desiredPartitionsTasks && newTasksCount < tasksMax; newTasksCount += addTaskCount) {
            addTaskCount = Math.min((int)Math.ceil((double)newTasksCount * 0.2), tasksMax - newTasksCount);
        }
        if (newTasksCount > tasksMin && TaskScaleCalculator.partitionTaskRatio(newTasksCount, partitionsInWorkCount) < (double)desiredPartitionsTasks && (double)idlingTaskCount > (double)newTasksCount * 0.5) {
            newTasksCount = Math.max((int)((double)newTasksCount * 0.5), tasksMin);
        }
        return newTasksCount;
    }

    private static double partitionTaskRatio(long tasksCount, long partitionsInWorkCount) {
        return tasksCount == 0L ? 0.0 : (double)partitionsInWorkCount / (double)tasksCount;
    }
}

