/*
 * Decompiled with CFR 0.152.
 */
package io.apicurio.registry.serde.avro;

import io.apicurio.registry.resolver.ParsedSchema;
import io.apicurio.registry.resolver.ParsedSchemaImpl;
import io.apicurio.registry.resolver.SchemaParser;
import io.apicurio.registry.resolver.data.Record;
import io.apicurio.registry.serde.avro.AvroDatumProvider;
import io.apicurio.registry.serde.avro.AvroSchemaUtils;
import io.apicurio.registry.utils.IoUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.avro.Schema;

public class AvroSchemaParser<U>
implements SchemaParser<Schema, U> {
    private AvroDatumProvider<U> avroDatumProvider;

    public AvroSchemaParser(AvroDatumProvider<U> avroDatumProvider) {
        this.avroDatumProvider = avroDatumProvider;
    }

    public String artifactType() {
        return "AVRO";
    }

    public Schema parseSchema(byte[] rawSchema, Map<String, ParsedSchema<Schema>> resolvedReferences) {
        return AvroSchemaUtils.parse(IoUtil.toString((byte[])rawSchema), new ArrayList<ParsedSchema<Schema>>(resolvedReferences.values()));
    }

    public ParsedSchema<Schema> getSchemaFromData(Record<U> data) {
        Schema schema = this.avroDatumProvider.toSchema(data.payload());
        List<ParsedSchema<Schema>> resolvedReferences = this.handleReferences(schema.getFields());
        return new ParsedSchemaImpl().setParsedSchema((Object)schema).setReferenceName(schema.getFullName()).setSchemaReferences(resolvedReferences).setRawSchema(IoUtil.toBytes((String)schema.toString((Collection)resolvedReferences.stream().map(ParsedSchema::getParsedSchema).collect(Collectors.toSet()), false)));
    }

    private List<ParsedSchema<Schema>> handleReferences(List<Schema.Field> schemaFields) {
        ArrayList<ParsedSchema<Schema>> schemaReferences = new ArrayList<ParsedSchema<Schema>>();
        for (Schema.Field field : schemaFields) {
            if (field.schema().getType().equals((Object)Schema.Type.RECORD)) {
                List<ParsedSchema<Schema>> parsedSchemas = this.handleReferences(field.schema().getFields());
                byte[] rawSchema = IoUtil.toBytes((String)field.schema().toString((Collection)parsedSchemas.stream().map(ParsedSchema::getParsedSchema).collect(Collectors.toSet()), false));
                ParsedSchemaImpl referencedSchema = new ParsedSchemaImpl().setParsedSchema((Object)field.schema()).setReferenceName(field.schema().getFullName()).setSchemaReferences(parsedSchemas).setRawSchema(rawSchema);
                schemaReferences.add((ParsedSchema<Schema>)referencedSchema);
                continue;
            }
            if (!field.schema().getType().equals((Object)Schema.Type.ENUM)) continue;
            byte[] rawSchema = IoUtil.toBytes((String)field.schema().toString());
            ParsedSchemaImpl referencedSchema = new ParsedSchemaImpl().setParsedSchema((Object)field.schema()).setReferenceName(field.schema().getFullName()).setSchemaReferences(Collections.emptyList()).setRawSchema(rawSchema);
            schemaReferences.add((ParsedSchema<Schema>)referencedSchema);
        }
        return schemaReferences;
    }
}

