/*
 * Decompiled with CFR 0.152.
 */
package io.vitess.client;

import io.vitess.client.RpcClient;
import io.vitess.client.VTGateConnection;
import java.io.File;

public class RefreshableVTGateConnection
extends VTGateConnection {
    private final File keystoreFile;
    private final File truststoreFile;
    private volatile long keystoreMtime;
    private volatile long truststoreMtime;

    public RefreshableVTGateConnection(RpcClient client, String keystorePath, String truststorePath) {
        super(client);
        this.keystoreFile = new File(keystorePath);
        this.truststoreFile = new File(truststorePath);
        this.keystoreMtime = this.keystoreFile.exists() ? this.keystoreFile.lastModified() : 0L;
        this.truststoreMtime = this.truststoreFile.exists() ? this.truststoreFile.lastModified() : 0L;
    }

    public boolean checkKeystoreUpdates() {
        long keystoreMtime = this.keystoreFile.exists() ? this.keystoreFile.lastModified() : 0L;
        long truststoreMtime = this.truststoreFile.exists() ? this.truststoreFile.lastModified() : 0L;
        boolean modified = false;
        if (keystoreMtime > this.keystoreMtime) {
            modified = true;
            this.keystoreMtime = keystoreMtime;
        }
        if (truststoreMtime > this.truststoreMtime) {
            modified = true;
            this.truststoreMtime = truststoreMtime;
        }
        return modified;
    }
}

