/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.pubsub.v1.stub;

import com.google.api.gax.core.BackgroundResource;
import com.google.api.gax.core.BackgroundResourceAggregation;
import com.google.api.gax.grpc.GrpcCallSettings;
import com.google.api.gax.grpc.GrpcStubCallableFactory;
import com.google.api.gax.rpc.BidiStreamingCallable;
import com.google.api.gax.rpc.ClientContext;
import com.google.api.gax.rpc.StubSettings;
import com.google.api.gax.rpc.UnaryCallable;
import com.google.cloud.pubsub.v1.SubscriptionAdminClient;
import com.google.cloud.pubsub.v1.stub.GrpcSubscriberCallableFactory;
import com.google.cloud.pubsub.v1.stub.SubscriberStub;
import com.google.cloud.pubsub.v1.stub.SubscriberStubSettings;
import com.google.common.collect.ImmutableMap;
import com.google.iam.v1.GetIamPolicyRequest;
import com.google.iam.v1.Policy;
import com.google.iam.v1.SetIamPolicyRequest;
import com.google.iam.v1.TestIamPermissionsRequest;
import com.google.iam.v1.TestIamPermissionsResponse;
import com.google.longrunning.stub.GrpcOperationsStub;
import com.google.protobuf.Empty;
import com.google.protobuf.Message;
import com.google.pubsub.v1.AcknowledgeRequest;
import com.google.pubsub.v1.CreateSnapshotRequest;
import com.google.pubsub.v1.DeleteSnapshotRequest;
import com.google.pubsub.v1.DeleteSubscriptionRequest;
import com.google.pubsub.v1.GetSnapshotRequest;
import com.google.pubsub.v1.GetSubscriptionRequest;
import com.google.pubsub.v1.ListSnapshotsRequest;
import com.google.pubsub.v1.ListSnapshotsResponse;
import com.google.pubsub.v1.ListSubscriptionsRequest;
import com.google.pubsub.v1.ListSubscriptionsResponse;
import com.google.pubsub.v1.ModifyAckDeadlineRequest;
import com.google.pubsub.v1.ModifyPushConfigRequest;
import com.google.pubsub.v1.PullRequest;
import com.google.pubsub.v1.PullResponse;
import com.google.pubsub.v1.SeekRequest;
import com.google.pubsub.v1.SeekResponse;
import com.google.pubsub.v1.Snapshot;
import com.google.pubsub.v1.StreamingPullRequest;
import com.google.pubsub.v1.StreamingPullResponse;
import com.google.pubsub.v1.Subscription;
import com.google.pubsub.v1.UpdateSnapshotRequest;
import com.google.pubsub.v1.UpdateSubscriptionRequest;
import io.grpc.MethodDescriptor;
import io.grpc.protobuf.ProtoUtils;
import java.io.IOException;
import java.util.concurrent.TimeUnit;

public class GrpcSubscriberStub
extends SubscriberStub {
    private static final MethodDescriptor<Subscription, Subscription> createSubscriptionMethodDescriptor = MethodDescriptor.newBuilder().setType(MethodDescriptor.MethodType.UNARY).setFullMethodName("google.pubsub.v1.Subscriber/CreateSubscription").setRequestMarshaller(ProtoUtils.marshaller((Message)Subscription.getDefaultInstance())).setResponseMarshaller(ProtoUtils.marshaller((Message)Subscription.getDefaultInstance())).build();
    private static final MethodDescriptor<GetSubscriptionRequest, Subscription> getSubscriptionMethodDescriptor = MethodDescriptor.newBuilder().setType(MethodDescriptor.MethodType.UNARY).setFullMethodName("google.pubsub.v1.Subscriber/GetSubscription").setRequestMarshaller(ProtoUtils.marshaller((Message)GetSubscriptionRequest.getDefaultInstance())).setResponseMarshaller(ProtoUtils.marshaller((Message)Subscription.getDefaultInstance())).build();
    private static final MethodDescriptor<UpdateSubscriptionRequest, Subscription> updateSubscriptionMethodDescriptor = MethodDescriptor.newBuilder().setType(MethodDescriptor.MethodType.UNARY).setFullMethodName("google.pubsub.v1.Subscriber/UpdateSubscription").setRequestMarshaller(ProtoUtils.marshaller((Message)UpdateSubscriptionRequest.getDefaultInstance())).setResponseMarshaller(ProtoUtils.marshaller((Message)Subscription.getDefaultInstance())).build();
    private static final MethodDescriptor<ListSubscriptionsRequest, ListSubscriptionsResponse> listSubscriptionsMethodDescriptor = MethodDescriptor.newBuilder().setType(MethodDescriptor.MethodType.UNARY).setFullMethodName("google.pubsub.v1.Subscriber/ListSubscriptions").setRequestMarshaller(ProtoUtils.marshaller((Message)ListSubscriptionsRequest.getDefaultInstance())).setResponseMarshaller(ProtoUtils.marshaller((Message)ListSubscriptionsResponse.getDefaultInstance())).build();
    private static final MethodDescriptor<DeleteSubscriptionRequest, Empty> deleteSubscriptionMethodDescriptor = MethodDescriptor.newBuilder().setType(MethodDescriptor.MethodType.UNARY).setFullMethodName("google.pubsub.v1.Subscriber/DeleteSubscription").setRequestMarshaller(ProtoUtils.marshaller((Message)DeleteSubscriptionRequest.getDefaultInstance())).setResponseMarshaller(ProtoUtils.marshaller((Message)Empty.getDefaultInstance())).build();
    private static final MethodDescriptor<ModifyAckDeadlineRequest, Empty> modifyAckDeadlineMethodDescriptor = MethodDescriptor.newBuilder().setType(MethodDescriptor.MethodType.UNARY).setFullMethodName("google.pubsub.v1.Subscriber/ModifyAckDeadline").setRequestMarshaller(ProtoUtils.marshaller((Message)ModifyAckDeadlineRequest.getDefaultInstance())).setResponseMarshaller(ProtoUtils.marshaller((Message)Empty.getDefaultInstance())).build();
    private static final MethodDescriptor<AcknowledgeRequest, Empty> acknowledgeMethodDescriptor = MethodDescriptor.newBuilder().setType(MethodDescriptor.MethodType.UNARY).setFullMethodName("google.pubsub.v1.Subscriber/Acknowledge").setRequestMarshaller(ProtoUtils.marshaller((Message)AcknowledgeRequest.getDefaultInstance())).setResponseMarshaller(ProtoUtils.marshaller((Message)Empty.getDefaultInstance())).build();
    private static final MethodDescriptor<PullRequest, PullResponse> pullMethodDescriptor = MethodDescriptor.newBuilder().setType(MethodDescriptor.MethodType.UNARY).setFullMethodName("google.pubsub.v1.Subscriber/Pull").setRequestMarshaller(ProtoUtils.marshaller((Message)PullRequest.getDefaultInstance())).setResponseMarshaller(ProtoUtils.marshaller((Message)PullResponse.getDefaultInstance())).build();
    private static final MethodDescriptor<StreamingPullRequest, StreamingPullResponse> streamingPullMethodDescriptor = MethodDescriptor.newBuilder().setType(MethodDescriptor.MethodType.BIDI_STREAMING).setFullMethodName("google.pubsub.v1.Subscriber/StreamingPull").setRequestMarshaller(ProtoUtils.marshaller((Message)StreamingPullRequest.getDefaultInstance())).setResponseMarshaller(ProtoUtils.marshaller((Message)StreamingPullResponse.getDefaultInstance())).build();
    private static final MethodDescriptor<ModifyPushConfigRequest, Empty> modifyPushConfigMethodDescriptor = MethodDescriptor.newBuilder().setType(MethodDescriptor.MethodType.UNARY).setFullMethodName("google.pubsub.v1.Subscriber/ModifyPushConfig").setRequestMarshaller(ProtoUtils.marshaller((Message)ModifyPushConfigRequest.getDefaultInstance())).setResponseMarshaller(ProtoUtils.marshaller((Message)Empty.getDefaultInstance())).build();
    private static final MethodDescriptor<GetSnapshotRequest, Snapshot> getSnapshotMethodDescriptor = MethodDescriptor.newBuilder().setType(MethodDescriptor.MethodType.UNARY).setFullMethodName("google.pubsub.v1.Subscriber/GetSnapshot").setRequestMarshaller(ProtoUtils.marshaller((Message)GetSnapshotRequest.getDefaultInstance())).setResponseMarshaller(ProtoUtils.marshaller((Message)Snapshot.getDefaultInstance())).build();
    private static final MethodDescriptor<ListSnapshotsRequest, ListSnapshotsResponse> listSnapshotsMethodDescriptor = MethodDescriptor.newBuilder().setType(MethodDescriptor.MethodType.UNARY).setFullMethodName("google.pubsub.v1.Subscriber/ListSnapshots").setRequestMarshaller(ProtoUtils.marshaller((Message)ListSnapshotsRequest.getDefaultInstance())).setResponseMarshaller(ProtoUtils.marshaller((Message)ListSnapshotsResponse.getDefaultInstance())).build();
    private static final MethodDescriptor<CreateSnapshotRequest, Snapshot> createSnapshotMethodDescriptor = MethodDescriptor.newBuilder().setType(MethodDescriptor.MethodType.UNARY).setFullMethodName("google.pubsub.v1.Subscriber/CreateSnapshot").setRequestMarshaller(ProtoUtils.marshaller((Message)CreateSnapshotRequest.getDefaultInstance())).setResponseMarshaller(ProtoUtils.marshaller((Message)Snapshot.getDefaultInstance())).build();
    private static final MethodDescriptor<UpdateSnapshotRequest, Snapshot> updateSnapshotMethodDescriptor = MethodDescriptor.newBuilder().setType(MethodDescriptor.MethodType.UNARY).setFullMethodName("google.pubsub.v1.Subscriber/UpdateSnapshot").setRequestMarshaller(ProtoUtils.marshaller((Message)UpdateSnapshotRequest.getDefaultInstance())).setResponseMarshaller(ProtoUtils.marshaller((Message)Snapshot.getDefaultInstance())).build();
    private static final MethodDescriptor<DeleteSnapshotRequest, Empty> deleteSnapshotMethodDescriptor = MethodDescriptor.newBuilder().setType(MethodDescriptor.MethodType.UNARY).setFullMethodName("google.pubsub.v1.Subscriber/DeleteSnapshot").setRequestMarshaller(ProtoUtils.marshaller((Message)DeleteSnapshotRequest.getDefaultInstance())).setResponseMarshaller(ProtoUtils.marshaller((Message)Empty.getDefaultInstance())).build();
    private static final MethodDescriptor<SeekRequest, SeekResponse> seekMethodDescriptor = MethodDescriptor.newBuilder().setType(MethodDescriptor.MethodType.UNARY).setFullMethodName("google.pubsub.v1.Subscriber/Seek").setRequestMarshaller(ProtoUtils.marshaller((Message)SeekRequest.getDefaultInstance())).setResponseMarshaller(ProtoUtils.marshaller((Message)SeekResponse.getDefaultInstance())).build();
    private static final MethodDescriptor<SetIamPolicyRequest, Policy> setIamPolicyMethodDescriptor = MethodDescriptor.newBuilder().setType(MethodDescriptor.MethodType.UNARY).setFullMethodName("google.iam.v1.IAMPolicy/SetIamPolicy").setRequestMarshaller(ProtoUtils.marshaller((Message)SetIamPolicyRequest.getDefaultInstance())).setResponseMarshaller(ProtoUtils.marshaller((Message)Policy.getDefaultInstance())).build();
    private static final MethodDescriptor<GetIamPolicyRequest, Policy> getIamPolicyMethodDescriptor = MethodDescriptor.newBuilder().setType(MethodDescriptor.MethodType.UNARY).setFullMethodName("google.iam.v1.IAMPolicy/GetIamPolicy").setRequestMarshaller(ProtoUtils.marshaller((Message)GetIamPolicyRequest.getDefaultInstance())).setResponseMarshaller(ProtoUtils.marshaller((Message)Policy.getDefaultInstance())).build();
    private static final MethodDescriptor<TestIamPermissionsRequest, TestIamPermissionsResponse> testIamPermissionsMethodDescriptor = MethodDescriptor.newBuilder().setType(MethodDescriptor.MethodType.UNARY).setFullMethodName("google.iam.v1.IAMPolicy/TestIamPermissions").setRequestMarshaller(ProtoUtils.marshaller((Message)TestIamPermissionsRequest.getDefaultInstance())).setResponseMarshaller(ProtoUtils.marshaller((Message)TestIamPermissionsResponse.getDefaultInstance())).build();
    private final UnaryCallable<Subscription, Subscription> createSubscriptionCallable;
    private final UnaryCallable<GetSubscriptionRequest, Subscription> getSubscriptionCallable;
    private final UnaryCallable<UpdateSubscriptionRequest, Subscription> updateSubscriptionCallable;
    private final UnaryCallable<ListSubscriptionsRequest, ListSubscriptionsResponse> listSubscriptionsCallable;
    private final UnaryCallable<ListSubscriptionsRequest, SubscriptionAdminClient.ListSubscriptionsPagedResponse> listSubscriptionsPagedCallable;
    private final UnaryCallable<DeleteSubscriptionRequest, Empty> deleteSubscriptionCallable;
    private final UnaryCallable<ModifyAckDeadlineRequest, Empty> modifyAckDeadlineCallable;
    private final UnaryCallable<AcknowledgeRequest, Empty> acknowledgeCallable;
    private final UnaryCallable<PullRequest, PullResponse> pullCallable;
    private final BidiStreamingCallable<StreamingPullRequest, StreamingPullResponse> streamingPullCallable;
    private final UnaryCallable<ModifyPushConfigRequest, Empty> modifyPushConfigCallable;
    private final UnaryCallable<GetSnapshotRequest, Snapshot> getSnapshotCallable;
    private final UnaryCallable<ListSnapshotsRequest, ListSnapshotsResponse> listSnapshotsCallable;
    private final UnaryCallable<ListSnapshotsRequest, SubscriptionAdminClient.ListSnapshotsPagedResponse> listSnapshotsPagedCallable;
    private final UnaryCallable<CreateSnapshotRequest, Snapshot> createSnapshotCallable;
    private final UnaryCallable<UpdateSnapshotRequest, Snapshot> updateSnapshotCallable;
    private final UnaryCallable<DeleteSnapshotRequest, Empty> deleteSnapshotCallable;
    private final UnaryCallable<SeekRequest, SeekResponse> seekCallable;
    private final UnaryCallable<SetIamPolicyRequest, Policy> setIamPolicyCallable;
    private final UnaryCallable<GetIamPolicyRequest, Policy> getIamPolicyCallable;
    private final UnaryCallable<TestIamPermissionsRequest, TestIamPermissionsResponse> testIamPermissionsCallable;
    private final BackgroundResource backgroundResources;
    private final GrpcOperationsStub operationsStub;
    private final GrpcStubCallableFactory callableFactory;

    public static final GrpcSubscriberStub create(SubscriberStubSettings settings) throws IOException {
        return new GrpcSubscriberStub(settings, ClientContext.create((StubSettings)settings));
    }

    public static final GrpcSubscriberStub create(ClientContext clientContext) throws IOException {
        return new GrpcSubscriberStub(SubscriberStubSettings.newBuilder().build(), clientContext);
    }

    public static final GrpcSubscriberStub create(ClientContext clientContext, GrpcStubCallableFactory callableFactory) throws IOException {
        return new GrpcSubscriberStub(SubscriberStubSettings.newBuilder().build(), clientContext, callableFactory);
    }

    protected GrpcSubscriberStub(SubscriberStubSettings settings, ClientContext clientContext) throws IOException {
        this(settings, clientContext, new GrpcSubscriberCallableFactory());
    }

    protected GrpcSubscriberStub(SubscriberStubSettings settings, ClientContext clientContext, GrpcStubCallableFactory callableFactory) throws IOException {
        this.callableFactory = callableFactory;
        this.operationsStub = GrpcOperationsStub.create((ClientContext)clientContext, (GrpcStubCallableFactory)callableFactory);
        GrpcCallSettings createSubscriptionTransportSettings = GrpcCallSettings.newBuilder().setMethodDescriptor(createSubscriptionMethodDescriptor).setParamsExtractor(request -> {
            ImmutableMap.Builder params = ImmutableMap.builder();
            params.put((Object)"name", (Object)String.valueOf(request.getName()));
            return params.build();
        }).build();
        GrpcCallSettings getSubscriptionTransportSettings = GrpcCallSettings.newBuilder().setMethodDescriptor(getSubscriptionMethodDescriptor).setParamsExtractor(request -> {
            ImmutableMap.Builder params = ImmutableMap.builder();
            params.put((Object)"subscription", (Object)String.valueOf(request.getSubscription()));
            return params.build();
        }).build();
        GrpcCallSettings updateSubscriptionTransportSettings = GrpcCallSettings.newBuilder().setMethodDescriptor(updateSubscriptionMethodDescriptor).setParamsExtractor(request -> {
            ImmutableMap.Builder params = ImmutableMap.builder();
            params.put((Object)"subscription.name", (Object)String.valueOf(request.getSubscription().getName()));
            return params.build();
        }).build();
        GrpcCallSettings listSubscriptionsTransportSettings = GrpcCallSettings.newBuilder().setMethodDescriptor(listSubscriptionsMethodDescriptor).setParamsExtractor(request -> {
            ImmutableMap.Builder params = ImmutableMap.builder();
            params.put((Object)"project", (Object)String.valueOf(request.getProject()));
            return params.build();
        }).build();
        GrpcCallSettings deleteSubscriptionTransportSettings = GrpcCallSettings.newBuilder().setMethodDescriptor(deleteSubscriptionMethodDescriptor).setParamsExtractor(request -> {
            ImmutableMap.Builder params = ImmutableMap.builder();
            params.put((Object)"subscription", (Object)String.valueOf(request.getSubscription()));
            return params.build();
        }).build();
        GrpcCallSettings modifyAckDeadlineTransportSettings = GrpcCallSettings.newBuilder().setMethodDescriptor(modifyAckDeadlineMethodDescriptor).setParamsExtractor(request -> {
            ImmutableMap.Builder params = ImmutableMap.builder();
            params.put((Object)"subscription", (Object)String.valueOf(request.getSubscription()));
            return params.build();
        }).build();
        GrpcCallSettings acknowledgeTransportSettings = GrpcCallSettings.newBuilder().setMethodDescriptor(acknowledgeMethodDescriptor).setParamsExtractor(request -> {
            ImmutableMap.Builder params = ImmutableMap.builder();
            params.put((Object)"subscription", (Object)String.valueOf(request.getSubscription()));
            return params.build();
        }).build();
        GrpcCallSettings pullTransportSettings = GrpcCallSettings.newBuilder().setMethodDescriptor(pullMethodDescriptor).setParamsExtractor(request -> {
            ImmutableMap.Builder params = ImmutableMap.builder();
            params.put((Object)"subscription", (Object)String.valueOf(request.getSubscription()));
            return params.build();
        }).build();
        GrpcCallSettings streamingPullTransportSettings = GrpcCallSettings.newBuilder().setMethodDescriptor(streamingPullMethodDescriptor).build();
        GrpcCallSettings modifyPushConfigTransportSettings = GrpcCallSettings.newBuilder().setMethodDescriptor(modifyPushConfigMethodDescriptor).setParamsExtractor(request -> {
            ImmutableMap.Builder params = ImmutableMap.builder();
            params.put((Object)"subscription", (Object)String.valueOf(request.getSubscription()));
            return params.build();
        }).build();
        GrpcCallSettings getSnapshotTransportSettings = GrpcCallSettings.newBuilder().setMethodDescriptor(getSnapshotMethodDescriptor).setParamsExtractor(request -> {
            ImmutableMap.Builder params = ImmutableMap.builder();
            params.put((Object)"snapshot", (Object)String.valueOf(request.getSnapshot()));
            return params.build();
        }).build();
        GrpcCallSettings listSnapshotsTransportSettings = GrpcCallSettings.newBuilder().setMethodDescriptor(listSnapshotsMethodDescriptor).setParamsExtractor(request -> {
            ImmutableMap.Builder params = ImmutableMap.builder();
            params.put((Object)"project", (Object)String.valueOf(request.getProject()));
            return params.build();
        }).build();
        GrpcCallSettings createSnapshotTransportSettings = GrpcCallSettings.newBuilder().setMethodDescriptor(createSnapshotMethodDescriptor).setParamsExtractor(request -> {
            ImmutableMap.Builder params = ImmutableMap.builder();
            params.put((Object)"name", (Object)String.valueOf(request.getName()));
            return params.build();
        }).build();
        GrpcCallSettings updateSnapshotTransportSettings = GrpcCallSettings.newBuilder().setMethodDescriptor(updateSnapshotMethodDescriptor).setParamsExtractor(request -> {
            ImmutableMap.Builder params = ImmutableMap.builder();
            params.put((Object)"snapshot.name", (Object)String.valueOf(request.getSnapshot().getName()));
            return params.build();
        }).build();
        GrpcCallSettings deleteSnapshotTransportSettings = GrpcCallSettings.newBuilder().setMethodDescriptor(deleteSnapshotMethodDescriptor).setParamsExtractor(request -> {
            ImmutableMap.Builder params = ImmutableMap.builder();
            params.put((Object)"snapshot", (Object)String.valueOf(request.getSnapshot()));
            return params.build();
        }).build();
        GrpcCallSettings seekTransportSettings = GrpcCallSettings.newBuilder().setMethodDescriptor(seekMethodDescriptor).setParamsExtractor(request -> {
            ImmutableMap.Builder params = ImmutableMap.builder();
            params.put((Object)"subscription", (Object)String.valueOf(request.getSubscription()));
            return params.build();
        }).build();
        GrpcCallSettings setIamPolicyTransportSettings = GrpcCallSettings.newBuilder().setMethodDescriptor(setIamPolicyMethodDescriptor).setParamsExtractor(request -> {
            ImmutableMap.Builder params = ImmutableMap.builder();
            params.put((Object)"resource", (Object)String.valueOf(request.getResource()));
            return params.build();
        }).build();
        GrpcCallSettings getIamPolicyTransportSettings = GrpcCallSettings.newBuilder().setMethodDescriptor(getIamPolicyMethodDescriptor).setParamsExtractor(request -> {
            ImmutableMap.Builder params = ImmutableMap.builder();
            params.put((Object)"resource", (Object)String.valueOf(request.getResource()));
            return params.build();
        }).build();
        GrpcCallSettings testIamPermissionsTransportSettings = GrpcCallSettings.newBuilder().setMethodDescriptor(testIamPermissionsMethodDescriptor).setParamsExtractor(request -> {
            ImmutableMap.Builder params = ImmutableMap.builder();
            params.put((Object)"resource", (Object)String.valueOf(request.getResource()));
            return params.build();
        }).build();
        this.createSubscriptionCallable = callableFactory.createUnaryCallable(createSubscriptionTransportSettings, settings.createSubscriptionSettings(), clientContext);
        this.getSubscriptionCallable = callableFactory.createUnaryCallable(getSubscriptionTransportSettings, settings.getSubscriptionSettings(), clientContext);
        this.updateSubscriptionCallable = callableFactory.createUnaryCallable(updateSubscriptionTransportSettings, settings.updateSubscriptionSettings(), clientContext);
        this.listSubscriptionsCallable = callableFactory.createUnaryCallable(listSubscriptionsTransportSettings, settings.listSubscriptionsSettings(), clientContext);
        this.listSubscriptionsPagedCallable = callableFactory.createPagedCallable(listSubscriptionsTransportSettings, settings.listSubscriptionsSettings(), clientContext);
        this.deleteSubscriptionCallable = callableFactory.createUnaryCallable(deleteSubscriptionTransportSettings, settings.deleteSubscriptionSettings(), clientContext);
        this.modifyAckDeadlineCallable = callableFactory.createUnaryCallable(modifyAckDeadlineTransportSettings, settings.modifyAckDeadlineSettings(), clientContext);
        this.acknowledgeCallable = callableFactory.createUnaryCallable(acknowledgeTransportSettings, settings.acknowledgeSettings(), clientContext);
        this.pullCallable = callableFactory.createUnaryCallable(pullTransportSettings, settings.pullSettings(), clientContext);
        this.streamingPullCallable = callableFactory.createBidiStreamingCallable(streamingPullTransportSettings, settings.streamingPullSettings(), clientContext);
        this.modifyPushConfigCallable = callableFactory.createUnaryCallable(modifyPushConfigTransportSettings, settings.modifyPushConfigSettings(), clientContext);
        this.getSnapshotCallable = callableFactory.createUnaryCallable(getSnapshotTransportSettings, settings.getSnapshotSettings(), clientContext);
        this.listSnapshotsCallable = callableFactory.createUnaryCallable(listSnapshotsTransportSettings, settings.listSnapshotsSettings(), clientContext);
        this.listSnapshotsPagedCallable = callableFactory.createPagedCallable(listSnapshotsTransportSettings, settings.listSnapshotsSettings(), clientContext);
        this.createSnapshotCallable = callableFactory.createUnaryCallable(createSnapshotTransportSettings, settings.createSnapshotSettings(), clientContext);
        this.updateSnapshotCallable = callableFactory.createUnaryCallable(updateSnapshotTransportSettings, settings.updateSnapshotSettings(), clientContext);
        this.deleteSnapshotCallable = callableFactory.createUnaryCallable(deleteSnapshotTransportSettings, settings.deleteSnapshotSettings(), clientContext);
        this.seekCallable = callableFactory.createUnaryCallable(seekTransportSettings, settings.seekSettings(), clientContext);
        this.setIamPolicyCallable = callableFactory.createUnaryCallable(setIamPolicyTransportSettings, settings.setIamPolicySettings(), clientContext);
        this.getIamPolicyCallable = callableFactory.createUnaryCallable(getIamPolicyTransportSettings, settings.getIamPolicySettings(), clientContext);
        this.testIamPermissionsCallable = callableFactory.createUnaryCallable(testIamPermissionsTransportSettings, settings.testIamPermissionsSettings(), clientContext);
        this.backgroundResources = new BackgroundResourceAggregation(clientContext.getBackgroundResources());
    }

    public GrpcOperationsStub getOperationsStub() {
        return this.operationsStub;
    }

    @Override
    public UnaryCallable<Subscription, Subscription> createSubscriptionCallable() {
        return this.createSubscriptionCallable;
    }

    @Override
    public UnaryCallable<GetSubscriptionRequest, Subscription> getSubscriptionCallable() {
        return this.getSubscriptionCallable;
    }

    @Override
    public UnaryCallable<UpdateSubscriptionRequest, Subscription> updateSubscriptionCallable() {
        return this.updateSubscriptionCallable;
    }

    @Override
    public UnaryCallable<ListSubscriptionsRequest, ListSubscriptionsResponse> listSubscriptionsCallable() {
        return this.listSubscriptionsCallable;
    }

    @Override
    public UnaryCallable<ListSubscriptionsRequest, SubscriptionAdminClient.ListSubscriptionsPagedResponse> listSubscriptionsPagedCallable() {
        return this.listSubscriptionsPagedCallable;
    }

    @Override
    public UnaryCallable<DeleteSubscriptionRequest, Empty> deleteSubscriptionCallable() {
        return this.deleteSubscriptionCallable;
    }

    @Override
    public UnaryCallable<ModifyAckDeadlineRequest, Empty> modifyAckDeadlineCallable() {
        return this.modifyAckDeadlineCallable;
    }

    @Override
    public UnaryCallable<AcknowledgeRequest, Empty> acknowledgeCallable() {
        return this.acknowledgeCallable;
    }

    @Override
    public UnaryCallable<PullRequest, PullResponse> pullCallable() {
        return this.pullCallable;
    }

    @Override
    public BidiStreamingCallable<StreamingPullRequest, StreamingPullResponse> streamingPullCallable() {
        return this.streamingPullCallable;
    }

    @Override
    public UnaryCallable<ModifyPushConfigRequest, Empty> modifyPushConfigCallable() {
        return this.modifyPushConfigCallable;
    }

    @Override
    public UnaryCallable<GetSnapshotRequest, Snapshot> getSnapshotCallable() {
        return this.getSnapshotCallable;
    }

    @Override
    public UnaryCallable<ListSnapshotsRequest, ListSnapshotsResponse> listSnapshotsCallable() {
        return this.listSnapshotsCallable;
    }

    @Override
    public UnaryCallable<ListSnapshotsRequest, SubscriptionAdminClient.ListSnapshotsPagedResponse> listSnapshotsPagedCallable() {
        return this.listSnapshotsPagedCallable;
    }

    @Override
    public UnaryCallable<CreateSnapshotRequest, Snapshot> createSnapshotCallable() {
        return this.createSnapshotCallable;
    }

    @Override
    public UnaryCallable<UpdateSnapshotRequest, Snapshot> updateSnapshotCallable() {
        return this.updateSnapshotCallable;
    }

    @Override
    public UnaryCallable<DeleteSnapshotRequest, Empty> deleteSnapshotCallable() {
        return this.deleteSnapshotCallable;
    }

    @Override
    public UnaryCallable<SeekRequest, SeekResponse> seekCallable() {
        return this.seekCallable;
    }

    @Override
    public UnaryCallable<SetIamPolicyRequest, Policy> setIamPolicyCallable() {
        return this.setIamPolicyCallable;
    }

    @Override
    public UnaryCallable<GetIamPolicyRequest, Policy> getIamPolicyCallable() {
        return this.getIamPolicyCallable;
    }

    @Override
    public UnaryCallable<TestIamPermissionsRequest, TestIamPermissionsResponse> testIamPermissionsCallable() {
        return this.testIamPermissionsCallable;
    }

    @Override
    public final void close() {
        try {
            this.backgroundResources.close();
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new IllegalStateException("Failed to close resource", e);
        }
    }

    public void shutdown() {
        this.backgroundResources.shutdown();
    }

    public boolean isShutdown() {
        return this.backgroundResources.isShutdown();
    }

    public boolean isTerminated() {
        return this.backgroundResources.isTerminated();
    }

    public void shutdownNow() {
        this.backgroundResources.shutdownNow();
    }

    public boolean awaitTermination(long duration, TimeUnit unit) throws InterruptedException {
        return this.backgroundResources.awaitTermination(duration, unit);
    }
}

