/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.connect.util;

import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Function;
import java.util.stream.Collector;
import java.util.stream.Collectors;
import org.apache.kafka.common.InvalidRecordException;
import org.apache.kafka.connect.connector.Connector;
import org.apache.kafka.connect.errors.ConnectException;
import org.apache.kafka.connect.runtime.WorkerConfig;
import org.apache.kafka.connect.sink.SinkConnector;
import org.apache.kafka.connect.source.SourceConnector;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class ConnectUtils {
    private static final Logger log = LoggerFactory.getLogger(ConnectUtils.class);

    public static Long checkAndConvertTimestamp(Long timestamp) {
        if (timestamp == null || timestamp >= 0L) {
            return timestamp;
        }
        if (timestamp == -1L) {
            return null;
        }
        throw new InvalidRecordException(String.format("Invalid record timestamp %d", timestamp));
    }

    public static void ensureProperty(Map<String, ? super String> props, String key, String expectedValue, String justification, boolean caseSensitive) {
        ConnectUtils.ensurePropertyAndGetWarning(props, key, expectedValue, justification, caseSensitive).ifPresent(arg_0 -> ((Logger)log).warn(arg_0));
    }

    static Optional<String> ensurePropertyAndGetWarning(Map<String, ? super String> props, String key, String expectedValue, String justification, boolean caseSensitive) {
        boolean matchesExpectedValue;
        if (!props.containsKey(key)) {
            props.put(key, expectedValue);
            return Optional.empty();
        }
        String value = Objects.toString(props.get(key));
        boolean bl = matchesExpectedValue = caseSensitive ? expectedValue.equals(value) : expectedValue.equalsIgnoreCase(value);
        if (matchesExpectedValue) {
            return Optional.empty();
        }
        props.put(key, expectedValue);
        justification = justification != null ? " " + justification : "";
        return Optional.of(String.format("The value '%s' for the '%s' property will be ignored as it cannot be overridden%s. The value '%s' will be used instead.", value, key, justification, expectedValue));
    }

    public static void addMetricsContextProperties(Map<String, Object> prop, WorkerConfig config, String clusterId) {
        prop.putAll(config.originalsWithPrefix("metrics.context.", false));
        prop.put("metrics.context.connect.kafka.cluster.id", clusterId);
        Object groupId = config.originals().get("group.id");
        if (groupId != null) {
            prop.put("metrics.context.connect.group.id", groupId);
        }
    }

    public static boolean isSinkConnector(Connector connector) {
        return SinkConnector.class.isAssignableFrom(connector.getClass());
    }

    public static boolean isSourceConnector(Connector connector) {
        return SourceConnector.class.isAssignableFrom(connector.getClass());
    }

    public static <K, I, O> Map<K, O> transformValues(Map<K, I> map, Function<I, O> transformation) {
        return map.entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, transformation.compose(Map.Entry::getValue)));
    }

    public static <I> List<I> combineCollections(Collection<Collection<I>> collections) {
        return ConnectUtils.combineCollections(collections, Function.identity());
    }

    public static <I, T> List<T> combineCollections(Collection<I> collection, Function<I, Collection<T>> extractCollection) {
        return ConnectUtils.combineCollections(collection, extractCollection, Collectors.toList());
    }

    public static <I, T, C> C combineCollections(Collection<I> collection, Function<I, Collection<T>> extractCollection, Collector<T, ?, C> collector) {
        return collection.stream().map(extractCollection).flatMap(Collection::stream).collect(collector);
    }

    public static ConnectException maybeWrap(Throwable t, String message) {
        if (t == null) {
            return null;
        }
        if (t instanceof ConnectException) {
            return (ConnectException)t;
        }
        return new ConnectException(message, t);
    }

    public static String clientIdBase(WorkerConfig config) {
        String result = Optional.ofNullable(config.groupId()).orElse("connect");
        String userSpecifiedClientId = config.getString("client.id");
        if (userSpecifiedClientId != null) {
            result = result + "-" + userSpecifiedClientId;
        }
        return result + "-";
    }
}

