/*
 * Decompiled with CFR 0.152.
 */
package com.azure.core.amqp;

import com.azure.core.amqp.AmqpRetryOptions;
import com.azure.core.amqp.exception.AmqpErrorCondition;
import com.azure.core.amqp.exception.AmqpException;
import com.azure.core.amqp.implementation.ClientConstants;
import java.time.Duration;
import java.util.Objects;
import java.util.concurrent.ThreadLocalRandom;
import java.util.concurrent.TimeoutException;

public abstract class AmqpRetryPolicy {
    static final long NANOS_PER_SECOND = 1000000000L;
    private static final double JITTER_FACTOR = 0.08;
    private final AmqpRetryOptions retryOptions;
    private final Duration baseJitter;

    protected AmqpRetryPolicy(AmqpRetryOptions retryOptions) {
        Objects.requireNonNull(retryOptions, "'retryOptions' cannot be null.");
        this.retryOptions = retryOptions;
        double jitterInNanos = (double)retryOptions.getDelay().getSeconds() * 0.08 * 1.0E9;
        this.baseJitter = Duration.ofNanos((long)jitterInNanos);
    }

    public AmqpRetryOptions getRetryOptions() {
        return this.retryOptions;
    }

    public int getMaxRetries() {
        return this.retryOptions.getMaxRetries();
    }

    public Duration calculateRetryDelay(Throwable lastException, int retryCount) {
        if (this.retryOptions.getDelay() == Duration.ZERO || this.retryOptions.getMaxDelay() == Duration.ZERO || retryCount > this.retryOptions.getMaxRetries()) {
            return null;
        }
        Duration baseDelay = lastException instanceof AmqpException && AmqpRetryPolicy.isRetriableException(lastException) ? (((AmqpException)((Object)lastException)).getErrorCondition() == AmqpErrorCondition.SERVER_BUSY_ERROR ? this.retryOptions.getDelay().plus(ClientConstants.SERVER_BUSY_WAIT_TIME) : this.retryOptions.getDelay()) : (lastException instanceof TimeoutException ? this.retryOptions.getDelay() : null);
        if (baseDelay == null) {
            return null;
        }
        Duration delay = this.calculateRetryDelay(retryCount, baseDelay, this.baseJitter, ThreadLocalRandom.current());
        return delay.compareTo(this.retryOptions.getMaxDelay()) <= 0 ? delay : this.retryOptions.getMaxDelay();
    }

    protected abstract Duration calculateRetryDelay(int var1, Duration var2, Duration var3, ThreadLocalRandom var4);

    public int hashCode() {
        return Objects.hash(this.retryOptions);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof AmqpRetryPolicy)) {
            return false;
        }
        AmqpRetryPolicy other = (AmqpRetryPolicy)obj;
        return this.retryOptions.equals(other.retryOptions);
    }

    private static boolean isRetriableException(Throwable exception) {
        return exception instanceof AmqpException && ((AmqpException)((Object)exception)).isTransient();
    }
}

