/*
 * Decompiled with CFR 0.152.
 */
package com.azure.core.amqp.implementation;

import com.azure.core.amqp.AmqpShutdownSignal;
import com.azure.core.util.logging.LoggingEventBuilder;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.apache.qpid.proton.amqp.transport.ErrorCondition;
import reactor.core.publisher.SignalType;
import reactor.core.publisher.Sinks;

public final class AmqpLoggingUtils {
    private AmqpLoggingUtils() {
    }

    public static Map<String, Object> createContextWithConnectionId(String connectionId) {
        Objects.requireNonNull(connectionId, "'connectionId' cannot be null.");
        HashMap<String, Object> globalLoggingContext = new HashMap<String, Object>(1);
        globalLoggingContext.put("connectionId", connectionId);
        return globalLoggingContext;
    }

    public static LoggingEventBuilder addSignalTypeAndResult(LoggingEventBuilder logBuilder, SignalType signalType, Sinks.EmitResult result) {
        return logBuilder.addKeyValue("signalType", (Object)signalType).addKeyValue("emitResult", (Object)result);
    }

    public static LoggingEventBuilder addErrorCondition(LoggingEventBuilder logBuilder, ErrorCondition errorCondition) {
        if (errorCondition == null) {
            return logBuilder.addKeyValue("errorCondition", "n/a").addKeyValue("errorDescription", "n/a");
        }
        return logBuilder.addKeyValue("errorCondition", (Object)errorCondition.getCondition()).addKeyValue("errorDescription", errorCondition.getDescription());
    }

    public static LoggingEventBuilder addShutdownSignal(LoggingEventBuilder logBuilder, AmqpShutdownSignal shutdownSignal) {
        return logBuilder.addKeyValue("isTransient", shutdownSignal.isTransient()).addKeyValue("isInitiatedByClient", shutdownSignal.isInitiatedByClient()).addKeyValue("shutdownMessage", (Object)shutdownSignal);
    }
}

