/*
 * Decompiled with CFR 0.152.
 */
package org.jgroups.protocols;

import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import org.jgroups.Address;
import org.jgroups.Message;
import org.jgroups.NullAddress;
import org.jgroups.View;
import org.jgroups.annotations.ManagedAttribute;
import org.jgroups.annotations.Property;
import org.jgroups.conf.AttributeType;
import org.jgroups.logging.Log;
import org.jgroups.protocols.Bundler;
import org.jgroups.protocols.TP;
import org.jgroups.util.ByteArrayDataOutputStream;
import org.jgroups.util.Util;

public class PerDestinationBundler
implements Bundler {
    @Property(name="max_size", type=AttributeType.BYTES, description="Maximum number of bytes for messages to be queued until they are sent")
    protected int max_size = 64000;
    @Property(description="The maximum number of queued messages per destination. When the queue is full, a new batch will be sent")
    public int max_queue_size = 128;
    @ManagedAttribute(description="Number of messages sent in BatchMessages", type=AttributeType.SCALAR)
    protected long num_msgs_sent;
    @ManagedAttribute(description="Number of BatchMessages sent", type=AttributeType.SCALAR)
    protected long num_batches_sent;
    @ManagedAttribute(description="Number of BatchMessages sent because the queue was full", type=AttributeType.SCALAR)
    protected long num_batches_sent_due_to_max_size;
    @ManagedAttribute(description="Number of BatchMessages sent because the max number of messages has been reached (max_queue_size)", type=AttributeType.SCALAR)
    protected long num_batches_sent_due_to_full_queue;
    @ManagedAttribute(description="Number of MessageBatches sent because the last sender thread returned", type=AttributeType.SCALAR)
    protected long num_batches_sent_due_to_last_thread;
    protected TP transport;
    protected Log log;
    protected Address local_addr;
    protected final Map<Address, SendBuffer> dests = Util.createConcurrentMap();
    protected static final Address NULL = new NullAddress();

    @Override
    public int size() {
        return this.dests.values().stream().map(SendBuffer::size).reduce(0, Integer::sum);
    }

    @Override
    public int getQueueSize() {
        return -1;
    }

    @Override
    public int getMaxSize() {
        return this.max_size;
    }

    @Override
    public Bundler setMaxSize(int s) {
        this.max_size = s;
        return this;
    }

    public int getMaxQueueSize() {
        return this.max_queue_size;
    }

    public Bundler setMaxQueueSize(int s) {
        this.max_queue_size = s;
        return this;
    }

    @ManagedAttribute(description="Average number of messages in an BatchMessage")
    public double avgBatchSize() {
        if (this.num_batches_sent == 0L || this.num_msgs_sent == 0L) {
            return 0.0;
        }
        return (double)this.num_msgs_sent / (double)this.num_batches_sent;
    }

    @Override
    public void resetStats() {
        this.num_msgs_sent = 0L;
        this.num_batches_sent = 0L;
        this.num_batches_sent_due_to_max_size = 0L;
        this.num_batches_sent_due_to_full_queue = 0L;
        this.num_batches_sent_due_to_last_thread = 0L;
    }

    @Override
    public void init(TP transport) {
        this.transport = Objects.requireNonNull(transport);
        this.log = transport.getLog();
    }

    @Override
    public void start() {
        this.local_addr = Objects.requireNonNull(this.transport.getAddress());
    }

    @Override
    public void stop() {
    }

    @Override
    public void send(Message msg) throws Exception {
        if (msg.getSrc() == null) {
            msg.setSrc(this.local_addr);
        }
        Address dest = msg.dest() == null ? NULL : msg.dest();
        SendBuffer buf = this.dests.computeIfAbsent(dest, k -> new SendBuffer());
        buf.addMessage(dest, msg);
    }

    @Override
    public void viewChange(View view) {
        List<Address> mbrs = view.getMembers();
        if (mbrs == null) {
            return;
        }
        mbrs.stream().filter(dest -> !this.dests.containsKey(dest)).forEach(dest -> this.dests.putIfAbsent((Address)dest, new SendBuffer()));
        this.dests.keySet().stream().filter(dest -> !mbrs.contains(dest) && !(dest instanceof NullAddress)).forEach(this.dests::remove);
    }

    protected class SendBuffer {
        private final Message[] msgs;
        private int index;
        private long total_bytes;
        private final AtomicInteger thread_count = new AtomicInteger();
        private final ByteArrayDataOutputStream output;
        private final Lock lock = new ReentrantLock(false);

        protected SendBuffer() {
            this.msgs = new Message[PerDestinationBundler.this.max_queue_size];
            this.index = 0;
            this.output = new ByteArrayDataOutputStream(PerDestinationBundler.this.max_size + 3);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected void addMessage(Address dest, Message msg) {
            int msg_bytes = msg.getLength();
            this.thread_count.incrementAndGet();
            this.lock.lock();
            try {
                if (this.total_bytes + (long)msg_bytes >= (long)PerDestinationBundler.this.max_size) {
                    ++PerDestinationBundler.this.num_batches_sent_due_to_max_size;
                    this.sendBatch(dest);
                }
                this.msgs[this.index++] = msg;
                this.total_bytes += (long)msg_bytes;
                if (this.index == this.msgs.length) {
                    ++PerDestinationBundler.this.num_batches_sent_due_to_full_queue;
                    this.sendBatch(dest);
                }
                if (this.thread_count.decrementAndGet() == 0) {
                    ++PerDestinationBundler.this.num_batches_sent_due_to_last_thread;
                    this.sendBatch(dest);
                }
            }
            finally {
                this.lock.unlock();
            }
        }

        protected void sendBatch(Address destination) {
            Address dest;
            if (this.index == 0) {
                return;
            }
            Address address = dest = destination instanceof NullAddress ? null : destination;
            if (this.index == 1) {
                this.sendSingleMessage(dest, this.msgs[0]);
                this.msgs[0] = null;
                this.index = 0;
                this.total_bytes = 0L;
                ++PerDestinationBundler.this.num_msgs_sent;
                return;
            }
            this.sendMessageList(dest, PerDestinationBundler.this.local_addr, this.msgs, this.index);
            PerDestinationBundler.this.num_msgs_sent += (long)this.index;
            ++PerDestinationBundler.this.num_batches_sent;
            this.index = 0;
            this.total_bytes = 0L;
        }

        protected void sendSingleMessage(Address dest, Message msg) {
            try {
                this.output.position(0);
                Util.writeMessage(msg, this.output, dest == null);
                PerDestinationBundler.this.transport.doSend(this.output.buffer(), 0, this.output.position(), dest);
                if (PerDestinationBundler.this.transport.statsEnabled()) {
                    PerDestinationBundler.this.transport.getMessageStats().incrNumSingleMsgsSent(1);
                }
            }
            catch (Throwable e) {
                PerDestinationBundler.this.log.error("%s: failed sending message: %s", PerDestinationBundler.this.local_addr, e);
            }
        }

        protected void sendMessageList(Address dest, Address src, Message[] list, int length) {
            try {
                this.output.position(0);
                Util.writeMessageList(dest, src, PerDestinationBundler.this.transport.cluster_name.chars(), list, 0, length, this.output, dest == null, PerDestinationBundler.this.transport.getId());
                PerDestinationBundler.this.transport.doSend(this.output.buffer(), 0, this.output.position(), dest);
                if (PerDestinationBundler.this.transport.statsEnabled()) {
                    PerDestinationBundler.this.transport.getMessageStats().incrNumBatchesSent(1);
                }
            }
            catch (Throwable e) {
                PerDestinationBundler.this.log.trace(Util.getMessage("FailureSendingMsgBundle"), PerDestinationBundler.this.transport.getAddress(), e);
            }
        }

        protected int size() {
            this.lock.lock();
            try {
                int n = this.index;
                return n;
            }
            finally {
                this.lock.unlock();
            }
        }
    }
}

