/*
 * Decompiled with CFR 0.152.
 */
package com.azure.messaging.eventhubs;

import com.azure.core.amqp.AmqpMessageConstant;
import com.azure.core.amqp.models.AmqpAnnotatedMessage;
import com.azure.core.amqp.models.AmqpMessageBody;
import com.azure.core.amqp.models.AmqpMessageHeader;
import com.azure.core.amqp.models.AmqpMessageId;
import com.azure.core.amqp.models.AmqpMessageProperties;
import com.azure.core.models.MessageContent;
import com.azure.core.util.BinaryData;
import com.azure.core.util.Context;
import com.azure.core.util.FluxUtil;
import com.azure.core.util.logging.ClientLogger;
import com.azure.messaging.eventhubs.SystemProperties;
import java.nio.ByteBuffer;
import java.nio.charset.StandardCharsets;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Set;

public class EventData
extends MessageContent {
    static final Set<String> RESERVED_SYSTEM_PROPERTIES;
    static final AmqpAnnotatedMessage EMPTY_MESSAGE;
    private static final ClientLogger LOGGER;
    private final Map<String, Object> properties;
    private final SystemProperties systemProperties;
    private AmqpAnnotatedMessage annotatedMessage;
    private Context context;

    public EventData() {
        this.context = Context.NONE;
        this.annotatedMessage = EMPTY_MESSAGE;
        this.properties = this.annotatedMessage.getApplicationProperties();
        this.systemProperties = new SystemProperties();
    }

    public EventData(byte[] body) {
        this.context = Context.NONE;
        AmqpMessageBody messageBody = AmqpMessageBody.fromData((byte[])Objects.requireNonNull(body, "'body' cannot be null."));
        this.annotatedMessage = new AmqpAnnotatedMessage(messageBody);
        this.properties = this.annotatedMessage.getApplicationProperties();
        this.systemProperties = new SystemProperties();
    }

    public EventData(ByteBuffer body) {
        this(FluxUtil.byteBufferToArray((ByteBuffer)Objects.requireNonNull(body, "'body' cannot be null.").duplicate()));
    }

    public EventData(String body) {
        this(Objects.requireNonNull(body, "'body' cannot be null.").getBytes(StandardCharsets.UTF_8));
    }

    public EventData(BinaryData body) {
        this(Objects.requireNonNull(body, "'body' cannot be null.").toBytes());
    }

    EventData(AmqpAnnotatedMessage amqpAnnotatedMessage, SystemProperties systemProperties, Context context) {
        this.context = Objects.requireNonNull(context, "'context' cannot be null.");
        this.properties = Collections.unmodifiableMap(amqpAnnotatedMessage.getApplicationProperties());
        this.annotatedMessage = Objects.requireNonNull(amqpAnnotatedMessage, "'amqpAnnotatedMessage' cannot be null.");
        this.systemProperties = systemProperties;
        switch (this.annotatedMessage.getBody().getBodyType()) {
            case DATA: {
                break;
            }
            case SEQUENCE: 
            case VALUE: {
                LOGGER.warning("Message body type '{}' is not supported in EH.  Getting contents of body may throw.", new Object[]{this.annotatedMessage.getBody().getBodyType()});
                break;
            }
            default: {
                throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException("Body type not valid " + this.annotatedMessage.getBody().getBodyType()));
            }
        }
    }

    public Map<String, Object> getProperties() {
        return this.properties;
    }

    public Map<String, Object> getSystemProperties() {
        return this.systemProperties;
    }

    public byte[] getBody() {
        return this.annotatedMessage.getBody().getFirstData();
    }

    public String getBodyAsString() {
        return new String(this.annotatedMessage.getBody().getFirstData(), StandardCharsets.UTF_8);
    }

    public BinaryData getBodyAsBinaryData() {
        return BinaryData.fromBytes((byte[])this.annotatedMessage.getBody().getFirstData());
    }

    public EventData setBodyAsBinaryData(BinaryData binaryData) {
        AmqpAnnotatedMessage current = this.annotatedMessage;
        this.annotatedMessage = new AmqpAnnotatedMessage(AmqpMessageBody.fromData((byte[])binaryData.toBytes()));
        if (current == null) {
            return this;
        }
        this.annotatedMessage.getApplicationProperties().putAll(current.getApplicationProperties());
        this.annotatedMessage.getDeliveryAnnotations().putAll(current.getDeliveryAnnotations());
        this.annotatedMessage.getFooter().putAll(current.getFooter());
        this.annotatedMessage.getMessageAnnotations().putAll(current.getMessageAnnotations());
        AmqpMessageHeader header = this.annotatedMessage.getHeader();
        header.setDeliveryCount(current.getHeader().getDeliveryCount()).setDurable(current.getHeader().isDurable()).setFirstAcquirer(current.getHeader().isFirstAcquirer()).setPriority(current.getHeader().getPriority()).setTimeToLive(current.getHeader().getTimeToLive());
        AmqpMessageProperties props = this.annotatedMessage.getProperties();
        props.setAbsoluteExpiryTime(current.getProperties().getAbsoluteExpiryTime()).setContentEncoding(current.getProperties().getContentEncoding()).setContentType(current.getProperties().getContentType()).setCorrelationId(current.getProperties().getCorrelationId()).setCreationTime(current.getProperties().getCreationTime()).setGroupId(current.getProperties().getGroupId()).setGroupSequence(current.getProperties().getGroupSequence()).setMessageId(current.getProperties().getMessageId()).setReplyTo(current.getProperties().getReplyTo()).setReplyToGroupId(current.getProperties().getReplyToGroupId()).setSubject(current.getProperties().getSubject()).setTo(current.getProperties().getTo()).setUserId(current.getProperties().getUserId());
        return this;
    }

    public Long getOffset() {
        return this.systemProperties.getOffset();
    }

    public String getPartitionKey() {
        return this.systemProperties.getPartitionKey();
    }

    public Instant getEnqueuedTime() {
        return this.systemProperties.getEnqueuedTime();
    }

    public Long getSequenceNumber() {
        return this.systemProperties.getSequenceNumber();
    }

    public AmqpAnnotatedMessage getRawAmqpMessage() {
        return this.annotatedMessage;
    }

    public String getContentType() {
        return this.annotatedMessage.getProperties().getContentType();
    }

    public EventData setContentType(String contentType) {
        this.annotatedMessage.getProperties().setContentType(contentType);
        return this;
    }

    public String getCorrelationId() {
        AmqpMessageId messageId = this.annotatedMessage.getProperties().getCorrelationId();
        return messageId != null ? messageId.toString() : null;
    }

    public EventData setCorrelationId(String correlationId) {
        AmqpMessageId id = correlationId != null ? new AmqpMessageId(correlationId) : null;
        this.annotatedMessage.getProperties().setCorrelationId(id);
        return this;
    }

    public String getMessageId() {
        AmqpMessageId messageId = this.annotatedMessage.getProperties().getMessageId();
        return messageId != null ? messageId.toString() : null;
    }

    public EventData setMessageId(String messageId) {
        AmqpMessageId id = messageId != null ? new AmqpMessageId(messageId) : null;
        this.annotatedMessage.getProperties().setMessageId(id);
        return this;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || ((Object)((Object)this)).getClass() != o.getClass()) {
            return false;
        }
        EventData eventData = (EventData)((Object)o);
        return Arrays.equals(this.annotatedMessage.getBody().getFirstData(), eventData.annotatedMessage.getBody().getFirstData());
    }

    public int hashCode() {
        return Arrays.hashCode(this.annotatedMessage.getBody().getFirstData());
    }

    Context getContext() {
        return this.context;
    }

    public EventData addContext(String key, Object value) {
        Objects.requireNonNull(key, "The 'key' parameter cannot be null.");
        Objects.requireNonNull(value, "The 'value' parameter cannot be null.");
        this.context = this.context.addData((Object)key, value);
        return this;
    }

    static {
        EMPTY_MESSAGE = new AmqpAnnotatedMessage(AmqpMessageBody.fromData((byte[])new byte[0]));
        LOGGER = new ClientLogger(EventData.class);
        HashSet<String> properties = new HashSet<String>();
        properties.add(AmqpMessageConstant.OFFSET_ANNOTATION_NAME.getValue());
        properties.add(AmqpMessageConstant.PARTITION_KEY_ANNOTATION_NAME.getValue());
        properties.add(AmqpMessageConstant.SEQUENCE_NUMBER_ANNOTATION_NAME.getValue());
        properties.add(AmqpMessageConstant.ENQUEUED_TIME_UTC_ANNOTATION_NAME.getValue());
        properties.add(AmqpMessageConstant.PUBLISHER_ANNOTATION_NAME.getValue());
        RESERVED_SYSTEM_PROPERTIES = Collections.unmodifiableSet(properties);
    }
}

