/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.vertx.http.runtime;

import io.quarkus.runtime.RuntimeValue;
import io.quarkus.runtime.annotations.Recorder;
import io.quarkus.vertx.http.runtime.HttpBuildTimeConfig;
import io.quarkus.vertx.http.runtime.HttpConfiguration;
import io.quarkus.vertx.http.runtime.StaticResourcesConfig;
import io.vertx.core.Handler;
import io.vertx.core.http.HttpHeaders;
import io.vertx.core.http.HttpMethod;
import io.vertx.core.http.impl.MimeMapping;
import io.vertx.ext.web.Route;
import io.vertx.ext.web.RoutingContext;
import io.vertx.ext.web.handler.FileSystemAccess;
import io.vertx.ext.web.handler.StaticHandler;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import java.util.function.Consumer;

@Recorder
public class StaticResourcesRecorder {
    public static final String META_INF_RESOURCES = "META-INF/resources";
    private static volatile List<Path> hotDeploymentResourcePaths;
    final RuntimeValue<HttpConfiguration> httpConfiguration;
    final HttpBuildTimeConfig httpBuildTimeConfig;
    private Set<String> compressMediaTypes = Set.of();

    public StaticResourcesRecorder(RuntimeValue<HttpConfiguration> httpConfiguration, HttpBuildTimeConfig httpBuildTimeConfig) {
        this.httpConfiguration = httpConfiguration;
        this.httpBuildTimeConfig = httpBuildTimeConfig;
    }

    public static void setHotDeploymentResources(List<Path> resources) {
        hotDeploymentResourcePaths = resources;
    }

    public Consumer<Route> start(final Set<String> knownPaths) {
        if (this.httpBuildTimeConfig.enableCompression && this.httpBuildTimeConfig.compressMediaTypes.isPresent()) {
            this.compressMediaTypes = Set.copyOf((Collection)this.httpBuildTimeConfig.compressMediaTypes.get());
        }
        final ArrayList<Object> handlers = new ArrayList<Object>();
        StaticResourcesConfig config = ((HttpConfiguration)this.httpConfiguration.getValue()).staticResources;
        if (hotDeploymentResourcePaths != null && !hotDeploymentResourcePaths.isEmpty()) {
            for (Path resourcePath : hotDeploymentResourcePaths) {
                String root = resourcePath.toAbsolutePath().toString();
                final StaticHandler staticHandler = StaticHandler.create((FileSystemAccess)FileSystemAccess.ROOT, (String)root).setDefaultContentEncoding("UTF-8").setCachingEnabled(false).setIndexPage(config.indexPage).setIncludeHidden(config.includeHidden).setEnableRangeSupport(config.enableRangeSupport);
                handlers.add(new Handler<RoutingContext>(){

                    public void handle(RoutingContext ctx) {
                        try {
                            StaticResourcesRecorder.this.compressIfNeeded(ctx, ctx.normalizedPath());
                            staticHandler.handle((Object)ctx);
                        }
                        catch (Exception e) {
                            ctx.next();
                        }
                    }
                });
            }
        }
        if (!knownPaths.isEmpty()) {
            final ClassLoader currentCl = Thread.currentThread().getContextClassLoader();
            final StaticHandler staticHandler = StaticHandler.create((String)META_INF_RESOURCES).setDefaultContentEncoding("UTF-8").setCachingEnabled(config.cachingEnabled).setIndexPage(config.indexPage).setIncludeHidden(config.includeHidden).setEnableRangeSupport(config.enableRangeSupport).setMaxCacheSize(config.maxCacheSize).setCacheEntryTimeout(config.cacheEntryTimeout.toMillis()).setMaxAgeSeconds(config.maxAge.toSeconds());
            final String indexPage = config.indexPage.charAt(0) == '/' ? config.indexPage.substring(1) : config.indexPage;
            handlers.add(new Handler<RoutingContext>(){

                public void handle(RoutingContext ctx) {
                    String rel;
                    String string = ctx.mountPoint() == null ? ctx.normalizedPath() : (rel = ctx.normalizedPath().substring(ctx.mountPoint().endsWith("/") ? ctx.mountPoint().length() - 1 : ctx.mountPoint().length()));
                    if (knownPaths.contains(rel) || rel.endsWith("/") && knownPaths.contains(rel.concat(indexPage))) {
                        StaticResourcesRecorder.this.compressIfNeeded(ctx, rel);
                        staticHandler.handle((Object)ctx);
                    } else {
                        Thread.currentThread().setContextClassLoader(currentCl);
                        ctx.next();
                    }
                }
            });
        }
        return new Consumer<Route>(){

            @Override
            public void accept(Route route) {
                route.method(HttpMethod.GET);
                route.method(HttpMethod.HEAD);
                for (Handler i : handlers) {
                    route.handler(i);
                }
            }
        };
    }

    private void compressIfNeeded(RoutingContext ctx, String path) {
        if (this.httpBuildTimeConfig.enableCompression && this.isCompressed(path)) {
            ctx.response().headers().remove(HttpHeaders.CONTENT_ENCODING);
        }
    }

    private boolean isCompressed(String path) {
        if (this.compressMediaTypes.isEmpty()) {
            return false;
        }
        Object resourcePath = path.endsWith("/") ? path + "index.html" : path;
        String contentType = MimeMapping.getMimeTypeForFilename((String)resourcePath);
        return contentType != null && this.compressMediaTypes.contains(contentType);
    }
}

