/*
 * Decompiled with CFR 0.152.
 */
package io.apicurio.hub.api.codegen;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.squareup.javapoet.AnnotationSpec;
import com.squareup.javapoet.ClassName;
import com.squareup.javapoet.JavaFile;
import com.squareup.javapoet.MethodSpec;
import com.squareup.javapoet.ParameterSpec;
import com.squareup.javapoet.ParameterizedTypeName;
import com.squareup.javapoet.TypeName;
import com.squareup.javapoet.TypeSpec;
import com.sun.codemodel.CodeWriter;
import com.sun.codemodel.JClassContainer;
import com.sun.codemodel.JCodeModel;
import com.sun.codemodel.JDefinedClass;
import com.sun.codemodel.JType;
import io.apicurio.datamodels.Library;
import io.apicurio.datamodels.core.models.Document;
import io.apicurio.datamodels.core.models.Extension;
import io.apicurio.datamodels.core.models.Node;
import io.apicurio.datamodels.core.util.VisitorUtil;
import io.apicurio.datamodels.core.visitors.IVisitor;
import io.apicurio.datamodels.core.visitors.TraverserDirection;
import io.apicurio.datamodels.openapi.models.OasDocument;
import io.apicurio.hub.api.codegen.JaxRsEnumRule;
import io.apicurio.hub.api.codegen.JaxRsProjectSettings;
import io.apicurio.hub.api.codegen.beans.CodegenBeanAnnotationDirective;
import io.apicurio.hub.api.codegen.beans.CodegenInfo;
import io.apicurio.hub.api.codegen.beans.CodegenJavaArgument;
import io.apicurio.hub.api.codegen.beans.CodegenJavaBean;
import io.apicurio.hub.api.codegen.beans.CodegenJavaInterface;
import io.apicurio.hub.api.codegen.beans.CodegenJavaMethod;
import io.apicurio.hub.api.codegen.jaxrs.InterfacesVisitor;
import io.apicurio.hub.api.codegen.jaxrs.OpenApi2CodegenVisitor;
import io.apicurio.hub.api.codegen.post.JavaBeanPostProcessor;
import io.apicurio.hub.api.codegen.pre.DocumentPreProcessor;
import io.apicurio.hub.api.codegen.util.CodegenUtil;
import io.apicurio.hub.api.codegen.util.IndexedCodeWriter;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.net.URI;
import java.net.URL;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Set;
import java.util.concurrent.CompletionStage;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;
import javax.lang.model.SourceVersion;
import javax.lang.model.element.Modifier;
import javax.ws.rs.Consumes;
import javax.ws.rs.HeaderParam;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang.StringUtils;
import org.jsonschema2pojo.Annotator;
import org.jsonschema2pojo.DefaultGenerationConfig;
import org.jsonschema2pojo.GenerationConfig;
import org.jsonschema2pojo.Jackson2Annotator;
import org.jsonschema2pojo.Schema;
import org.jsonschema2pojo.SchemaGenerator;
import org.jsonschema2pojo.SchemaMapper;
import org.jsonschema2pojo.SchemaStore;
import org.jsonschema2pojo.rules.Rule;
import org.jsonschema2pojo.rules.RuleFactory;

public class OpenApi2JaxRs {
    protected static ObjectMapper mapper = new ObjectMapper();
    protected static Charset utf8 = StandardCharsets.UTF_8;
    protected static GenerationConfig config = new DefaultGenerationConfig(){

        public boolean isUsePrimitives() {
            return false;
        }

        public boolean isIncludeHashcodeAndEquals() {
            return false;
        }

        public boolean isIncludeAdditionalProperties() {
            return false;
        }

        public boolean isIncludeToString() {
            return false;
        }
    };
    protected static JavaBeanPostProcessor postProcessor = new JavaBeanPostProcessor();
    private String openApiDoc;
    protected transient Document document;
    protected JaxRsProjectSettings settings = new JaxRsProjectSettings();
    private boolean updateOnly;

    public OpenApi2JaxRs() {
        this.settings.artifactId = "generated-api";
        this.settings.groupId = "org.example.api";
        this.settings.javaPackage = "org.example.api";
    }

    public void setSettings(JaxRsProjectSettings settings) {
        this.settings = settings;
    }

    public void setOpenApiDocument(String content) {
        this.openApiDoc = content;
    }

    public void setOpenApiDocument(URL url) throws IOException {
        try (InputStream is = url.openStream();){
            this.setOpenApiDocument(is);
        }
    }

    public void setOpenApiDocument(InputStream stream) throws IOException {
        this.openApiDoc = IOUtils.toString((InputStream)stream, (Charset)utf8);
    }

    public final void generate(OutputStream output) throws IOException {
        StringBuilder log = new StringBuilder();
        try (ZipOutputStream zos = new ZipOutputStream(output);){
            try {
                CodegenInfo info = this.getInfoFromApiDoc();
                this.generateAll(info, log, zos);
            }
            catch (Exception e) {
                zos.putNextEntry(new ZipEntry("PROJECT_GENERATION_FAILED.txt"));
                zos.write("An unexpected server error was encountered while generating the project.  See\r\n".getBytes());
                zos.write("the details of the error below.\r\n\r\n".getBytes());
                zos.write("Generation Log:\r\n\r\n".getBytes());
                zos.write(log.toString().getBytes(utf8));
                zos.write("\r\n\r\nServer Stack Trace:\r\n".getBytes());
                PrintWriter writer = new PrintWriter(zos);
                e.printStackTrace(writer);
                writer.flush();
                zos.closeEntry();
            }
        }
    }

    protected void generateAll(CodegenInfo info, StringBuilder log, ZipOutputStream zipOutput) throws IOException {
        if (!this.updateOnly && !this.settings.codeOnly) {
            log.append("Generating pom.xml\r\n");
            String pomXml = this.generatePomXml(info);
            if (pomXml != null) {
                zipOutput.putNextEntry(new ZipEntry("pom.xml"));
                zipOutput.write(pomXml.getBytes(utf8));
                zipOutput.closeEntry();
            }
        }
        if (this.settings.cliGenCI) {
            log.append("Generating .github/workflows/release_cli.yaml\r\n");
            zipOutput.putNextEntry(new ZipEntry(".github/workflows/release_cli.yaml"));
            zipOutput.write(IOUtils.toString((URL)this.getResource("release_cli.yaml"), (Charset)Charset.forName("UTF-8")).getBytes(utf8));
            zipOutput.closeEntry();
        }
        if (this.settings.isIncludeSpec()) {
            Object specPath = "META-INF/openapi.json";
            if (this.settings.isMavenFileStructure()) {
                specPath = "src/main/resources/" + (String)specPath;
            }
            log.append("Generating " + (String)specPath + "\r\n");
            zipOutput.putNextEntry(new ZipEntry((String)specPath));
            zipOutput.write(this.openApiDoc.getBytes(utf8));
            zipOutput.closeEntry();
        }
        if (!this.updateOnly) {
            String appFileName = this.javaPackageToZipPath(this.settings.javaPackage) + "JaxRsApplication.java";
            String jaxRsApp = this.generateJaxRsApplication();
            if (jaxRsApp != null) {
                log.append("Generating " + appFileName + "\r\n");
                zipOutput.putNextEntry(new ZipEntry(appFileName));
                zipOutput.write(jaxRsApp.getBytes(utf8));
                zipOutput.closeEntry();
            }
        }
        IndexedCodeWriter codeWriter = new IndexedCodeWriter();
        for (CodegenJavaBean bean : info.getBeans()) {
            log.append("Generating Bean: " + bean.getPackage() + "." + bean.getName() + "\r\n");
            this.generateJavaBean(bean, info, codeWriter);
        }
        for (String className : codeWriter.keys()) {
            ByteArrayOutputStream processedBeanData;
            ByteArrayOutputStream beanData = codeWriter.getContent(className);
            ArrayList<CodegenBeanAnnotationDirective> annotations = new ArrayList<CodegenBeanAnnotationDirective>();
            annotations.addAll(info.getBeanAnnotations());
            CodegenJavaBean bean = codeWriter.getBean(className);
            if (bean != null && bean.getAnnotations() != null) {
                annotations.addAll(bean.getAnnotations());
            }
            if (beanData == (processedBeanData = postProcessor.process(className, annotations, beanData))) continue;
            codeWriter.set(className, processedBeanData);
        }
        for (String key : codeWriter.keys()) {
            String javaClassFileName = this.javaClassToZipPath(key);
            log.append("Adding to zip: " + javaClassFileName + "\r\n");
            zipOutput.putNextEntry(new ZipEntry(javaClassFileName));
            zipOutput.write(codeWriter.getContent(key).toByteArray());
            zipOutput.closeEntry();
        }
        for (CodegenJavaInterface iface : info.getInterfaces()) {
            log.append("Generating Interface: " + iface.getPackage() + "." + iface.getName() + "\r\n");
            String javaInterface = this.generateJavaInterface(info, iface);
            String javaInterfaceFileName = this.javaPackageToZipPath(iface.getPackage()) + iface.getName() + ".java";
            log.append("Adding to zip: " + javaInterfaceFileName + "\r\n");
            zipOutput.putNextEntry(new ZipEntry(javaInterfaceFileName));
            zipOutput.write(javaInterface.getBytes(utf8));
            zipOutput.closeEntry();
        }
    }

    public ByteArrayOutputStream generate() throws IOException {
        try (ByteArrayOutputStream output = new ByteArrayOutputStream();){
            this.generate(output);
            ByteArrayOutputStream byteArrayOutputStream = output;
            return byteArrayOutputStream;
        }
    }

    private String javaClassToZipPath(String javaClass) {
        return (this.settings.isMavenFileStructure() ? "src/main/java/" : "") + javaClass.replace('.', '/') + ".java";
    }

    protected CodegenInfo getInfoFromApiDoc() throws IOException {
        this.document = Library.readDocumentFromJSONString((String)this.openApiDoc);
        this.document = this.preProcess(this.document);
        InterfacesVisitor iVisitor = new InterfacesVisitor();
        VisitorUtil.visitTree((Node)this.document, (IVisitor)iVisitor, (TraverserDirection)TraverserDirection.down);
        OpenApi2CodegenVisitor cgVisitor = new OpenApi2CodegenVisitor(this.settings.javaPackage, iVisitor.getInterfaces());
        VisitorUtil.visitTree((Node)this.document, (IVisitor)cgVisitor, (TraverserDirection)TraverserDirection.down);
        CodegenInfo info = cgVisitor.getCodegenInfo();
        info.getInterfaces().forEach(iface -> iface.getMethods().forEach(method -> method.getArguments().forEach(arg -> {
            String argTypeSig = arg.getTypeSignature();
            CodegenJavaBean matchingBean = OpenApi2JaxRs.findMatchingBean(info, argTypeSig);
            if (matchingBean != null) {
                arg.setType(matchingBean.getPackage() + "." + StringUtils.capitalize((String)matchingBean.getName()));
            }
        })));
        String contextRoot = this.getContextRoot(this.document);
        if (contextRoot != null) {
            info.setContextRoot(contextRoot);
        }
        return info;
    }

    private String getContextRoot(Document document) {
        Extension extension;
        OasDocument oaiDoc = (OasDocument)document;
        if (oaiDoc.paths != null && (extension = oaiDoc.paths.getExtension("x-codegen-contextRoot")) != null && extension.value != null) {
            return String.valueOf(extension.value);
        }
        return null;
    }

    private Document preProcess(Document document) {
        DocumentPreProcessor preprocessor = new DocumentPreProcessor();
        preprocessor.process(document);
        if (Boolean.FALSE.booleanValue()) {
            System.out.println("-------------------------");
            System.out.println(Library.writeDocumentToJSONString((Document)document));
            System.out.println("-------------------------");
            System.exit(1);
        }
        return document;
    }

    private static CodegenJavaBean findMatchingBean(CodegenInfo info, String typeSignature) {
        if (typeSignature == null) {
            return null;
        }
        for (CodegenJavaBean bean : info.getBeans()) {
            if (!typeSignature.equals(bean.getSignature())) continue;
            return bean;
        }
        return null;
    }

    protected String generatePomXml(CodegenInfo info) throws IOException {
        String template = IOUtils.toString((URL)this.getResource("pom.xml"), (Charset)Charset.forName("UTF-8"));
        return template.replace("$GROUP_ID$", this.settings.groupId).replace("$ARTIFACT_ID$", this.settings.artifactId).replace("$VERSION$", info.getVersion()).replace("$NAME$", info.getName()).replace("$DESCRIPTION$", info.getDescription());
    }

    protected String generateJaxRsApplication() throws IOException {
        TypeSpec jaxRsApp = TypeSpec.classBuilder((ClassName)ClassName.get((String)this.settings.javaPackage, (String)"JaxRsApplication", (String[])new String[0])).addModifiers(new Modifier[]{Modifier.PUBLIC}).superclass((TypeName)ClassName.get((String)"javax.ws.rs.core", (String)"Application", (String[])new String[0])).addAnnotation(ClassName.get((String)"javax.enterprise.context", (String)"ApplicationScoped", (String[])new String[0])).addAnnotation(AnnotationSpec.builder((ClassName)ClassName.get((String)"javax.ws.rs", (String)"ApplicationPath", (String[])new String[0])).addMember("value", "$S", new Object[]{"/"}).build()).addJavadoc("The JAX-RS application.\n", new Object[0]).build();
        JavaFile javaFile = JavaFile.builder((String)this.settings.javaPackage, (TypeSpec)jaxRsApp).skipJavaLangImports(true).build();
        return javaFile.toString();
    }

    protected String generateJavaInterface(CodegenInfo info, CodegenJavaInterface _interface) {
        TypeSpec.Builder interfaceBuilder = TypeSpec.interfaceBuilder((ClassName)ClassName.get((String)_interface.getPackage(), (String)_interface.getName(), (String[])new String[0]));
        String jaxRsPath = info.getContextRoot() + _interface.getPath();
        interfaceBuilder.addModifiers(new Modifier[]{Modifier.PUBLIC}).addAnnotation(AnnotationSpec.builder(Path.class).addMember("value", "$S", new Object[]{jaxRsPath}).build()).addJavadoc("A JAX-RS interface.  An implementation of this interface must be provided.\n", new Object[0]);
        for (CodegenJavaMethod cgMethod : _interface.getMethods()) {
            MethodSpec.Builder methodBuilder = MethodSpec.methodBuilder((String)cgMethod.getName());
            methodBuilder.addModifiers(new Modifier[]{Modifier.PUBLIC, Modifier.ABSTRACT});
            if (cgMethod.getPath() != null) {
                methodBuilder.addAnnotation(AnnotationSpec.builder(Path.class).addMember("value", "$S", new Object[]{cgMethod.getPath()}).build());
            }
            methodBuilder.addAnnotation(AnnotationSpec.builder((ClassName)ClassName.get((String)"javax.ws.rs", (String)cgMethod.getMethod().toUpperCase(), (String[])new String[0])).build());
            if (cgMethod.getProduces() != null && !cgMethod.getProduces().isEmpty()) {
                methodBuilder.addAnnotation(AnnotationSpec.builder(Produces.class).addMember("value", "$L", new Object[]{OpenApi2JaxRs.toStringArrayLiteral(cgMethod.getProduces())}).build());
            }
            if (cgMethod.getConsumes() != null && !cgMethod.getConsumes().isEmpty()) {
                methodBuilder.addAnnotation(AnnotationSpec.builder(Consumes.class).addMember("value", "$L", new Object[]{OpenApi2JaxRs.toStringArrayLiteral(cgMethod.getConsumes())}).build());
            }
            if (cgMethod.getReturn() != null) {
                TypeName returnType = this.generateTypeName(cgMethod.getReturn().getCollection(), cgMethod.getReturn().getType(), cgMethod.getReturn().getFormat(), true, (TypeName)ClassName.get((String)"javax.ws.rs.core", (String)"Response", (String[])new String[0]));
                if (this.getSettings().reactive || cgMethod.isAsync()) {
                    returnType = this.generateReactiveTypeName(returnType);
                }
                methodBuilder.returns(returnType);
            }
            if (cgMethod.getArguments() != null && !cgMethod.getArguments().isEmpty()) {
                for (CodegenJavaArgument cgArgument : cgMethod.getArguments()) {
                    ClassName defaultParamType = ClassName.OBJECT;
                    if (cgArgument.getIn().equals("body")) {
                        defaultParamType = ClassName.get((String)"java.io", (String)"InputStream", (String[])new String[0]);
                    }
                    TypeName paramType = this.generateTypeName(cgArgument.getCollection(), cgArgument.getType(), cgArgument.getFormat(), cgArgument.getRequired(), (TypeName)defaultParamType);
                    if (cgArgument.getTypeSignature() != null) {
                        // empty if block
                    }
                    ParameterSpec.Builder paramBuilder = ParameterSpec.builder((TypeName)paramType, (String)OpenApi2JaxRs.paramNameToJavaArgName(cgArgument.getName()), (Modifier[])new Modifier[0]);
                    if (cgArgument.getIn().equals("path")) {
                        paramBuilder.addAnnotation(AnnotationSpec.builder(PathParam.class).addMember("value", "$S", new Object[]{cgArgument.getName()}).build());
                    }
                    if (cgArgument.getIn().equals("query")) {
                        paramBuilder.addAnnotation(AnnotationSpec.builder(QueryParam.class).addMember("value", "$S", new Object[]{cgArgument.getName()}).build());
                    }
                    if (cgArgument.getIn().equals("header")) {
                        paramBuilder.addAnnotation(AnnotationSpec.builder(HeaderParam.class).addMember("value", "$S", new Object[]{cgArgument.getName()}).build());
                    }
                    methodBuilder.addParameter(paramBuilder.build());
                }
            }
            if (cgMethod.getDescription() != null) {
                methodBuilder.addJavadoc(cgMethod.getDescription(), new Object[0]);
                methodBuilder.addJavadoc("\n", new Object[0]);
            }
            interfaceBuilder.addMethod(methodBuilder.build());
        }
        TypeSpec jaxRsInterface = interfaceBuilder.build();
        JavaFile javaFile = JavaFile.builder((String)_interface.getPackage(), (TypeSpec)jaxRsInterface).skipJavaLangImports(true).build();
        return javaFile.toString();
    }

    private TypeName generateTypeName(String collection, String type, String format, Boolean required, TypeName defaultType) {
        if (type == null) {
            return defaultType;
        }
        if (required == null) {
            required = Boolean.FALSE;
        }
        boolean isList = "list".equals(collection);
        Object coreType = null;
        if (type.equals("string")) {
            coreType = ClassName.get(String.class);
            if (format != null) {
                if (format.equals("date") || format.equals("date-time")) {
                    coreType = ClassName.get(Date.class);
                }
                if (format.equals("binary") && collection == null) {
                    coreType = defaultType;
                }
            }
        } else if (type.equals("integer")) {
            coreType = config.isUseLongIntegers() || "int64".equals(format) || "utc-millisec".equals(format) ? (required != false && !isList && format != null ? TypeName.LONG : ClassName.get(Long.class)) : (required != false && !isList && format != null ? TypeName.INT : ClassName.get(Integer.class));
        } else if (type.equals("number")) {
            coreType = ClassName.get(Number.class);
            if (format != null) {
                if (format.equals("float")) {
                    coreType = required != false && !isList ? TypeName.FLOAT : ClassName.get(Float.class);
                } else if (format.equals("double")) {
                    coreType = required != false && !isList ? TypeName.DOUBLE : ClassName.get(Double.class);
                }
            }
        } else if (type.equals("boolean")) {
            coreType = ClassName.get(Boolean.class);
        } else {
            try {
                coreType = ClassName.bestGuess((String)type);
            }
            catch (Exception e) {
                return defaultType;
            }
        }
        if (collection == null) {
            return coreType;
        }
        if ("list".equals(collection)) {
            return ParameterizedTypeName.get((ClassName)ClassName.get(List.class), (TypeName[])new TypeName[]{coreType});
        }
        return defaultType;
    }

    private TypeName generateReactiveTypeName(TypeName coreType) {
        return ParameterizedTypeName.get((ClassName)ClassName.get(CompletionStage.class), (TypeName[])new TypeName[]{coreType});
    }

    private static String toStringArrayLiteral(Set<String> values) {
        StringBuilder builder = new StringBuilder();
        if (values.size() == 1) {
            builder.append("\"");
            builder.append(values.iterator().next().replace("\"", "\\\""));
            builder.append("\"");
        } else {
            builder.append("{");
            boolean first = true;
            for (String value : values) {
                if (!first) {
                    builder.append(", ");
                }
                builder.append("\"");
                builder.append(value.replace("\"", "\\\""));
                builder.append("\"");
                first = false;
            }
            builder.append("}");
        }
        return builder.toString();
    }

    private void generateJavaBean(CodegenJavaBean bean, final CodegenInfo info, IndexedCodeWriter codeWriter) throws IOException {
        final JCodeModel codeModel = new JCodeModel();
        SchemaMapper schemaMapper = new SchemaMapper((RuleFactory)new JaxRsRuleFactory(config, (Annotator)new Jackson2Annotator(config), new SchemaStore(){

            public Schema create(Schema parent, String path, String refFragmentPathDelimiters) {
                String beanClassname = OpenApi2JaxRs.this.schemaRefToFQCN(path);
                for (CodegenJavaBean cgBean : info.getBeans()) {
                    String cgBeanFQCN = cgBean.getPackage() + "." + StringUtils.capitalize((String)cgBean.getName());
                    if (!beanClassname.equals(cgBeanFQCN)) continue;
                    Schema schema = new Schema(OpenApi2JaxRs.this.classnameToUri(beanClassname), cgBean.get$schema(), null);
                    JDefinedClass jclass = codeModel._getClass(beanClassname);
                    if (jclass == null) {
                        jclass = codeModel.directClass(beanClassname);
                    }
                    schema.setJavaType((JType)jclass);
                    return schema;
                }
                return super.create(parent, path, refFragmentPathDelimiters);
            }
        }), new SchemaGenerator());
        String source = mapper.writeValueAsString((Object)bean.get$schema());
        schemaMapper.generate(codeModel, bean.getName(), bean.getPackage(), source);
        codeModel.build((CodeWriter)codeWriter);
        String fqcn = bean.getPackage() + "." + bean.getName();
        codeWriter.indexBean(fqcn, bean);
    }

    protected URL getResource(String name) {
        return this.getClass().getResource(this.getResourceName(name));
    }

    protected String getResourceName(String name) {
        return "_" + this.getClass().getSimpleName() + "/" + name;
    }

    protected URI classnameToUri(String path) {
        return URI.create(path.replace('.', '/') + ".java");
    }

    protected String schemaRefToFQCN(String path) {
        return CodegenUtil.schemaRefToFQCN(this.document, path, this.settings.javaPackage + ".beans");
    }

    protected String javaPackageToZipPath(String javaPackage) {
        return (this.settings.isMavenFileStructure() ? "src/main/java/" : "") + OpenApi2JaxRs.javaPackageToPath(javaPackage);
    }

    private static String javaPackageToPath(String javaPackage) {
        return javaPackage.replaceAll("[^A-Za-z0-9.]", "").replace('.', '/') + "/";
    }

    private static String paramNameToJavaArgName(String paramName) {
        if (paramName == null) {
            return null;
        }
        String[] split = paramName.replaceAll("[^a-zA-Z0-9_]", "_").split("_");
        StringBuilder builder = new StringBuilder();
        boolean first = true;
        for (String term : split) {
            if (term.trim().length() == 0) continue;
            if (first) {
                builder.append(OpenApi2JaxRs.decapitalize(term));
                first = false;
                continue;
            }
            builder.append(OpenApi2JaxRs.capitalize(term));
        }
        Object rval = builder.toString();
        if (!SourceVersion.isName((CharSequence)rval)) {
            rval = "_" + (String)rval;
        }
        return rval;
    }

    private static String capitalize(String term) {
        if (term.length() == 1) {
            return term.toUpperCase();
        }
        return term.substring(0, 1).toUpperCase() + term.substring(1);
    }

    private static String decapitalize(String term) {
        if (term.length() == 1) {
            return term.toLowerCase();
        }
        return term.substring(0, 1).toLowerCase() + term.substring(1);
    }

    public boolean isUpdateOnly() {
        return this.updateOnly;
    }

    public JaxRsProjectSettings getSettings() {
        return this.settings;
    }

    public void setUpdateOnly(boolean updateOnly) {
        this.updateOnly = updateOnly;
    }

    public static class JaxRsRuleFactory
    extends RuleFactory {
        public JaxRsRuleFactory(GenerationConfig generationConfig, Annotator annotator, SchemaStore schemaStore) {
            super(generationConfig, annotator, schemaStore);
        }

        public Rule<JClassContainer, JType> getEnumRule() {
            return new JaxRsEnumRule(this);
        }
    }
}

