/*
 * Decompiled with CFR 0.152.
 */
package io.apicurio.hub.api.codegen.jaxrs;

import com.fasterxml.jackson.databind.JsonNode;
import io.apicurio.datamodels.Library;
import io.apicurio.datamodels.combined.visitors.CombinedVisitorAdapter;
import io.apicurio.datamodels.core.models.Document;
import io.apicurio.datamodels.core.models.DocumentType;
import io.apicurio.datamodels.core.models.Extension;
import io.apicurio.datamodels.core.models.Node;
import io.apicurio.datamodels.core.models.common.IDefinition;
import io.apicurio.datamodels.core.models.common.Info;
import io.apicurio.datamodels.core.models.common.Operation;
import io.apicurio.datamodels.core.models.common.Parameter;
import io.apicurio.datamodels.core.util.VisitorUtil;
import io.apicurio.datamodels.core.visitors.IVisitor;
import io.apicurio.datamodels.openapi.models.OasOperation;
import io.apicurio.datamodels.openapi.models.OasParameter;
import io.apicurio.datamodels.openapi.models.OasPathItem;
import io.apicurio.datamodels.openapi.models.OasResponse;
import io.apicurio.datamodels.openapi.models.OasSchema;
import io.apicurio.datamodels.openapi.v2.models.Oas20Document;
import io.apicurio.datamodels.openapi.v2.models.Oas20Operation;
import io.apicurio.datamodels.openapi.v2.models.Oas20Parameter;
import io.apicurio.datamodels.openapi.v2.models.Oas20Response;
import io.apicurio.datamodels.openapi.v3.models.Oas30MediaType;
import io.apicurio.datamodels.openapi.v3.models.Oas30Parameter;
import io.apicurio.datamodels.openapi.v3.models.Oas30RequestBody;
import io.apicurio.datamodels.openapi.v3.models.Oas30Response;
import io.apicurio.hub.api.codegen.beans.CodegenBeanAnnotationDirective;
import io.apicurio.hub.api.codegen.beans.CodegenInfo;
import io.apicurio.hub.api.codegen.beans.CodegenJavaArgument;
import io.apicurio.hub.api.codegen.beans.CodegenJavaBean;
import io.apicurio.hub.api.codegen.beans.CodegenJavaInterface;
import io.apicurio.hub.api.codegen.beans.CodegenJavaMethod;
import io.apicurio.hub.api.codegen.beans.CodegenJavaReturn;
import io.apicurio.hub.api.codegen.jaxrs.InterfaceInfo;
import io.apicurio.hub.api.codegen.jaxrs.PathItemDetectionVisitor;
import io.apicurio.hub.api.codegen.util.CodegenUtil;
import io.apicurio.hub.api.codegen.util.SchemaSigner;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;

public class OpenApi2CodegenVisitor
extends CombinedVisitorAdapter {
    private String packageName;
    private Map<String, String> interfacesIndex = new HashMap<String, String>();
    private CodegenInfo codegenInfo = new CodegenInfo();
    private CodegenJavaInterface _currentInterface;
    private List<CodegenJavaMethod> _currentMethods;
    private CodegenJavaArgument _currentArgument;
    private int _methodCounter = 1;
    private boolean _processPathItemParams = false;

    public OpenApi2CodegenVisitor(String packageName, List<InterfaceInfo> interfaces) {
        this.codegenInfo.setName("Thorntail API");
        this.codegenInfo.setVersion("1.0.0");
        this.codegenInfo.setInterfaces(new ArrayList<CodegenJavaInterface>());
        this.codegenInfo.setBeans(new ArrayList<CodegenJavaBean>());
        this.packageName = packageName;
        for (InterfaceInfo iface : interfaces) {
            for (String path : iface.paths) {
                this.interfacesIndex.put(path, iface.name);
            }
        }
    }

    public CodegenInfo getCodegenInfo() {
        return this.codegenInfo;
    }

    private static String createSignature(OasSchema node) {
        SchemaSigner signer = new SchemaSigner();
        Library.visitNode((Node)node, (IVisitor)signer);
        return signer.getSignature();
    }

    public void visitDocument(Document node) {
        this.processCodegenConfig(node.getExtension("x-codegen"));
    }

    private void processCodegenConfig(Extension extension) {
        if (extension != null && extension.value instanceof Map) {
            String cr;
            Map codegen = (Map)extension.value;
            List annotations = (List)codegen.get("bean-annotations");
            if (annotations != null) {
                this.codegenInfo.setBeanAnnotations(OpenApi2CodegenVisitor.annotations(annotations));
            }
            if ((cr = (String)codegen.get("contextRoot")) != null) {
                this.codegenInfo.setContextRoot(cr);
            }
        }
    }

    public void visitInfo(Info node) {
        this.codegenInfo.setName(node.title);
        if (node.description != null) {
            this.codegenInfo.setDescription(node.description);
        }
        this.codegenInfo.setVersion(node.version);
    }

    public void visitPathItem(OasPathItem node) {
        CodegenJavaInterface cgInterface;
        String path = node.getPath();
        this._currentInterface = cgInterface = this.getOrCreateInterface(path);
    }

    public void visitOperation(Operation node) {
        OasOperation op = (OasOperation)node;
        CodegenJavaMethod method = new CodegenJavaMethod();
        method.setName(this.methodName(op));
        method.setPath(this.methodPath(op));
        method.setMethod(node.getType());
        method.setProduces(new HashSet<String>());
        method.setConsumes(new HashSet<String>());
        method.setArguments(new ArrayList<CodegenJavaArgument>());
        if (node.description != null) {
            method.setDescription(node.description);
        }
        if (node.ownerDocument().getDocumentType() == DocumentType.openapi2) {
            List consumes;
            List produces = ((Oas20Operation)node).produces;
            if (produces == null) {
                produces = ((Oas20Document)node.ownerDocument()).produces;
            }
            if (produces != null) {
                method.setProduces(new HashSet<String>(produces));
            }
            if ((consumes = ((Oas20Operation)node).consumes) == null) {
                consumes = ((Oas20Document)node.ownerDocument()).consumes;
            }
            if (consumes != null) {
                method.setConsumes(new HashSet<String>(consumes));
            }
        }
        boolean async = false;
        Extension asyncExt = node.getExtension("x-codegen-async");
        if (asyncExt != null && asyncExt.value != null) {
            async = Boolean.valueOf(asyncExt.value.toString());
        }
        method.setAsync(async);
        this._currentMethods = new ArrayList<CodegenJavaMethod>();
        this._currentMethods.add(method);
        this._currentInterface.getMethods().add(method);
        this._processPathItemParams = true;
        List parentParams = ((OasPathItem)node.parent()).parameters;
        if (parentParams != null && parentParams.size() > 0) {
            for (OasParameter parentParam : parentParams) {
                VisitorUtil.visitNode((Node)parentParam, (IVisitor)this);
            }
        }
        this._processPathItemParams = false;
    }

    public void visitParameter(Parameter node) {
        if (!this._processPathItemParams && this.isPathItem(node.parent())) {
            return;
        }
        OasParameter param = (OasParameter)node;
        CodegenJavaArgument cgArgument = new CodegenJavaArgument();
        cgArgument.setName(param.name);
        cgArgument.setIn(param.in);
        this._currentArgument = cgArgument;
        if (param.required != null) {
            cgArgument.setRequired(param.required);
        }
        this._currentMethods.forEach(method -> method.getArguments().add(cgArgument));
        if (param.ownerDocument().getDocumentType() == DocumentType.openapi2) {
            this.visit20Parameter((Oas20Parameter)param);
        }
        if (param.ownerDocument().getDocumentType() == DocumentType.openapi3) {
            this.visit30Parameter((Oas30Parameter)param);
        }
    }

    private void visit20Parameter(Oas20Parameter node) {
        CodegenJavaReturn cgReturn = this.returnFromSchema((OasSchema)node.schema);
        if (cgReturn != null) {
            if (cgReturn.getCollection() != null) {
                this._currentArgument.setCollection(cgReturn.getCollection());
            }
            if (cgReturn.getType() != null) {
                this._currentArgument.setType(cgReturn.getType());
            }
            if (cgReturn.getFormat() != null) {
                this._currentArgument.setFormat(cgReturn.getFormat());
            }
            this._currentArgument.setTypeSignature(OpenApi2CodegenVisitor.createSignature((OasSchema)node.schema));
        } else if (node.type != null) {
            if (node.type != null) {
                this._currentArgument.setType(node.type);
            }
            if (node.format != null) {
                this._currentArgument.setFormat(node.format);
            }
        }
    }

    private void visit30Parameter(Oas30Parameter node) {
        CodegenJavaReturn cgReturn;
        List mediaTypes = node.getMediaTypes();
        if (mediaTypes.size() > 0) {
            Oas30MediaType mediaType = (Oas30MediaType)mediaTypes.get(0);
            CodegenJavaReturn cgReturn2 = this.returnFromSchema((OasSchema)mediaType.schema);
            if (cgReturn2 != null) {
                if (cgReturn2.getCollection() != null) {
                    this._currentArgument.setCollection(cgReturn2.getCollection());
                }
                if (cgReturn2.getType() != null) {
                    this._currentArgument.setType(cgReturn2.getType());
                }
                if (cgReturn2.getFormat() != null) {
                    this._currentArgument.setFormat(cgReturn2.getFormat());
                }
                this._currentArgument.setTypeSignature(OpenApi2CodegenVisitor.createSignature((OasSchema)mediaType.schema));
            }
        } else if (node.schema != null && (cgReturn = this.returnFromSchema((OasSchema)node.schema)) != null) {
            if (cgReturn.getCollection() != null) {
                this._currentArgument.setCollection(cgReturn.getCollection());
            }
            if (cgReturn.getType() != null) {
                this._currentArgument.setType(cgReturn.getType());
            }
            if (cgReturn.getFormat() != null) {
                this._currentArgument.setFormat(cgReturn.getFormat());
            }
            this._currentArgument.setTypeSignature(OpenApi2CodegenVisitor.createSignature((OasSchema)node.schema));
        }
    }

    public void visitRequestBody(Oas30RequestBody node) {
        List mediaTypes = node.getMediaTypes();
        HashMap allReturnTypes = new HashMap();
        if (mediaTypes != null && mediaTypes.size() > 0) {
            mediaTypes.forEach(mediaType -> {
                CodegenJavaReturn cgReturn = this.returnFromSchema((OasSchema)mediaType.schema);
                if (cgReturn == null) {
                    cgReturn = new CodegenJavaReturn();
                }
                allReturnTypes.merge(cgReturn, Collections.singleton(mediaType.getName()), (set1, set2) -> {
                    HashSet merged = new HashSet();
                    merged.addAll(set1);
                    merged.addAll(set2);
                    return merged;
                });
            });
        }
        if (!allReturnTypes.isEmpty()) {
            CodegenJavaMethod methodTemplate = this._currentMethods.get(0);
            List methods = allReturnTypes.entrySet().stream().map(entry -> {
                CodegenJavaReturn returnType = (CodegenJavaReturn)entry.getKey();
                Set types = (Set)entry.getValue();
                CodegenJavaMethod clonedMethod = methodTemplate.clone();
                clonedMethod.getConsumes().addAll(types);
                CodegenJavaArgument cgArgument = new CodegenJavaArgument();
                cgArgument.setName("data");
                cgArgument.setIn("body");
                cgArgument.setRequired(true);
                if (returnType.getCollection() != null) {
                    cgArgument.setCollection(returnType.getCollection());
                }
                if (returnType.getType() != null) {
                    cgArgument.setType(returnType.getType());
                }
                if (returnType.getFormat() != null) {
                    cgArgument.setFormat(returnType.getFormat());
                }
                clonedMethod.getArguments().add(cgArgument);
                return clonedMethod;
            }).collect(Collectors.toList());
            this._currentInterface.getMethods().remove(methodTemplate);
            this._currentInterface.getMethods().addAll(methods);
            this._currentMethods = methods;
        }
    }

    public void visitResponse(OasResponse node) {
        if (node.getStatusCode() != null && node.getStatusCode().indexOf("2") == 0 && this._currentMethods.get(0).getReturn() == null) {
            if (node.ownerDocument().getDocumentType() == DocumentType.openapi2) {
                this.visit20Response((Oas20Response)node);
            }
            if (node.ownerDocument().getDocumentType() == DocumentType.openapi3) {
                this.visit30Response((Oas30Response)node);
            }
        }
    }

    private void visit20Response(Oas20Response node) {
        if (node.getStatusCode() != null && node.getStatusCode().indexOf("2") == 0) {
            this._currentMethods.forEach(_currentMethod -> _currentMethod.setReturn(this.returnFromSchema((OasSchema)node.schema)));
        }
    }

    private void visit30Response(Oas30Response node) {
        List mediaTypes = node.getMediaTypes();
        if (mediaTypes != null && mediaTypes.size() > 0) {
            Oas30MediaType mediaType = (Oas30MediaType)mediaTypes.get(0);
            Extension returnTypeExt = mediaType.getExtension("x-codegen-returnType");
            CodegenJavaReturn cgReturn = null;
            if (returnTypeExt != null) {
                String returnType = (String)returnTypeExt.value;
                CodegenJavaReturn customReturn = new CodegenJavaReturn();
                customReturn.setType(returnType);
                cgReturn = customReturn;
            } else {
                cgReturn = this.returnFromSchema((OasSchema)mediaType.schema);
            }
            if (cgReturn == null) {
                CodegenJavaReturn unknownReturn = new CodegenJavaReturn();
                unknownReturn.setType("javax.ws.rs.core.Response");
                cgReturn = unknownReturn;
            }
            CodegenJavaReturn _return = cgReturn;
            this._currentMethods.forEach(_currentMethod -> _currentMethod.setReturn(_return));
        }
        for (Oas30MediaType mt : mediaTypes) {
            this._currentMethods.forEach(_currentMethod -> _currentMethod.getProduces().add(mt.getName()));
        }
    }

    public void visitSchemaDefinition(IDefinition node) {
        String name = node.getName();
        OasSchema schema = (OasSchema)node;
        CodegenJavaBean bean = new CodegenJavaBean();
        bean.setName(name);
        bean.setPackage(CodegenUtil.schemaToPackageName(schema, this.packageName + ".beans"));
        bean.set$schema((JsonNode)Library.writeNode((Node)schema));
        bean.setSignature(OpenApi2CodegenVisitor.createSignature(schema));
        bean.setAnnotations(this.annotations(schema.getExtension("x-codegen-annotations")));
        this.codegenInfo.getBeans().add(bean);
    }

    private List<CodegenBeanAnnotationDirective> annotations(Extension extension) {
        if (extension != null && extension.value instanceof List) {
            List annotationExtensions = (List)extension.value;
            return OpenApi2CodegenVisitor.annotations(annotationExtensions);
        }
        return Collections.emptyList();
    }

    private static List<CodegenBeanAnnotationDirective> annotations(List<?> annotationExtensions) {
        return annotationExtensions.stream().map(annotationExtension -> {
            if (annotationExtension instanceof String) {
                CodegenBeanAnnotationDirective directive = new CodegenBeanAnnotationDirective();
                directive.setAnnotation((String)annotationExtension);
                return directive;
            }
            if (annotationExtension instanceof Map) {
                Map aeMap = (Map)annotationExtension;
                String annotation = (String)aeMap.get("annotation");
                Boolean excludeEnums = (Boolean)aeMap.get("excludeEnums");
                if (annotation == null) {
                    return null;
                }
                CodegenBeanAnnotationDirective directive = new CodegenBeanAnnotationDirective();
                directive.setAnnotation(annotation);
                if (excludeEnums != null) {
                    directive.setExcludeEnums(excludeEnums);
                }
                return directive;
            }
            return null;
        }).filter(item -> item != null).collect(Collectors.toUnmodifiableList());
    }

    private CodegenJavaInterface getOrCreateInterface(String path) {
        CodegenJavaInterface cgInterface2;
        if (!((String)path).startsWith("/")) {
            path = "/" + (String)path;
        }
        String interfaceName = this.interfacesIndex.get(path);
        for (CodegenJavaInterface cgInterface2 : this.codegenInfo.getInterfaces()) {
            if (!cgInterface2.getName().equals(interfaceName)) continue;
            return cgInterface2;
        }
        Object ifacePath = "/";
        if (!"Root".equals(interfaceName) && !"RootResource".equals(interfaceName)) {
            ifacePath = "/" + ((String)path).split("/")[1];
        }
        cgInterface2 = new CodegenJavaInterface();
        cgInterface2.setName(interfaceName);
        cgInterface2.setPackage(this.packageName);
        cgInterface2.setPath((String)ifacePath);
        cgInterface2.setMethods(new ArrayList<CodegenJavaMethod>());
        this.codegenInfo.getInterfaces().add(cgInterface2);
        return cgInterface2;
    }

    private String methodName(OasOperation operation) {
        if (operation.operationId != null && operation.operationId.length() > 0) {
            return this.operationIdToMethodName(operation.operationId);
        }
        if (operation.summary != null && operation.summary.length() > 0) {
            String[] nameSegments = operation.summary.split(" ");
            StringBuilder builder = new StringBuilder();
            for (String segment : nameSegments) {
                String sanitized = segment.replaceAll("\\W", "");
                builder.append(this.capitalize(sanitized));
            }
            String cname = builder.toString();
            if (cname.trim().length() > 0) {
                return this.decapitalize(builder.toString());
            }
        }
        return "generatedMethod" + this._methodCounter++;
    }

    private String operationIdToMethodName(String operationId) {
        return operationId.replaceAll("[^a-zA-Z0-9_]", "_");
    }

    private String methodPath(OasOperation operation) {
        String path = ((OasPathItem)operation.parent()).getPath();
        if (path.equals(this._currentInterface.getPath())) {
            return null;
        }
        if ("/".equals(path = path.substring(this._currentInterface.getPath().length()))) {
            return null;
        }
        return path;
    }

    private CodegenJavaReturn returnFromSchema(OasSchema schema) {
        if (schema == null) {
            return null;
        }
        CodegenJavaReturn cgReturn = new CodegenJavaReturn();
        cgReturn.setType(null);
        if (schema.$ref != null) {
            cgReturn.setType(this.typeFromSchemaRef(schema.ownerDocument(), schema.$ref));
        } else if ("array".equals(schema.type)) {
            cgReturn.setCollection("list");
            OasSchema items = (OasSchema)schema.items;
            CodegenJavaReturn subReturn = this.returnFromSchema(items);
            if (subReturn != null && subReturn.getType() != null) {
                cgReturn.setType(subReturn.getType());
            }
            if (subReturn != null && subReturn.getFormat() != null) {
                cgReturn.setFormat(subReturn.getFormat());
            }
        } else {
            if (schema.type != null) {
                cgReturn.setType(schema.type);
            }
            if (schema.format != null) {
                cgReturn.setFormat(schema.format);
            }
        }
        return cgReturn;
    }

    private String typeFromSchemaRef(Document document, String schemaRef) {
        return CodegenUtil.schemaRefToFQCN(document, schemaRef, this.packageName + ".beans");
    }

    private boolean isPathItem(Node node) {
        PathItemDetectionVisitor viz = new PathItemDetectionVisitor();
        VisitorUtil.visitNode((Node)node, (IVisitor)viz);
        return viz.isPathItem;
    }

    private String capitalize(String word) {
        if (word == null || word.trim().length() == 0) {
            return "";
        }
        return word.substring(0, 1).toUpperCase() + word.substring(1);
    }

    private String decapitalize(String word) {
        if (word == null || word.trim().length() == 0) {
            return "";
        }
        return word.substring(0, 1).toLowerCase() + word.substring(1);
    }
}

