/*
 * Decompiled with CFR 0.152.
 */
package io.apicurio.hub.api.codegen.post;

import io.apicurio.hub.api.codegen.beans.CodegenBeanAnnotationDirective;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.util.List;

public class JavaBeanPostProcessor {
    public ByteArrayOutputStream process(String className, List<CodegenBeanAnnotationDirective> annotations, ByteArrayOutputStream beanData) throws IOException {
        boolean modified = false;
        String content = beanData.toString(StandardCharsets.UTF_8.name());
        if (content.contains("import java.lang.String;")) {
            content = content.replaceAll("import java.lang.String;", "");
            modified = true;
        }
        if (content.contains("java.lang.String")) {
            content = content.replaceAll("java.lang.String", "String");
            modified = true;
        }
        boolean isEnum = content.contains("public enum");
        if (annotations != null && !annotations.isEmpty()) {
            StringBuilder builder = new StringBuilder();
            int annotationCount = 0;
            for (CodegenBeanAnnotationDirective annotation : annotations) {
                if (annotation.isExcludeEnums() && isEnum) continue;
                builder.append("@");
                builder.append(annotation.getAnnotation());
                builder.append("\n");
                ++annotationCount;
            }
            if (annotationCount > 0) {
                content = content.replace("public class ", builder.toString() + "public class ");
                content = content.replace("public enum ", builder.toString() + "public enum ");
                modified = true;
            }
        }
        if (modified) {
            ByteArrayOutputStream rval = new ByteArrayOutputStream();
            rval.write(content.getBytes(StandardCharsets.UTF_8.name()));
            return rval;
        }
        return beanData;
    }
}

