/*
 * Decompiled with CFR 0.152.
 */
package io.apicurio.hub.api.codegen.util;

import io.apicurio.datamodels.combined.visitors.CombinedAllNodeVisitor;
import io.apicurio.datamodels.core.models.common.IDefinition;
import io.apicurio.datamodels.core.models.common.Schema;
import io.apicurio.datamodels.openapi.models.OasSchema;
import io.apicurio.datamodels.openapi.v3.models.Oas30Schema;
import java.util.Arrays;
import org.apache.commons.codec.digest.DigestUtils;

public class SchemaSigner
extends CombinedAllNodeVisitor {
    private StringBuilder sigSource = new StringBuilder();

    public String getSignature() {
        if (this.sigSource.length() == 0) {
            return null;
        }
        return DigestUtils.sha256Hex((String)this.sigSource.toString());
    }

    public void visitSchema(Schema node) {
        OasSchema schema = (OasSchema)node;
        if (schema.type != null && !schema.type.equals("object") && !schema.type.equals("array") && schema.$ref == null) {
            this.sigSource.append("TYPE:");
            this.sigSource.append(schema.type);
            if (schema.format != null) {
                this.sigSource.append("|FORMAT:");
                this.sigSource.append(schema.format);
            }
            if (schema.enum_ != null && schema.enum_.size() > 0) {
                this.sigSource.append("|ENUM:");
                Object[] options = schema.enum_.toArray(new String[schema.enum_.size()]);
                Arrays.sort(options);
                for (Object option : options) {
                    this.sigSource.append((String)option);
                    this.sigSource.append(",");
                }
            }
            if (schema.maximum != null) {
                this.sigSource.append("|MAX:");
                this.sigSource.append(schema.maximum);
            }
            if (schema.maxItems != null) {
                this.sigSource.append("|MAXITEMS:");
                this.sigSource.append(schema.maxItems);
            }
            if (schema.maxLength != null) {
                this.sigSource.append("|MAXLENGTH:");
                this.sigSource.append(schema.maxLength);
            }
            if (schema.minimum != null) {
                this.sigSource.append("|MIN:");
                this.sigSource.append(schema.minimum);
            }
            if (schema.minItems != null) {
                this.sigSource.append("|MINITEMS:");
                this.sigSource.append(schema.minItems);
            }
            if (schema.minLength != null) {
                this.sigSource.append("|MINLENGTH:");
                this.sigSource.append(schema.minLength);
            }
            if (schema.minProperties != null) {
                this.sigSource.append("|MINPROPS:");
                this.sigSource.append(schema.minProperties);
            }
            if (schema.multipleOf != null) {
                this.sigSource.append("|MULTIPLEOF:");
                this.sigSource.append(schema.multipleOf);
            }
            if (schema.pattern != null) {
                this.sigSource.append("|PATTERN:");
                this.sigSource.append(schema.pattern);
            }
        }
    }

    public void visitAdditionalPropertiesSchema(OasSchema node) {
        this.visitSchema((Schema)node);
    }

    public void visitAllOfSchema(OasSchema node) {
        this.visitSchema((Schema)node);
    }

    public void visitAnyOfSchema(Oas30Schema.Oas30AnyOfSchema node) {
        this.visitSchema((Schema)node);
    }

    public void visitItemsSchema(OasSchema node) {
        this.visitSchema((Schema)node);
    }

    public void visitSchemaDefinition(IDefinition node) {
        this.visitSchema((Schema)((OasSchema)node));
    }

    public void visitNotSchema(Oas30Schema.Oas30NotSchema node) {
        this.visitSchema((Schema)node);
    }

    public void visitOneOfSchema(Oas30Schema.Oas30OneOfSchema node) {
        this.visitSchema((Schema)node);
    }
}

