/*
 * Decompiled with CFR 0.152.
 */
package io.pravega.client.tables.impl;

import com.google.common.base.Functions;
import com.google.common.base.Preconditions;
import com.google.common.collect.Iterators;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import io.pravega.client.tables.BadKeyVersionException;
import io.pravega.client.tables.ConditionalTableUpdateException;
import io.pravega.client.tables.IteratorItem;
import io.pravega.client.tables.KeyValueTableMap;
import io.pravega.client.tables.TableEntry;
import io.pravega.client.tables.TableKey;
import io.pravega.client.tables.Version;
import io.pravega.client.tables.impl.KeyValueTableImpl;
import io.pravega.common.concurrent.Futures;
import io.pravega.common.util.Retry;
import java.beans.ConstructorProperties;
import java.util.AbstractCollection;
import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.Spliterator;
import java.util.Spliterators;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.BiFunction;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;
import lombok.Generated;
import lombok.NonNull;

final class KeyValueTableMapImpl<KeyT, ValueT>
implements KeyValueTableMap<KeyT, ValueT> {
    private static final int ITERATOR_BATCH_SIZE = 100;
    private static final Retry.RetryAndThrowExceptionally<ConditionalTableUpdateException, RuntimeException> RETRY = Retry.withExpBackoff((long)10L, (int)4, (int)10, (long)30000L).retryingOn(ConditionalTableUpdateException.class).throwingOn(RuntimeException.class);
    @NonNull
    private final KeyValueTableImpl<KeyT, ValueT> kvt;
    private final String keyFamily;

    @Override
    public boolean containsKey(@NonNull Object key) {
        if (key == null) {
            throw new NullPointerException("key is marked non-null but is null");
        }
        TableEntry<Object, ValueT> e = this.kvt.get(this.keyFamily, key).join();
        return e != null;
    }

    @Override
    public boolean containsValue(@NonNull Object o) {
        if (o == null) {
            throw new NullPointerException("o is marked non-null but is null");
        }
        this.requiresKeyFamily("containsValue");
        Object value = o;
        return this.entryStream().anyMatch(e -> Objects.equals(e.getValue(), value));
    }

    @Override
    public ValueT get(@NonNull Object key) {
        if (key == null) {
            throw new NullPointerException("key is marked non-null but is null");
        }
        TableEntry<Object, ValueT> e = this.kvt.get(this.keyFamily, key).join();
        return e == null ? null : (ValueT)e.getValue();
    }

    @Override
    public ValueT getOrDefault(@NonNull Object key, ValueT defaultValue) {
        if (key == null) {
            throw new NullPointerException("key is marked non-null but is null");
        }
        ValueT value = this.get(key);
        return value == null ? defaultValue : value;
    }

    @Override
    public ValueT put(@NonNull KeyT key, @NonNull ValueT value) {
        if (key == null) {
            throw new NullPointerException("key is marked non-null but is null");
        }
        if (value == null) {
            throw new NullPointerException("value is marked non-null but is null");
        }
        AtomicReference oldValue = new AtomicReference();
        ((CompletableFuture)this.kvt.get(this.keyFamily, key).thenCompose(existingEntry -> {
            oldValue.set(existingEntry == null ? null : (Object)existingEntry.getValue());
            return this.kvt.put(this.keyFamily, key, value);
        })).join();
        return (ValueT)oldValue.get();
    }

    @Override
    public void putDirect(@NonNull KeyT key, @NonNull ValueT value) {
        if (key == null) {
            throw new NullPointerException("key is marked non-null but is null");
        }
        if (value == null) {
            throw new NullPointerException("value is marked non-null but is null");
        }
        this.kvt.put(this.keyFamily, key, value).join();
    }

    @Override
    public void putAll(@NonNull Map<? extends KeyT, ? extends ValueT> map) {
        if (map == null) {
            throw new NullPointerException("map is marked non-null but is null");
        }
        this.requiresKeyFamily("putAll");
        Iterator iterator = Iterators.transform(map.entrySet().iterator(), e -> e);
        this.kvt.putAll(this.keyFamily, iterator).join();
    }

    @Override
    public ValueT putIfAbsent(@NonNull KeyT key, @NonNull ValueT value) {
        if (key == null) {
            throw new NullPointerException("key is marked non-null but is null");
        }
        if (value == null) {
            throw new NullPointerException("value is marked non-null but is null");
        }
        return (ValueT)Futures.exceptionallyComposeExpecting((CompletableFuture)this.kvt.putIfAbsent(this.keyFamily, key, value).thenApply(version -> value), ex -> ex instanceof BadKeyVersionException, () -> this.kvt.get(this.keyFamily, key).thenApply(TableEntry::getValue)).join();
    }

    @Override
    public boolean replace(@NonNull KeyT key, @NonNull ValueT expectedValue, @NonNull ValueT newValue) {
        if (key == null) {
            throw new NullPointerException("key is marked non-null but is null");
        }
        if (expectedValue == null) {
            throw new NullPointerException("expectedValue is marked non-null but is null");
        }
        if (newValue == null) {
            throw new NullPointerException("newValue is marked non-null but is null");
        }
        return (Boolean)RETRY.run(() -> (Boolean)((CompletableFuture)this.kvt.get(this.keyFamily, key).thenCompose(e -> {
            if (e != null && Objects.equals(expectedValue, e.getValue())) {
                return this.kvt.replace(this.keyFamily, key, newValue, e.getKey().getVersion()).thenApply(v -> true);
            }
            return CompletableFuture.completedFuture(false);
        })).join());
    }

    @Override
    public ValueT replace(@NonNull KeyT key, @NonNull ValueT value) {
        if (key == null) {
            throw new NullPointerException("key is marked non-null but is null");
        }
        if (value == null) {
            throw new NullPointerException("value is marked non-null but is null");
        }
        return (ValueT)RETRY.run(() -> ((CompletableFuture)this.kvt.get(this.keyFamily, key).thenCompose(e -> {
            if (e != null) {
                return this.kvt.replace(this.keyFamily, key, value, e.getKey().getVersion()).thenApply(v -> e.getValue());
            }
            return CompletableFuture.completedFuture(null);
        })).join());
    }

    @Override
    public void replaceAll(@NonNull BiFunction<? super KeyT, ? super ValueT, ? extends ValueT> convert) {
        if (convert == null) {
            throw new NullPointerException("convert is marked non-null but is null");
        }
        this.requiresKeyFamily("replaceAll");
        Iterator baseIterator = this.kvt.entryIterator(this.keyFamily, 100, null).asIterator();
        ArrayList<CompletableFuture<List<Version>>> updateFutures = new ArrayList<CompletableFuture<List<Version>>>();
        while (baseIterator.hasNext()) {
            Iterator toUpdate = ((IteratorItem)baseIterator.next()).getItems().stream().map(e -> new AbstractMap.SimpleImmutableEntry(e.getKey().getKey(), convert.apply((Object)e.getKey().getKey(), (Object)e.getValue()))).iterator();
            if (!toUpdate.hasNext()) continue;
            updateFutures.add(this.kvt.putAll(this.keyFamily, toUpdate));
        }
        if (updateFutures.size() > 0) {
            Futures.allOf(updateFutures).join();
        }
    }

    @Override
    public ValueT remove(@NonNull Object key) {
        if (key == null) {
            throw new NullPointerException("key is marked non-null but is null");
        }
        Object k = key;
        AtomicReference existingValue = new AtomicReference();
        RETRY.run(() -> (Void)((CompletableFuture)this.kvt.get(this.keyFamily, k).thenCompose(e -> {
            if (e == null) {
                existingValue.set(null);
                return this.kvt.remove(this.keyFamily, k);
            }
            existingValue.set(e.getValue());
            return this.kvt.remove(this.keyFamily, k, e.getKey().getVersion());
        })).join());
        return (ValueT)existingValue.get();
    }

    @Override
    public boolean remove(@NonNull Object key, Object expectedValue) {
        if (key == null) {
            throw new NullPointerException("key is marked non-null but is null");
        }
        Object k = key;
        Object ev = expectedValue;
        return (Boolean)RETRY.run(() -> (Boolean)((CompletableFuture)this.kvt.get(this.keyFamily, k).thenCompose(e -> {
            if (e != null && Objects.equals(ev, e.getValue())) {
                return this.kvt.remove(this.keyFamily, k, e.getKey().getVersion()).thenApply(v -> true);
            }
            return CompletableFuture.completedFuture(false);
        })).join());
    }

    @Override
    public void removeDirect(KeyT key) {
        this.kvt.remove(this.keyFamily, key).join();
    }

    @Override
    public ValueT compute(@NonNull KeyT key, @NonNull BiFunction<? super KeyT, ? super ValueT, ? extends ValueT> toCompute) {
        if (key == null) {
            throw new NullPointerException("key is marked non-null but is null");
        }
        if (toCompute == null) {
            throw new NullPointerException("toCompute is marked non-null but is null");
        }
        ValueT existingValue = this.get(key);
        ValueT newValue = toCompute.apply(key, existingValue);
        if (newValue == null) {
            if (existingValue != null) {
                this.removeDirect(key);
            }
            return null;
        }
        if (!Objects.equals(existingValue, newValue)) {
            this.putDirect(key, newValue);
        }
        return newValue;
    }

    @Override
    public ValueT computeIfPresent(@NonNull KeyT key, BiFunction<? super KeyT, ? super ValueT, ? extends ValueT> toCompute) {
        if (key == null) {
            throw new NullPointerException("key is marked non-null but is null");
        }
        ValueT existingValue = this.get(key);
        if (existingValue != null) {
            ValueT newValue = toCompute.apply(key, existingValue);
            if (newValue != null) {
                if (!Objects.equals(existingValue, newValue)) {
                    this.putDirect(key, newValue);
                }
            } else {
                this.removeDirect(key);
            }
            return newValue;
        }
        return null;
    }

    @Override
    public ValueT computeIfAbsent(@NonNull KeyT key, Function<? super KeyT, ? extends ValueT> toCompute) {
        if (key == null) {
            throw new NullPointerException("key is marked non-null but is null");
        }
        ValueT existingValue = this.get(key);
        if (existingValue == null) {
            ValueT newValue = toCompute.apply(key);
            if (newValue != null) {
                this.putDirect(key, newValue);
            }
            return newValue;
        }
        return existingValue;
    }

    @Override
    public Set<KeyT> keySet() {
        this.requiresKeyFamily("keySet");
        return new KeySetImpl();
    }

    @Override
    public Collection<ValueT> values() {
        this.requiresKeyFamily("values");
        return new ValuesCollectionImpl();
    }

    @Override
    public Set<Map.Entry<KeyT, ValueT>> entrySet() {
        this.requiresKeyFamily("entrySet");
        return new EntrySetImpl();
    }

    @Override
    public int size() {
        this.requiresKeyFamily("size");
        long size = this.keyStream().count();
        return size > Integer.MAX_VALUE ? Integer.MAX_VALUE : (int)size;
    }

    @Override
    public boolean isEmpty() {
        this.requiresKeyFamily("isEmpty");
        return !this.keyStream().findFirst().isPresent();
    }

    @Override
    public void clear() {
        this.clear(key -> true);
    }

    private boolean clear(Predicate<? super KeyT> keyFilter) {
        this.requiresKeyFamily("clear");
        Iterator baseIterator = this.kvt.keyIterator(this.keyFamily, 100, null).asIterator();
        ArrayList<CompletableFuture<Void>> deleteFutures = new ArrayList<CompletableFuture<Void>>();
        while (baseIterator.hasNext()) {
            List toDelete = ((IteratorItem)baseIterator.next()).getItems().stream().filter(k -> keyFilter.test((Object)k.getKey())).map(k -> TableKey.unversioned(k.getKey())).collect(Collectors.toList());
            if (toDelete.size() <= 0) continue;
            deleteFutures.add(this.kvt.removeAll(this.keyFamily, toDelete));
        }
        if (deleteFutures.size() > 0) {
            Futures.allOf(deleteFutures).join();
            return true;
        }
        return false;
    }

    private void requiresKeyFamily(String opName) {
        if (this.keyFamily == null) {
            throw new UnsupportedOperationException(opName + "() requires a Key Family.");
        }
    }

    private boolean areSame(List<TableEntry<KeyT, ValueT>> expected, List<ValueT> actual) {
        assert (expected.size() == actual.size());
        for (int i = 0; i < expected.size(); ++i) {
            TableEntry<KeyT, ValueT> e = expected.get(i);
            if (e == null == (actual == null) && Objects.equals(actual.get(i), expected.get(i).getValue())) continue;
            return false;
        }
        return true;
    }

    private Stream<TableKey<KeyT>> keyStream() {
        Iterator baseIterator = this.kvt.keyIterator(this.keyFamily, 100, null).asIterator();
        return StreamSupport.stream(Spliterators.spliteratorUnknownSize(baseIterator, 0), false).flatMap(iteratorItem -> iteratorItem.getItems().stream());
    }

    private Stream<TableEntry<KeyT, ValueT>> entryStream() {
        Iterator baseIterator = this.kvt.entryIterator(this.keyFamily, 100, null).asIterator();
        return StreamSupport.stream(Spliterators.spliteratorUnknownSize(baseIterator, 0), false).flatMap(iteratorItem -> iteratorItem.getItems().stream());
    }

    private Map.Entry<KeyT, ValueT> toMapEntry(TableEntry<KeyT, ValueT> e) {
        return new AbstractMap.SimpleImmutableEntry<KeyT, ValueT>(e.getKey().getKey(), e.getValue());
    }

    @ConstructorProperties(value={"kvt", "keyFamily"})
    @SuppressFBWarnings(justification="generated code")
    @Generated
    public KeyValueTableMapImpl(@NonNull KeyValueTableImpl<KeyT, ValueT> kvt, String keyFamily) {
        if (kvt == null) {
            throw new NullPointerException("kvt is marked non-null but is null");
        }
        this.kvt = kvt;
        this.keyFamily = keyFamily;
    }

    @Override
    @SuppressFBWarnings(justification="generated code")
    @Generated
    public String getKeyFamily() {
        return this.keyFamily;
    }

    private class MapIterator<T>
    implements Iterator<T> {
        private final Iterator<T> baseIterator;
        private final Consumer<T> remove;
        private T lastItem;

        @Override
        public boolean hasNext() {
            return this.baseIterator.hasNext();
        }

        @Override
        public T next() {
            this.lastItem = this.baseIterator.next();
            return this.lastItem;
        }

        @Override
        public void remove() {
            Preconditions.checkState((this.lastItem != null ? 1 : 0) != 0, (Object)"Nothing to remove.");
            this.remove.accept(this.lastItem);
            this.lastItem = null;
        }

        @ConstructorProperties(value={"baseIterator", "remove"})
        @SuppressFBWarnings(justification="generated code")
        @Generated
        public MapIterator(Iterator<T> baseIterator, Consumer<T> remove) {
            this.baseIterator = baseIterator;
            this.remove = remove;
        }
    }

    private class EntrySetImpl
    extends BaseCollection<Map.Entry<KeyT, ValueT>>
    implements Set<Map.Entry<KeyT, ValueT>> {
        private EntrySetImpl() {
        }

        @Override
        public boolean contains(@NonNull Object o) {
            if (o == null) {
                throw new NullPointerException("o is marked non-null but is null");
            }
            if (o instanceof Map.Entry) {
                Map.Entry e = (Map.Entry)o;
                Object value = KeyValueTableMapImpl.this.get(e.getKey());
                return Objects.equals(e.getValue(), value);
            }
            return false;
        }

        @Override
        public boolean containsAll(@NonNull Collection<?> collection) {
            if (collection == null) {
                throw new NullPointerException("collection is marked non-null but is null");
            }
            ArrayList keys = new ArrayList(collection.size());
            ArrayList values = new ArrayList(collection.size());
            for (Object o : collection) {
                if (!(o instanceof Map.Entry)) {
                    return false;
                }
                Map.Entry e = (Map.Entry)o;
                keys.add(e.getKey());
                values.add(e.getValue());
            }
            List existingEntries = KeyValueTableMapImpl.this.kvt.getAll(KeyValueTableMapImpl.this.keyFamily, keys).join();
            return KeyValueTableMapImpl.this.areSame(existingEntries, values);
        }

        @Override
        public boolean add(@NonNull Map.Entry<KeyT, ValueT> e) {
            if (e == null) {
                throw new NullPointerException("e is marked non-null but is null");
            }
            Object finalValue = KeyValueTableMapImpl.this.putIfAbsent(e.getKey(), e.getValue());
            return Objects.equals(e.getValue(), finalValue);
        }

        @Override
        public boolean addAll(@NonNull Collection<? extends Map.Entry<KeyT, ValueT>> collection) {
            if (collection == null) {
                throw new NullPointerException("collection is marked non-null but is null");
            }
            KeyValueTableMapImpl.this.kvt.putAll(KeyValueTableMapImpl.this.keyFamily, Collections.unmodifiableCollection(collection)).join();
            return true;
        }

        @Override
        public boolean remove(Object o) {
            Map.Entry e = (Map.Entry)o;
            return KeyValueTableMapImpl.this.remove(e.getKey(), e.getValue());
        }

        @Override
        public boolean removeAll(Collection<?> collection) {
            ArrayList keys = new ArrayList(collection.size());
            ArrayList values = new ArrayList(collection.size());
            for (Object o : collection) {
                Map.Entry e = (Map.Entry)o;
                keys.add(e.getKey());
                values.add(e.getValue());
            }
            return (Boolean)((CompletableFuture)KeyValueTableMapImpl.this.kvt.getAll(KeyValueTableMapImpl.this.keyFamily, keys).thenCompose(existingValues -> {
                if (KeyValueTableMapImpl.this.areSame(existingValues, values)) {
                    List toRemove = existingValues.stream().map(TableEntry::getKey).collect(Collectors.toList());
                    return KeyValueTableMapImpl.this.kvt.removeAll(KeyValueTableMapImpl.this.keyFamily, toRemove).thenApply(v -> true);
                }
                return CompletableFuture.completedFuture(false);
            })).join();
        }

        @Override
        public boolean removeIf(Predicate<? super Map.Entry<KeyT, ValueT>> filter) {
            Iterator baseIterator = KeyValueTableMapImpl.this.kvt.entryIterator(KeyValueTableMapImpl.this.keyFamily, 100, null).asIterator();
            ArrayList<CompletableFuture<Void>> deleteFutures = new ArrayList<CompletableFuture<Void>>();
            while (baseIterator.hasNext()) {
                List toDelete = ((IteratorItem)baseIterator.next()).getItems().stream().map(x$0 -> KeyValueTableMapImpl.this.toMapEntry(x$0)).filter(filter).map(e -> TableKey.unversioned(e.getKey())).collect(Collectors.toList());
                if (toDelete.size() <= 0) continue;
                deleteFutures.add(KeyValueTableMapImpl.this.kvt.removeAll(KeyValueTableMapImpl.this.keyFamily, toDelete));
            }
            if (deleteFutures.size() > 0) {
                Futures.allOf(deleteFutures).join();
                return true;
            }
            return false;
        }

        @Override
        public Stream<Map.Entry<KeyT, ValueT>> stream() {
            return KeyValueTableMapImpl.this.entryStream().map(x$0 -> KeyValueTableMapImpl.this.toMapEntry(x$0));
        }
    }

    private class ValuesCollectionImpl
    extends BaseCollection<ValueT>
    implements Collection<ValueT> {
        private ValuesCollectionImpl() {
        }

        @Override
        public boolean contains(@NonNull Object o) {
            if (o == null) {
                throw new NullPointerException("o is marked non-null but is null");
            }
            Object value = o;
            return this.stream().anyMatch(v -> Objects.equals(value, v));
        }

        @Override
        public boolean remove(Object o) {
            Object value = o;
            return this.removeIf((Predicate)v -> Objects.equals(value, v));
        }

        @Override
        public boolean removeIf(Predicate<? super ValueT> test) {
            Iterator baseIterator = KeyValueTableMapImpl.this.kvt.entryIterator(KeyValueTableMapImpl.this.keyFamily, 100, null).asIterator();
            ArrayList<CompletableFuture<Void>> deleteFutures = new ArrayList<CompletableFuture<Void>>();
            while (baseIterator.hasNext()) {
                List toDelete = ((IteratorItem)baseIterator.next()).getItems().stream().filter(e -> test.test((Object)e.getValue())).map(TableEntry::getKey).collect(Collectors.toList());
                if (toDelete.size() <= 0) continue;
                deleteFutures.add(KeyValueTableMapImpl.this.kvt.removeAll(KeyValueTableMapImpl.this.keyFamily, toDelete));
            }
            if (deleteFutures.size() > 0) {
                Futures.allOf(deleteFutures).join();
                return true;
            }
            return false;
        }

        @Override
        public boolean removeAll(Collection<?> collection) {
            Set<Object> toRemove = collection instanceof Set ? (Set<Object>)collection : new HashSet(collection);
            return this.removeIf((Predicate)toRemove::contains);
        }

        @Override
        public boolean containsAll(Collection<?> collection) {
            Set<Object> valuesToCheck = collection instanceof Set ? (Set<Object>)collection : new HashSet(collection);
            HashSet existingValues = new HashSet();
            Iterator baseIterator = KeyValueTableMapImpl.this.kvt.entryIterator(KeyValueTableMapImpl.this.keyFamily, 100, null).asIterator();
            while (existingValues.size() < valuesToCheck.size() && baseIterator.hasNext()) {
                ((IteratorItem)baseIterator.next()).getItems().stream().filter(e -> valuesToCheck.contains(e.getValue())).forEach(existingValues::add);
            }
            return existingValues.size() >= valuesToCheck.size();
        }

        @Override
        public Stream<ValueT> stream() {
            return KeyValueTableMapImpl.this.entryStream().map(TableEntry::getValue);
        }
    }

    private class KeySetImpl
    extends BaseCollection<KeyT>
    implements Set<KeyT> {
        private KeySetImpl() {
        }

        @Override
        public boolean contains(Object key) {
            return KeyValueTableMapImpl.this.containsKey(key);
        }

        @Override
        public boolean remove(Object key) {
            return KeyValueTableMapImpl.this.remove(key) != null;
        }

        @Override
        public boolean containsAll(Collection<?> keyCollection) {
            List keys = this.toKeys(keyCollection, (Function)Functions.identity());
            List existingEntries = KeyValueTableMapImpl.this.kvt.getAll(KeyValueTableMapImpl.this.keyFamily, keys).join();
            return existingEntries.stream().allMatch(Objects::nonNull);
        }

        @Override
        public boolean removeAll(Collection<?> keyCollection) {
            List keys = this.toKeys(keyCollection, TableKey::unversioned);
            KeyValueTableMapImpl.this.kvt.removeAll(KeyValueTableMapImpl.this.keyFamily, keys).join();
            return true;
        }

        @Override
        public boolean removeIf(Predicate<? super KeyT> filter) {
            return KeyValueTableMapImpl.this.clear(filter);
        }

        @Override
        public Stream<KeyT> stream() {
            return KeyValueTableMapImpl.this.keyStream().map(TableKey::getKey);
        }

        private <T> List<T> toKeys(Collection<?> keyCollection, Function<KeyT, T> converter) {
            Object[] keyArray = new Object[keyCollection.size()];
            int index = 0;
            for (Object o : keyCollection) {
                keyArray[index++] = converter.apply(o);
            }
            return Arrays.asList(keyArray);
        }
    }

    private abstract class BaseCollection<T>
    extends AbstractCollection<T>
    implements Collection<T> {
        private BaseCollection() {
        }

        @Override
        public void clear() {
            KeyValueTableMapImpl.this.clear();
        }

        @Override
        public int size() {
            return KeyValueTableMapImpl.this.size();
        }

        @Override
        public boolean isEmpty() {
            return KeyValueTableMapImpl.this.isEmpty();
        }

        @Override
        public Iterator<T> iterator() {
            return new MapIterator<Object>(this.stream().iterator(), this::remove);
        }

        @Override
        public Spliterator<T> spliterator() {
            return this.stream().spliterator();
        }

        @Override
        public abstract Stream<T> stream();

        @Override
        public Object[] toArray() {
            return this.stream().toArray();
        }

        @Override
        public <V> V[] toArray(V[] ts) {
            throw new UnsupportedOperationException("toArray(T[])");
        }

        @Override
        public boolean retainAll(Collection<?> collection) {
            Set<Object> toKeep = collection instanceof Set ? (Set<Object>)collection : new HashSet(collection);
            return this.removeIf(item -> !toKeep.contains(item));
        }

        @Override
        public String toString() {
            return this.getClass().getName();
        }
    }
}

