/*
 * Decompiled with CFR 0.152.
 */
package io.pravega.client.tables.impl;

import com.google.common.base.Preconditions;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import io.pravega.auth.TokenExpiredException;
import io.pravega.client.connection.impl.ConnectionPool;
import io.pravega.client.connection.impl.RawClient;
import io.pravega.client.control.impl.Controller;
import io.pravega.client.security.auth.DelegationTokenProvider;
import io.pravega.client.segment.impl.Segment;
import io.pravega.client.tables.BadKeyVersionException;
import io.pravega.client.tables.IteratorItem;
import io.pravega.client.tables.IteratorState;
import io.pravega.client.tables.KeyValueTableClientConfiguration;
import io.pravega.client.tables.NoSuchKeyException;
import io.pravega.client.tables.impl.IteratorArgs;
import io.pravega.client.tables.impl.IteratorStateImpl;
import io.pravega.client.tables.impl.TableSegment;
import io.pravega.client.tables.impl.TableSegmentEntry;
import io.pravega.client.tables.impl.TableSegmentIterator;
import io.pravega.client.tables.impl.TableSegmentKey;
import io.pravega.client.tables.impl.TableSegmentKeyVersion;
import io.pravega.common.Exceptions;
import io.pravega.common.concurrent.Futures;
import io.pravega.common.concurrent.OrderedProcessor;
import io.pravega.common.tracing.TagLogger;
import io.pravega.common.util.AsyncIterator;
import io.pravega.common.util.Retry;
import io.pravega.shared.protocol.netty.ConnectionFailedException;
import io.pravega.shared.protocol.netty.PravegaNodeUri;
import io.pravega.shared.protocol.netty.Reply;
import io.pravega.shared.protocol.netty.Request;
import io.pravega.shared.protocol.netty.WireCommand;
import io.pravega.shared.protocol.netty.WireCommands;
import java.beans.ConstructorProperties;
import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.Executor;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.BiFunction;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.annotation.concurrent.GuardedBy;
import javax.annotation.concurrent.ThreadSafe;
import lombok.Generated;
import lombok.NonNull;
import org.slf4j.LoggerFactory;

class TableSegmentImpl
implements TableSegment {
    private static final int MAX_GET_KEY_BATCH_SIZE = 15;
    private static final int MAX_GET_CONCURRENT_REQUESTS = 5;
    private static final TagLogger log = new TagLogger(LoggerFactory.getLogger(TableSegmentImpl.class));
    private final String segmentName;
    private final long segmentId;
    private final Controller controller;
    private final ConnectionPool connectionPool;
    private final DelegationTokenProvider tokenProvider;
    private final Retry.RetryAndThrowConditionally retry;
    private final AtomicBoolean closed = new AtomicBoolean();
    @GuardedBy(value="stateLock")
    private CompletableFuture<ConnectionState> state;
    private final Object stateLock = new Object();

    TableSegmentImpl(@NonNull Segment segment, @NonNull Controller controller, @NonNull ConnectionPool connectionPool, @NonNull KeyValueTableClientConfiguration clientConfig, DelegationTokenProvider tokenProvider) {
        if (segment == null) {
            throw new NullPointerException("segment is marked non-null but is null");
        }
        if (controller == null) {
            throw new NullPointerException("controller is marked non-null but is null");
        }
        if (connectionPool == null) {
            throw new NullPointerException("connectionPool is marked non-null but is null");
        }
        if (clientConfig == null) {
            throw new NullPointerException("clientConfig is marked non-null but is null");
        }
        this.segmentName = segment.getKVTScopedName();
        this.segmentId = segment.getSegmentId();
        this.controller = controller;
        this.connectionPool = connectionPool;
        this.tokenProvider = tokenProvider;
        this.retry = Retry.withExpBackoff((long)clientConfig.getInitialBackoffMillis(), (int)clientConfig.getBackoffMultiple(), (int)clientConfig.getRetryAttempts(), (long)clientConfig.getMaxBackoffMillis()).retryWhen(TableSegmentImpl::isRetryableException);
    }

    @Override
    public void close() {
        if (this.closed.compareAndSet(false, true)) {
            this.resetState();
            log.info("{}: Closed.", (Object)this.segmentName);
        }
    }

    @Override
    public CompletableFuture<List<TableSegmentKeyVersion>> put(@NonNull Iterator<TableSegmentEntry> tableEntries) {
        if (tableEntries == null) {
            throw new NullPointerException("tableEntries is marked non-null but is null");
        }
        WireCommands.TableEntries wireEntries = this.entriesToWireCommand(tableEntries);
        return this.execute((state, requestId) -> {
            WireCommands.UpdateTableEntries request = new WireCommands.UpdateTableEntries(requestId.longValue(), this.segmentName, state.getToken(), wireEntries, Long.MIN_VALUE);
            return this.sendRequest((Request & WireCommand)request, (ConnectionState)state, (Class)WireCommands.TableEntriesUpdated.class).thenApply(this::fromWireCommand);
        });
    }

    @Override
    public CompletableFuture<Void> remove(@NonNull Iterator<TableSegmentKey> tableKeys) {
        if (tableKeys == null) {
            throw new NullPointerException("tableKeys is marked non-null but is null");
        }
        List<WireCommands.TableKey> wireKeys = this.keysToWireCommand(tableKeys);
        return this.execute((state, requestId) -> {
            WireCommands.RemoveTableKeys request = new WireCommands.RemoveTableKeys(requestId.longValue(), this.segmentName, state.getToken(), wireKeys, Long.MIN_VALUE);
            return Futures.toVoid(this.sendRequest((Request & WireCommand)request, (ConnectionState)state, (Class)WireCommands.TableKeysRemoved.class));
        });
    }

    @Override
    public CompletableFuture<List<TableSegmentEntry>> get(@NonNull Iterator<ByteBuf> keys) {
        CompletableFuture result;
        if (keys == null) {
            throw new NullPointerException("keys is marked non-null but is null");
        }
        List<WireCommands.TableKey> wireKeys = this.rawKeysToWireCommand(keys);
        GetResultBuilder resultBuilder = new GetResultBuilder(wireKeys);
        if (wireKeys.size() <= 15) {
            result = this.fetchSlice(resultBuilder);
        } else {
            int sliceLength;
            OrderedProcessor processor = new OrderedProcessor(5, (Executor)this.connectionPool.getInternalExecutor());
            ArrayList<CompletableFuture> futures = new ArrayList<CompletableFuture>();
            for (int index = 0; index < wireKeys.size(); index += sliceLength) {
                int sliceStart = index;
                sliceLength = Math.min(15, wireKeys.size() - sliceStart);
                futures.add(processor.execute(() -> this.fetchSlice(resultBuilder.slice(sliceStart, sliceStart + sliceLength))));
            }
            result = Futures.allOf(futures);
            result.thenRun(() -> ((OrderedProcessor)processor).close());
        }
        return result.thenApply(v -> resultBuilder.get());
    }

    private CompletableFuture<Void> fetchSlice(GetResultBuilder resultBuilder) {
        return this.execute((state, requestId) -> {
            WireCommands.ReadTable request = new WireCommands.ReadTable(requestId.longValue(), this.segmentName, state.getToken(), resultBuilder.getWireKeys());
            return this.sendRequest((Request & WireCommand)request, (ConnectionState)state, (Class)WireCommands.TableRead.class).thenAccept(reply -> this.fromWireCommand(reply.getEntries(), resultBuilder::add));
        });
    }

    @Override
    public AsyncIterator<IteratorItem<TableSegmentKey>> keyIterator(@NonNull IteratorArgs args) {
        if (args == null) {
            throw new NullPointerException("args is marked non-null but is null");
        }
        return new TableSegmentIterator(s -> this.fetchIteratorItems(args, (IteratorState)s, WireCommands.ReadTableKeys::new, (Class)WireCommands.TableKeysRead.class, WireCommands.TableKeysRead::getContinuationToken, this::fromWireCommand), args.getState()).asSequential(this.connectionPool.getInternalExecutor());
    }

    @Override
    public AsyncIterator<IteratorItem<TableSegmentEntry>> entryIterator(@NonNull IteratorArgs args) {
        if (args == null) {
            throw new NullPointerException("args is marked non-null but is null");
        }
        return new TableSegmentIterator(s -> this.fetchIteratorItems(args, (IteratorState)s, WireCommands.ReadTableEntries::new, (Class)WireCommands.TableEntriesRead.class, WireCommands.TableEntriesRead::getContinuationToken, reply -> this.fromWireCommand(reply.getEntries())), args.getState()).asSequential(this.connectionPool.getInternalExecutor());
    }

    private <ItemT, RequestT extends Request & WireCommand, ReplyT extends Reply & WireCommand> CompletableFuture<IteratorItem<ItemT>> fetchIteratorItems(IteratorArgs args, IteratorState iteratorState, CreateIteratorRequest<RequestT> newIteratorRequest, Class<ReplyT> replyClass, Function<ReplyT, ByteBuf> getStateToken, Function<ReplyT, List<ItemT>> getResult) {
        IteratorState token = iteratorState == null ? IteratorStateImpl.EMPTY : iteratorState;
        ByteBuf prefixFilter = args.getKeyPrefixFilter() == null ? Unpooled.EMPTY_BUFFER : args.getKeyPrefixFilter();
        return this.execute((state, requestId) -> {
            Object request = newIteratorRequest.apply((long)requestId, this.segmentName, state.getToken(), args.getMaxItemsAtOnce(), IteratorStateImpl.copyOf(token).getToken(), prefixFilter);
            return this.sendRequest((Request & WireCommand)request, (ConnectionState)state, replyClass).thenApply(reply -> {
                IteratorStateImpl newState = IteratorStateImpl.fromBytes((ByteBuf)getStateToken.apply(reply));
                if (newState.isEmpty()) {
                    log.debug(requestId.longValue(), "{}: Reached the end of the {} iterator.", new Object[]{this.segmentName, replyClass.getSimpleName()});
                    return null;
                }
                List keys = (List)getResult.apply(reply);
                return new IteratorItem(newState, keys);
            });
        });
    }

    private <RequestT extends Request & WireCommand, ReplyT extends Reply & WireCommand> CompletableFuture<ReplyT> sendRequest(RequestT request, ConnectionState state, Class<ReplyT> replyClass) {
        return state.getConnection().sendRequest(request.getRequestId(), request).thenApply(reply -> this.handleReply(request, (Reply)reply, replyClass));
    }

    private <RequestT extends Request & WireCommand, ReplyT extends Reply & WireCommand> ReplyT handleReply(RequestT request, Reply reply, Class<ReplyT> expectedReplyType) {
        log.debug(request.getRequestId(), "{}: Received response. RequestType={} Reply={}.", new Object[]{this.segmentName, ((WireCommand)request).getType(), reply.getClass().getSimpleName()});
        if (reply.getClass().equals(expectedReplyType)) {
            return (ReplyT)reply;
        }
        if (reply instanceof WireCommands.TableKeyDoesNotExist) {
            throw new NoSuchKeyException(this.segmentName);
        }
        if (reply instanceof WireCommands.TableKeyBadVersion) {
            throw new BadKeyVersionException(this.segmentName);
        }
        log.error(request.getRequestId(), "{}: Unexpected reply. Resetting connection. Request={}, Reply={}.", new Object[]{this.segmentName, request, reply});
        this.resetState();
        throw new ConnectionFailedException(String.format("Unexpected reply of %s when expecting %s.", reply, expectedReplyType));
    }

    private List<WireCommands.TableKey> rawKeysToWireCommand(Iterator<ByteBuf> keys) {
        ArrayList<WireCommands.TableKey> result = new ArrayList<WireCommands.TableKey>();
        AtomicInteger serializationLength = new AtomicInteger();
        keys.forEachRemaining(key -> {
            WireCommands.TableKey k = this.toWireCommand(TableSegmentKey.unversioned(key));
            serializationLength.addAndGet(k.size());
            result.add(k);
        });
        this.checkBatchSize(result.size(), serializationLength.get());
        return result;
    }

    private List<WireCommands.TableKey> keysToWireCommand(Iterator<TableSegmentKey> keys) {
        ArrayList<WireCommands.TableKey> result = new ArrayList<WireCommands.TableKey>();
        AtomicInteger serializationLength = new AtomicInteger();
        keys.forEachRemaining(k -> {
            WireCommands.TableKey key = this.toWireCommand((TableSegmentKey)k);
            serializationLength.addAndGet(key.size());
            result.add(key);
        });
        this.checkBatchSize(result.size(), serializationLength.get());
        return result;
    }

    private WireCommands.TableEntries entriesToWireCommand(Iterator<TableSegmentEntry> tableEntries) {
        ArrayList result = new ArrayList();
        AtomicInteger serializationLength = new AtomicInteger();
        tableEntries.forEachRemaining(entry -> {
            WireCommands.TableKey key = this.toWireCommand(entry.getKey());
            WireCommands.TableValue value = this.toWireCommand(entry.getValue());
            serializationLength.addAndGet(key.size() + value.size());
            result.add(new AbstractMap.SimpleImmutableEntry<WireCommands.TableKey, WireCommands.TableValue>(key, value));
        });
        this.checkBatchSize(result.size(), serializationLength.get());
        return new WireCommands.TableEntries(result);
    }

    private WireCommands.TableKey toWireCommand(TableSegmentKey k) {
        Preconditions.checkArgument((k.getKey().readableBytes() <= 8192 ? 1 : 0) != 0, (String)"Key Length too long. Must be less than %s; given %s.", (int)8192, (int)k.getKey().readableBytes());
        if (k.getVersion() == null || k.getVersion().equals(TableSegmentKeyVersion.NO_VERSION)) {
            return new WireCommands.TableKey(k.getKey(), Long.MIN_VALUE);
        }
        return new WireCommands.TableKey(k.getKey(), k.getVersion().getSegmentVersion());
    }

    private WireCommands.TableValue toWireCommand(ByteBuf value) {
        Preconditions.checkArgument((value.readableBytes() <= 1040384 ? 1 : 0) != 0, (String)"Value Length too long. Must be less than %s; given %s.", (int)1040384, (int)value.readableBytes());
        return new WireCommands.TableValue(value);
    }

    private TableSegmentKey fromWireCommand(WireCommands.TableKey k) {
        if (k.getKeyVersion() == -1L) {
            return TableSegmentKey.notExists(k.getData());
        }
        return TableSegmentKey.versioned(k.getData(), k.getKeyVersion());
    }

    private TableSegmentEntry fromWireCommand(Map.Entry<WireCommands.TableKey, WireCommands.TableValue> e) {
        TableSegmentKey key = this.fromWireCommand(e.getKey());
        if (key.exists()) {
            return new TableSegmentEntry(key, e.getValue().getData());
        }
        key.getKey().release();
        return null;
    }

    private List<TableSegmentKeyVersion> fromWireCommand(WireCommands.TableEntriesUpdated reply) {
        return reply.getUpdatedVersions().stream().map(TableSegmentKeyVersion::from).collect(Collectors.toList());
    }

    private List<TableSegmentKey> fromWireCommand(WireCommands.TableKeysRead reply) {
        return reply.getKeys().stream().map(this::fromWireCommand).collect(Collectors.toList());
    }

    private List<TableSegmentEntry> fromWireCommand(WireCommands.TableEntries reply) {
        ArrayList<TableSegmentEntry> result = new ArrayList<TableSegmentEntry>(reply.getEntries().size());
        this.fromWireCommand(reply, result::add);
        return result;
    }

    private void fromWireCommand(WireCommands.TableEntries reply, Consumer<TableSegmentEntry> callback) {
        for (Map.Entry e : reply.getEntries()) {
            callback.accept(this.fromWireCommand(e));
        }
    }

    private <T> CompletableFuture<T> execute(BiFunction<ConnectionState, Long, CompletableFuture<T>> action) {
        return this.retry.runAsync(() -> this.getOrCreateState().thenCompose(state -> (CompletionStage)action.apply((ConnectionState)state, state.nextRequestId())), this.connectionPool.getInternalExecutor());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private CompletableFuture<ConnectionState> getOrCreateState() {
        CompletableFuture<ConnectionState> result;
        Exceptions.checkNotClosed((boolean)this.closed.get(), (Object)this);
        boolean needsInitialization = false;
        Object object = this.stateLock;
        synchronized (object) {
            if (this.state == null || this.state.isCompletedExceptionally() || this.state.isDone() && this.state.join().getConnection().isClosed()) {
                this.state = new CompletableFuture();
                needsInitialization = true;
            }
            result = this.state;
        }
        if (needsInitialization) {
            Futures.completeAfter(() -> this.controller.getEndpointForSegment(this.segmentName).thenCompose(uri -> this.tokenProvider.retrieveToken().thenApply(token -> new ConnectionState(new RawClient((PravegaNodeUri)uri, this.connectionPool), (String)token))), result);
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void resetState() {
        CompletableFuture<ConnectionState> state;
        Object object = this.stateLock;
        synchronized (object) {
            state = this.state;
            this.state = null;
        }
        if (state != null && !state.isCompletedExceptionally()) {
            state.thenAccept(ConnectionState::close);
        }
    }

    private static boolean isRetryableException(Throwable ex) {
        return (ex = Exceptions.unwrap((Throwable)ex)) instanceof TokenExpiredException || ex instanceof ConnectionFailedException;
    }

    private void checkBatchSize(int count, int serializationLength) {
        Preconditions.checkArgument((count <= 256 ? 1 : 0) != 0, (String)"Too many items. Expected at most %s, actual %s.", (int)256, (int)count);
        Preconditions.checkArgument((serializationLength <= 0xFFDFFF ? 1 : 0) != 0, (String)"Batch serialization too big. Expected at most %s, actual %s.", (int)0xFFDFFF, (int)serializationLength);
    }

    @Override
    @SuppressFBWarnings(justification="generated code")
    @Generated
    public long getSegmentId() {
        return this.segmentId;
    }

    private class ConnectionState
    implements AutoCloseable {
        private final RawClient connection;
        private final String token;

        long nextRequestId() {
            return this.connection.getFlow().getNextSequenceNumber();
        }

        @Override
        public void close() {
            try {
                this.connection.close();
            }
            catch (Exception ex) {
                log.warn("{}: Exception tearing down connection: ", (Object)TableSegmentImpl.this.segmentName, (Object)ex);
            }
        }

        @ConstructorProperties(value={"connection", "token"})
        @SuppressFBWarnings(justification="generated code")
        @Generated
        public ConnectionState(RawClient connection, String token) {
            this.connection = connection;
            this.token = token;
        }

        @SuppressFBWarnings(justification="generated code")
        @Generated
        public RawClient getConnection() {
            return this.connection;
        }

        @SuppressFBWarnings(justification="generated code")
        @Generated
        public String getToken() {
            return this.token;
        }

        @SuppressFBWarnings(justification="generated code")
        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof ConnectionState)) {
                return false;
            }
            ConnectionState other = (ConnectionState)o;
            if (!other.canEqual(this)) {
                return false;
            }
            RawClient this$connection = this.getConnection();
            RawClient other$connection = other.getConnection();
            if (this$connection == null ? other$connection != null : !this$connection.equals(other$connection)) {
                return false;
            }
            String this$token = this.getToken();
            String other$token = other.getToken();
            return !(this$token == null ? other$token != null : !this$token.equals(other$token));
        }

        @SuppressFBWarnings(justification="generated code")
        @Generated
        protected boolean canEqual(Object other) {
            return other instanceof ConnectionState;
        }

        @SuppressFBWarnings(justification="generated code")
        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            RawClient $connection = this.getConnection();
            result = result * 59 + ($connection == null ? 43 : $connection.hashCode());
            String $token = this.getToken();
            result = result * 59 + ($token == null ? 43 : $token.hashCode());
            return result;
        }

        @SuppressFBWarnings(justification="generated code")
        @Generated
        public String toString() {
            return "TableSegmentImpl.ConnectionState(connection=" + this.getConnection() + ", token=" + this.getToken() + ")";
        }
    }

    @ThreadSafe
    private static class GetResultBuilder {
        private final List<WireCommands.TableKey> wireKeys;
        @GuardedBy(value="entries")
        private final TableSegmentEntry[] entries;
        private final int startIndex;
        private final int endIndex;
        @GuardedBy(value="entries")
        private int index;

        GetResultBuilder(List<WireCommands.TableKey> wireKeys) {
            this(wireKeys, new TableSegmentEntry[wireKeys.size()], 0, wireKeys.size());
        }

        private GetResultBuilder(List<WireCommands.TableKey> wireKeys, TableSegmentEntry[] entries, int startIndex, int endIndex) {
            Preconditions.checkArgument((startIndex >= 0 && startIndex < endIndex && endIndex <= entries.length ? 1 : 0) != 0);
            this.wireKeys = wireKeys;
            this.entries = entries;
            this.startIndex = startIndex;
            this.index = startIndex;
            this.endIndex = endIndex;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        GetResultBuilder slice(int startIndex, int endIndex) {
            TableSegmentEntry[] tableSegmentEntryArray = this.entries;
            synchronized (this.entries) {
                Preconditions.checkArgument((this.startIndex == 0 && this.endIndex == this.entries.length ? 1 : 0) != 0);
                // ** MonitorExit[var3_3] (shouldn't be in output)
                return new GetResultBuilder(this.wireKeys.subList(startIndex, endIndex), this.entries, startIndex, endIndex);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void add(TableSegmentEntry e) {
            TableSegmentEntry[] tableSegmentEntryArray = this.entries;
            synchronized (this.entries) {
                Preconditions.checkElementIndex((int)this.index, (int)this.endIndex);
                this.entries[this.index++] = e;
                // ** MonitorExit[var2_2] (shouldn't be in output)
                return;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        List<TableSegmentEntry> get() {
            TableSegmentEntry[] tableSegmentEntryArray = this.entries;
            synchronized (this.entries) {
                // ** MonitorExit[var1_1] (shouldn't be in output)
                return Arrays.asList(this.entries);
            }
        }

        @SuppressFBWarnings(justification="generated code")
        @Generated
        public List<WireCommands.TableKey> getWireKeys() {
            return this.wireKeys;
        }
    }

    @FunctionalInterface
    private static interface CreateIteratorRequest<V extends Request & WireCommand> {
        public V apply(long var1, String var3, String var4, int var5, ByteBuf var6, ByteBuf var7);
    }
}

