/*
 * Decompiled with CFR 0.152.
 */
package io.debezium.connector.cassandra.transforms.type.deserializer;

import io.debezium.connector.cassandra.transforms.CassandraTypeDeserializer;
import io.debezium.connector.cassandra.transforms.CassandraTypeKafkaSchemaBuilders;
import io.debezium.connector.cassandra.transforms.DebeziumTypeDeserializer;
import io.debezium.connector.cassandra.transforms.type.deserializer.LogicalTypeDeserializer;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.nio.ByteBuffer;
import org.apache.kafka.connect.data.Decimal;
import org.apache.kafka.connect.data.SchemaBuilder;

public class VarIntTypeDeserializer
extends LogicalTypeDeserializer {
    private CassandraTypeDeserializer.VarIntMode mode = CassandraTypeDeserializer.VarIntMode.LONG;

    public VarIntTypeDeserializer(DebeziumTypeDeserializer deserializer, Object abstractType) {
        super(deserializer, (Integer)14, abstractType);
    }

    @Override
    public Object deserialize(Object abstractType, ByteBuffer bb) {
        Object value = super.deserialize(abstractType, bb);
        return this.formatDeserializedValue(abstractType, value);
    }

    @Override
    public SchemaBuilder getSchemaBuilder(Object abstractType) {
        switch (this.mode) {
            case LONG: {
                return CassandraTypeKafkaSchemaBuilders.LONG_TYPE;
            }
            case PRECISE: {
                return Decimal.builder((int)0);
            }
            case STRING: {
                return CassandraTypeKafkaSchemaBuilders.STRING_TYPE;
            }
        }
        throw new IllegalArgumentException("Unknown varIntHandlingMode");
    }

    @Override
    public Object formatDeserializedValue(Object abstractType, Object value) {
        BigInteger bigint = (BigInteger)value;
        switch (this.mode) {
            case LONG: {
                return bigint.longValue();
            }
            case PRECISE: {
                return new BigDecimal(bigint);
            }
            case STRING: {
                return bigint.toString();
            }
        }
        throw new IllegalArgumentException("Unknown varIntHandlingMode");
    }

    public void setMode(CassandraTypeDeserializer.VarIntMode mode) {
        this.mode = mode;
    }
}

