/*
 * Decompiled with CFR 0.152.
 */
package io.debezium.connector.vitess;

import io.debezium.annotation.NotThreadSafe;
import io.debezium.config.CommonConnectorConfig;
import io.debezium.connector.common.BaseSourceInfo;
import io.debezium.connector.vitess.Vgtid;
import io.debezium.connector.vitess.VitessConnectorConfig;
import io.debezium.relational.TableId;
import java.time.Instant;

@NotThreadSafe
public class SourceInfo
extends BaseSourceInfo {
    public static final String VGTID_KEY = "vgtid";
    public static final String KEYSPACE_NAME_KEY = "keyspace";
    private final String keyspace;
    private Vgtid currentVgtid;
    private TableId tableId;
    private Instant timestamp;
    private Vgtid restartVgtid;

    public SourceInfo(VitessConnectorConfig config) {
        super((CommonConnectorConfig)config);
        this.keyspace = config.getKeyspace();
    }

    protected Instant timestamp() {
        return this.timestamp;
    }

    protected String database() {
        return null;
    }

    protected String keyspace() {
        return this.keyspace;
    }

    public TableId getTableId() {
        return this.tableId;
    }

    public void setTableId(TableId tableId) {
        this.tableId = tableId;
    }

    public void setTimestamp(Instant timestamp) {
        this.timestamp = timestamp;
    }

    public Vgtid getCurrentVgtid() {
        return this.currentVgtid;
    }

    public Vgtid getRestartVgtid() {
        return this.restartVgtid;
    }

    public void resetVgtid(Vgtid vgtid, Instant commitTime) {
        this.restartVgtid = vgtid;
        this.currentVgtid = vgtid;
        this.timestamp = commitTime;
    }

    public void rotateVgtid(Vgtid newVgtid, Instant commitTime) {
        if (!this.currentVgtid.equals(newVgtid)) {
            this.restartVgtid = this.currentVgtid;
            if (newVgtid != null) {
                this.currentVgtid = newVgtid;
            }
            this.timestamp = commitTime;
        }
    }

    public String toString() {
        return "SourceInfo{tableId=" + this.tableId + ", timestamp=" + this.timestamp + ", currentVgtid=" + this.currentVgtid + ", restartVgtid=" + this.restartVgtid + "}";
    }
}

