/*
 * Decompiled with CFR 0.152.
 */
package io.debezium.connector.vitess;

import io.debezium.connector.SnapshotRecord;
import io.debezium.connector.common.BaseSourceInfo;
import io.debezium.connector.vitess.SourceInfo;
import io.debezium.connector.vitess.Vgtid;
import io.debezium.connector.vitess.VitessConnectorConfig;
import io.debezium.connector.vitess.connection.VitessReplicationConnection;
import io.debezium.pipeline.CommonOffsetContext;
import io.debezium.pipeline.spi.OffsetContext;
import io.debezium.pipeline.txmetadata.TransactionContext;
import io.debezium.relational.TableId;
import io.debezium.spi.schema.DataCollectionId;
import io.debezium.util.Clock;
import java.time.Instant;
import java.util.HashMap;
import java.util.Map;
import org.apache.kafka.connect.data.Schema;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class VitessOffsetContext
extends CommonOffsetContext<SourceInfo> {
    private static final Logger LOGGER = LoggerFactory.getLogger(VitessOffsetContext.class);
    private final Schema sourceInfoSchema;
    private final TransactionContext transactionContext;

    public VitessOffsetContext(VitessConnectorConfig connectorConfig, Vgtid initialVgtid, Instant time, TransactionContext transactionContext) {
        super((BaseSourceInfo)new SourceInfo(connectorConfig));
        ((SourceInfo)this.sourceInfo).resetVgtid(initialVgtid, time);
        this.sourceInfoSchema = ((SourceInfo)this.sourceInfo).schema();
        this.transactionContext = transactionContext;
    }

    public static VitessOffsetContext initialContext(VitessConnectorConfig connectorConfig, Clock clock) {
        LOGGER.info("No previous offset exists. Use default VGTID.");
        Vgtid defaultVgtid = VitessReplicationConnection.defaultVgtid(connectorConfig);
        return new VitessOffsetContext(connectorConfig, defaultVgtid, clock.currentTimeAsInstant(), new TransactionContext());
    }

    public void rotateVgtid(Vgtid newVgtid, Instant commitTime) {
        ((SourceInfo)this.sourceInfo).rotateVgtid(newVgtid, commitTime);
    }

    public void resetVgtid(Vgtid newVgtid, Instant commitTime) {
        ((SourceInfo)this.sourceInfo).resetVgtid(newVgtid, commitTime);
    }

    public Vgtid getRestartVgtid() {
        return ((SourceInfo)this.sourceInfo).getRestartVgtid();
    }

    public Map<String, ?> getOffset() {
        HashMap<String, String> result = new HashMap<String, String>();
        if (((SourceInfo)this.sourceInfo).getRestartVgtid() != null) {
            result.put("vgtid", ((SourceInfo)this.sourceInfo).getRestartVgtid().toString());
        }
        return this.transactionContext.store(result);
    }

    public Schema getSourceInfoSchema() {
        return this.sourceInfoSchema;
    }

    public boolean isSnapshotRunning() {
        return false;
    }

    public void markSnapshotRecord(SnapshotRecord record) {
    }

    public void preSnapshotStart() {
    }

    public void preSnapshotCompletion() {
    }

    public void postSnapshotCompletion() {
    }

    public void event(DataCollectionId collectionId, Instant timestamp) {
        ((SourceInfo)this.sourceInfo).setTimestamp(timestamp);
        ((SourceInfo)this.sourceInfo).setTableId((TableId)collectionId);
    }

    public TransactionContext getTransactionContext() {
        return this.transactionContext;
    }

    public String toString() {
        return "VitessOffsetContext{sourceInfo=" + this.sourceInfo + "}";
    }

    public static class Loader
    implements OffsetContext.Loader<VitessOffsetContext> {
        private final VitessConnectorConfig connectorConfig;

        public Loader(VitessConnectorConfig connectorConfig) {
            this.connectorConfig = connectorConfig;
        }

        public VitessOffsetContext load(Map<String, ?> offset) {
            String vgtid = (String)offset.get("vgtid");
            return new VitessOffsetContext(this.connectorConfig, Vgtid.of(vgtid), null, TransactionContext.load(offset));
        }
    }
}

