/*
 * Decompiled with CFR 0.152.
 */
package io.debezium.connector.vitess;

import io.debezium.connector.vitess.VitessConnectorConfig;
import io.debezium.pipeline.spi.Partition;
import io.debezium.util.Collect;
import java.util.Collections;
import java.util.Map;
import java.util.Objects;
import java.util.Set;

public class VitessPartition
implements Partition {
    protected static final String SERVER_PARTITION_KEY = "server";
    protected static final String TASK_KEY_PARTITION_KEY = "task_key";
    private final String serverName;
    private final String taskKeyName;

    public VitessPartition(String serverName, String taskKeyName) {
        this.serverName = serverName;
        this.taskKeyName = taskKeyName;
    }

    public Map<String, String> getSourcePartition() {
        if (this.taskKeyName != null) {
            return Collect.hashMapOf((Object)SERVER_PARTITION_KEY, (Object)this.serverName, (Object)TASK_KEY_PARTITION_KEY, (Object)this.taskKeyName);
        }
        return Collect.hashMapOf((Object)SERVER_PARTITION_KEY, (Object)this.serverName);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        VitessPartition other = (VitessPartition)obj;
        return Objects.equals(this.serverName, other.serverName) && Objects.equals(this.taskKeyName, other.taskKeyName);
    }

    public int hashCode() {
        return this.serverName.hashCode() ^ (this.taskKeyName != null ? this.taskKeyName.hashCode() : 0);
    }

    public String toString() {
        return "VitessPartition [sourcePartition=" + this.getSourcePartition() + "]";
    }

    static class Provider
    implements Partition.Provider<VitessPartition> {
        private final VitessConnectorConfig connectorConfig;

        Provider(VitessConnectorConfig connectorConfig) {
            this.connectorConfig = connectorConfig;
        }

        public Set<VitessPartition> getPartitions() {
            if (this.connectorConfig.offsetStoragePerTask()) {
                String taskKey = this.connectorConfig.getVitessTaskKey();
                if (taskKey == null) {
                    throw new RuntimeException("No vitess.task.key in: " + this.connectorConfig.getConfig());
                }
                return Collections.singleton(new VitessPartition(this.connectorConfig.getLogicalName(), taskKey));
            }
            return Collections.singleton(new VitessPartition(this.connectorConfig.getLogicalName(), null));
        }
    }
}

