/*
 * Decompiled with CFR 0.152.
 */
package io.debezium.connector.vitess.connection;

import io.debezium.connector.vitess.VitessType;
import java.time.Instant;
import java.util.List;

public interface ReplicationMessage {
    public Operation getOperation();

    public Instant getCommitTime();

    public String getTransactionId();

    public String getTable();

    public List<Column> getOldTupleList();

    public List<Column> getNewTupleList();

    default public boolean isTransactionalMessage() {
        return this.getOperation() == Operation.BEGIN || this.getOperation() == Operation.COMMIT;
    }

    public static enum Operation {
        INSERT,
        UPDATE,
        DELETE,
        BEGIN,
        COMMIT,
        DDL,
        OTHER;

    }

    public static interface ColumnValue<T> {
        public T getRawValue();

        public boolean isNull();

        public byte[] asBytes();

        public String asString();

        public Integer asInteger();

        public Short asShort();

        public Long asLong();

        public Float asFloat();

        public Double asDouble();

        public Object asDefault(VitessType var1, boolean var2);
    }

    public static interface Column {
        public String getName();

        public VitessType getType();

        public Object getValue(boolean var1);

        public boolean isOptional();
    }
}

