/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.spanner;

import com.google.cloud.spanner.InstanceAdminClient;
import com.google.cloud.spanner.InstanceConfigId;
import com.google.cloud.spanner.InstanceConfigInfo;
import com.google.cloud.spanner.ReplicaInfo;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;

public class InstanceConfig
extends InstanceConfigInfo {
    private final InstanceAdminClient client;

    public InstanceConfig(InstanceConfigId id, String displayName, InstanceAdminClient client) {
        this(id, displayName, Collections.emptyList(), Collections.emptyList(), client);
    }

    public InstanceConfig(InstanceConfigId id, String displayName, List<ReplicaInfo> replicas, List<String> leaderOptions, InstanceAdminClient client) {
        super(id, displayName, replicas, leaderOptions);
        this.client = client;
    }

    public InstanceConfig reload() {
        return this.client.getInstanceConfig(this.getId().getInstanceConfig());
    }

    static InstanceConfig fromProto(com.google.spanner.admin.instance.v1.InstanceConfig proto, InstanceAdminClient client) {
        return new InstanceConfig(InstanceConfigId.of(proto.getName()), proto.getDisplayName(), proto.getReplicasList().stream().map(ReplicaInfo::fromProto).collect(Collectors.toList()), (List<String>)proto.getLeaderOptionsList(), client);
    }
}

