/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.spanner.spi.v1;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.ImmutableList;
import io.opencensus.stats.Aggregation;
import io.opencensus.stats.BucketBoundaries;
import io.opencensus.stats.Measure;
import io.opencensus.stats.Stats;
import io.opencensus.stats.View;
import io.opencensus.stats.ViewManager;
import io.opencensus.tags.TagKey;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;

@VisibleForTesting
public class SpannerRpcViews {
    private static final String MILLISECOND = "ms";
    private static final String COUNT = "1";
    public static final TagKey METHOD = TagKey.create((String)"method");
    public static final TagKey PROJECT_ID = TagKey.create((String)"project_id");
    public static final TagKey INSTANCE_ID = TagKey.create((String)"instance_id");
    public static final TagKey DATABASE_ID = TagKey.create((String)"database");
    public static final Measure.MeasureLong SPANNER_GFE_LATENCY = Measure.MeasureLong.create((String)"cloud.google.com/java/spanner/gfe_latency", (String)"Latency between Google's network receiving an RPC and reading back the first byte of the response", (String)"ms");
    public static final Measure.MeasureLong SPANNER_GFE_HEADER_MISSING_COUNT = Measure.MeasureLong.create((String)"cloud.google.com/java/spanner/gfe_header_missing_count", (String)"Number of RPC responses received without the server-timing header, most likely means that the RPC never reached Google's network", (String)"1");
    static final List<Double> RPC_MILLIS_BUCKET_BOUNDARIES = Collections.unmodifiableList(Arrays.asList(0.0, 0.01, 0.05, 0.1, 0.3, 0.6, 0.8, 1.0, 2.0, 3.0, 4.0, 5.0, 6.0, 8.0, 10.0, 13.0, 16.0, 20.0, 25.0, 30.0, 40.0, 50.0, 65.0, 80.0, 100.0, 130.0, 160.0, 200.0, 250.0, 300.0, 400.0, 500.0, 650.0, 800.0, 1000.0, 2000.0, 5000.0, 10000.0, 20000.0, 50000.0, 100000.0));
    static final Aggregation AGGREGATION_WITH_MILLIS_HISTOGRAM = Aggregation.Distribution.create((BucketBoundaries)BucketBoundaries.create(RPC_MILLIS_BUCKET_BOUNDARIES));
    static final View SPANNER_GFE_LATENCY_VIEW = View.create((View.Name)View.Name.create((String)"cloud.google.com/java/spanner/gfe_latency"), (String)"Latency between Google's network receiving an RPC and reading back the first byte of the response", (Measure)SPANNER_GFE_LATENCY, (Aggregation)AGGREGATION_WITH_MILLIS_HISTOGRAM, (List)ImmutableList.of((Object)METHOD, (Object)PROJECT_ID, (Object)INSTANCE_ID, (Object)DATABASE_ID));
    private static final Aggregation SUM = Aggregation.Sum.create();
    static final View SPANNER_GFE_HEADER_MISSING_COUNT_VIEW = View.create((View.Name)View.Name.create((String)"cloud.google.com/java/spanner/gfe_header_missing_count"), (String)"Number of RPC responses received without the server-timing header, most likely means that the RPC never reached Google's network", (Measure)SPANNER_GFE_HEADER_MISSING_COUNT, (Aggregation)SUM, (List)ImmutableList.of((Object)METHOD, (Object)PROJECT_ID, (Object)INSTANCE_ID, (Object)DATABASE_ID));
    public static ViewManager viewManager = Stats.getViewManager();

    @VisibleForTesting
    public static void registerGfeLatencyAndHeaderMissingCountViews() {
        viewManager.registerView(SPANNER_GFE_LATENCY_VIEW);
        viewManager.registerView(SPANNER_GFE_HEADER_MISSING_COUNT_VIEW);
    }

    @VisibleForTesting
    public static void registerGfeLatencyView() {
        viewManager.registerView(SPANNER_GFE_LATENCY_VIEW);
    }

    @VisibleForTesting
    public static void registerGfeHeaderMissingCountView() {
        viewManager.registerView(SPANNER_GFE_HEADER_MISSING_COUNT_VIEW);
    }
}

