/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.pubsublite.proto;

import com.google.api.pathtemplate.PathTemplate;
import com.google.api.resourcenames.ResourceName;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;

public class TopicName
implements ResourceName {
    private static final PathTemplate PROJECT_LOCATION_TOPIC = PathTemplate.createWithoutUrlEncoding((String)"projects/{project}/locations/{location}/topics/{topic}");
    private volatile Map<String, String> fieldValuesMap;
    private final String project;
    private final String location;
    private final String topic;

    @Deprecated
    protected TopicName() {
        this.project = null;
        this.location = null;
        this.topic = null;
    }

    private TopicName(Builder builder) {
        this.project = (String)Preconditions.checkNotNull((Object)builder.getProject());
        this.location = (String)Preconditions.checkNotNull((Object)builder.getLocation());
        this.topic = (String)Preconditions.checkNotNull((Object)builder.getTopic());
    }

    public String getProject() {
        return this.project;
    }

    public String getLocation() {
        return this.location;
    }

    public String getTopic() {
        return this.topic;
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    public static TopicName of(String project, String location, String topic) {
        return TopicName.newBuilder().setProject(project).setLocation(location).setTopic(topic).build();
    }

    public static String format(String project, String location, String topic) {
        return TopicName.newBuilder().setProject(project).setLocation(location).setTopic(topic).build().toString();
    }

    public static TopicName parse(String formattedString) {
        if (formattedString.isEmpty()) {
            return null;
        }
        Map matchMap = PROJECT_LOCATION_TOPIC.validatedMatch(formattedString, "TopicName.parse: formattedString not in valid format");
        return TopicName.of((String)matchMap.get("project"), (String)matchMap.get("location"), (String)matchMap.get("topic"));
    }

    public static List<TopicName> parseList(List<String> formattedStrings) {
        ArrayList<TopicName> list = new ArrayList<TopicName>(formattedStrings.size());
        for (String formattedString : formattedStrings) {
            list.add(TopicName.parse(formattedString));
        }
        return list;
    }

    public static List<String> toStringList(List<TopicName> values) {
        ArrayList<String> list = new ArrayList<String>(values.size());
        for (TopicName value : values) {
            if (value == null) {
                list.add("");
                continue;
            }
            list.add(value.toString());
        }
        return list;
    }

    public static boolean isParsableFrom(String formattedString) {
        return PROJECT_LOCATION_TOPIC.matches(formattedString);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<String, String> getFieldValuesMap() {
        if (this.fieldValuesMap == null) {
            TopicName topicName = this;
            synchronized (topicName) {
                if (this.fieldValuesMap == null) {
                    ImmutableMap.Builder fieldMapBuilder = ImmutableMap.builder();
                    if (this.project != null) {
                        fieldMapBuilder.put((Object)"project", (Object)this.project);
                    }
                    if (this.location != null) {
                        fieldMapBuilder.put((Object)"location", (Object)this.location);
                    }
                    if (this.topic != null) {
                        fieldMapBuilder.put((Object)"topic", (Object)this.topic);
                    }
                    this.fieldValuesMap = fieldMapBuilder.build();
                }
            }
        }
        return this.fieldValuesMap;
    }

    public String getFieldValue(String fieldName) {
        return this.getFieldValuesMap().get(fieldName);
    }

    public String toString() {
        return PROJECT_LOCATION_TOPIC.instantiate(new String[]{"project", this.project, "location", this.location, "topic", this.topic});
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o != null || this.getClass() == o.getClass()) {
            TopicName that = (TopicName)o;
            return Objects.equals(this.project, that.project) && Objects.equals(this.location, that.location) && Objects.equals(this.topic, that.topic);
        }
        return false;
    }

    public int hashCode() {
        int h = 1;
        h *= 1000003;
        h ^= Objects.hashCode(this.project);
        h *= 1000003;
        h ^= Objects.hashCode(this.location);
        h *= 1000003;
        return h ^= Objects.hashCode(this.topic);
    }

    public static class Builder {
        private String project;
        private String location;
        private String topic;

        protected Builder() {
        }

        public String getProject() {
            return this.project;
        }

        public String getLocation() {
            return this.location;
        }

        public String getTopic() {
            return this.topic;
        }

        public Builder setProject(String project) {
            this.project = project;
            return this;
        }

        public Builder setLocation(String location) {
            this.location = location;
            return this;
        }

        public Builder setTopic(String topic) {
            this.topic = topic;
            return this;
        }

        private Builder(TopicName topicName) {
            this.project = topicName.project;
            this.location = topicName.location;
            this.topic = topicName.topic;
        }

        public TopicName build() {
            return new TopicName(this);
        }
    }
}

