/*
 * Decompiled with CFR 0.152.
 */
package io.apicurio.registry.utils.converter.json;

import io.apicurio.registry.resolver.strategy.ArtifactReference;
import io.apicurio.registry.serde.AbstractKafkaSerDe;
import io.apicurio.registry.serde.DefaultIdHandler;
import io.apicurio.registry.serde.IdHandler;
import io.apicurio.registry.utils.converter.json.FormatStrategy;
import java.nio.ByteBuffer;
import java.util.Objects;

public class CompactFormatStrategy
implements FormatStrategy {
    private IdHandler idHandler;

    public CompactFormatStrategy() {
        this((IdHandler)new DefaultIdHandler());
    }

    public CompactFormatStrategy(IdHandler idHandler) {
        this.setIdHandler(idHandler);
    }

    public void setIdHandler(IdHandler idHandler) {
        this.idHandler = Objects.requireNonNull(idHandler);
    }

    @Override
    public byte[] fromConnectData(long globalId, byte[] bytes) {
        ByteBuffer buffer = ByteBuffer.allocate(1 + this.idHandler.idSize() + bytes.length);
        buffer.put((byte)0);
        this.idHandler.writeId(ArtifactReference.fromGlobalId((Long)globalId), buffer);
        buffer.put(bytes);
        return buffer.array();
    }

    @Override
    public FormatStrategy.IdPayload toConnectData(byte[] bytes) {
        ByteBuffer buffer = AbstractKafkaSerDe.getByteBuffer((byte[])bytes);
        ArtifactReference reference = this.idHandler.readId(buffer);
        long globalId = reference.getGlobalId();
        byte[] payload = new byte[bytes.length - this.idHandler.idSize() - 1];
        buffer.get(payload);
        return new FormatStrategy.IdPayload(globalId, payload);
    }
}

