/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.db;

import com.google.common.base.Preconditions;
import java.nio.ByteBuffer;
import org.apache.cassandra.db.BufferClusteringBoundOrBoundary;
import org.apache.cassandra.db.ClusteringBound;
import org.apache.cassandra.db.ClusteringPrefix;
import org.apache.cassandra.utils.ObjectSizes;
import org.apache.cassandra.utils.memory.AbstractAllocator;

public class BufferClusteringBound
extends BufferClusteringBoundOrBoundary
implements ClusteringBound<ByteBuffer> {
    private static final long EMPTY_SIZE = ObjectSizes.measure(new BufferClusteringBound(ClusteringPrefix.Kind.INCL_START_BOUND, EMPTY_VALUES_ARRAY));

    public BufferClusteringBound(ClusteringPrefix.Kind kind, ByteBuffer[] values) {
        super(kind, values);
    }

    @Override
    public long unsharedHeapSize() {
        return EMPTY_SIZE + ObjectSizes.sizeOnHeapOf((ByteBuffer[])this.values);
    }

    @Override
    public ClusteringBound<ByteBuffer> invert() {
        return BufferClusteringBound.create(this.kind().invert(), (ByteBuffer[])this.values);
    }

    @Override
    public ClusteringBound<ByteBuffer> copy(AbstractAllocator allocator) {
        return (ClusteringBound)super.copy(allocator);
    }

    public static BufferClusteringBound create(ClusteringPrefix.Kind kind, ByteBuffer[] values) {
        Preconditions.checkArgument((!kind.isBoundary() ? 1 : 0) != 0, (String)"Expected bound clustering kind, got %s", (Object)((Object)kind));
        return new BufferClusteringBound(kind, values);
    }

    public static BufferClusteringBound inclusiveStartOf(ByteBuffer ... values) {
        return BufferClusteringBound.create(ClusteringPrefix.Kind.INCL_START_BOUND, values);
    }

    public static BufferClusteringBound inclusiveEndOf(ByteBuffer ... values) {
        return BufferClusteringBound.create(ClusteringPrefix.Kind.INCL_END_BOUND, values);
    }

    public static BufferClusteringBound exclusiveStartOf(ByteBuffer ... values) {
        return BufferClusteringBound.create(ClusteringPrefix.Kind.EXCL_START_BOUND, values);
    }

    public static BufferClusteringBound exclusiveEndOf(ByteBuffer ... values) {
        return BufferClusteringBound.create(ClusteringPrefix.Kind.EXCL_END_BOUND, values);
    }
}

