/*
 * Decompiled with CFR 0.152.
 */
package com.azure.core.http.rest;

import com.azure.core.exception.HttpResponseException;
import com.azure.core.http.HttpResponse;
import com.azure.core.implementation.ReflectionUtilsApi;
import com.azure.core.util.logging.ClientLogger;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodHandles;
import java.lang.reflect.Constructor;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

final class ResponseExceptionConstructorCache {
    private static final Map<Class<? extends HttpResponseException>, MethodHandle> CACHE = new ConcurrentHashMap<Class<? extends HttpResponseException>, MethodHandle>();
    private static final ClientLogger LOGGER = new ClientLogger(ResponseExceptionConstructorCache.class);

    ResponseExceptionConstructorCache() {
    }

    MethodHandle get(Class<? extends HttpResponseException> exceptionClass, Class<?> exceptionBodyType) {
        return CACHE.computeIfAbsent(exceptionClass, key -> ResponseExceptionConstructorCache.locateExceptionConstructor(key, exceptionBodyType));
    }

    private static MethodHandle locateExceptionConstructor(Class<? extends HttpResponseException> exceptionClass, Class<?> exceptionBodyType) {
        try {
            MethodHandles.Lookup lookupToUse = ReflectionUtilsApi.INSTANCE.getLookupToUse(exceptionClass);
            Constructor<? extends HttpResponseException> constructor = exceptionClass.getConstructor(String.class, HttpResponse.class, exceptionBodyType);
            return lookupToUse.unreflectConstructor(constructor);
        }
        catch (Exception ex) {
            if (ex instanceof RuntimeException) {
                throw LOGGER.logExceptionAsError((RuntimeException)ex);
            }
            throw LOGGER.logExceptionAsError(new RuntimeException(ex));
        }
    }

    static <T extends HttpResponseException> T invoke(MethodHandle handle, String exceptionMessage, HttpResponse httpResponse, Object exceptionBody) {
        try {
            return (T)((HttpResponseException)handle.invokeWithArguments(exceptionMessage, httpResponse, exceptionBody));
        }
        catch (Throwable throwable) {
            if (throwable instanceof Error) {
                throw (Error)throwable;
            }
            if (throwable instanceof RuntimeException) {
                throw LOGGER.logExceptionAsError((RuntimeException)throwable);
            }
            throw LOGGER.logExceptionAsError(new IllegalStateException(exceptionMessage, throwable));
        }
    }
}

