/*
 * Decompiled with CFR 0.152.
 */
package com.azure.core.implementation.http.rest;

import com.azure.core.exception.UnexpectedLengthException;
import com.azure.core.http.HttpRequest;
import com.azure.core.implementation.http.rest.LengthValidatingInputStream;
import com.azure.core.implementation.util.BinaryDataContent;
import com.azure.core.implementation.util.BinaryDataHelper;
import com.azure.core.implementation.util.InputStreamContent;
import com.azure.core.util.BinaryData;
import java.nio.ByteBuffer;
import org.reactivestreams.Publisher;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

public final class RestProxyUtils {
    private static final ByteBuffer VALIDATION_BUFFER = ByteBuffer.allocate(0);
    public static final String BODY_TOO_LARGE = "Request body emitted %d bytes, more than the expected %d bytes.";
    public static final String BODY_TOO_SMALL = "Request body emitted %d bytes, less than the expected %d bytes.";

    private RestProxyUtils() {
    }

    public static Mono<HttpRequest> validateLengthAsync(HttpRequest request) {
        BinaryData body = request.getBodyAsBinaryData();
        if (body == null) {
            return Mono.just((Object)request);
        }
        return Mono.fromCallable(() -> {
            Long bodyLength = body.getLength();
            long expectedLength = Long.parseLong(request.getHeaders().getValue("Content-Length"));
            if (bodyLength != null) {
                if (bodyLength < expectedLength) {
                    throw new UnexpectedLengthException(String.format(BODY_TOO_SMALL, bodyLength, expectedLength), bodyLength, expectedLength);
                }
                if (bodyLength > expectedLength) {
                    throw new UnexpectedLengthException(String.format(BODY_TOO_LARGE, bodyLength, expectedLength), bodyLength, expectedLength);
                }
            } else {
                BinaryDataContent content = BinaryDataHelper.getContent(body);
                if (content instanceof InputStreamContent) {
                    LengthValidatingInputStream validatingInputStream = new LengthValidatingInputStream(content.toStream(), expectedLength);
                    request.setBody(BinaryData.fromStream(validatingInputStream));
                } else {
                    request.setBody(RestProxyUtils.validateFluxLength(body.toFluxByteBuffer(), expectedLength));
                }
            }
            return request;
        });
    }

    private static Flux<ByteBuffer> validateFluxLength(Flux<ByteBuffer> bbFlux, long expectedLength) {
        if (bbFlux == null) {
            return Flux.empty();
        }
        return Flux.defer(() -> {
            long[] currentTotalLength = new long[1];
            return Flux.concat((Publisher[])new Publisher[]{bbFlux, Flux.just((Object)VALIDATION_BUFFER)}).handle((buffer, sink) -> {
                if (buffer == null) {
                    return;
                }
                if (buffer == VALIDATION_BUFFER) {
                    if (expectedLength != currentTotalLength[0]) {
                        sink.error((Throwable)new UnexpectedLengthException(String.format(BODY_TOO_SMALL, currentTotalLength[0], expectedLength), currentTotalLength[0], expectedLength));
                    } else {
                        sink.complete();
                    }
                    return;
                }
                currentTotalLength[0] = currentTotalLength[0] + (long)buffer.remaining();
                if (currentTotalLength[0] > expectedLength) {
                    sink.error((Throwable)new UnexpectedLengthException(String.format(BODY_TOO_LARGE, currentTotalLength[0], expectedLength), currentTotalLength[0], expectedLength));
                    return;
                }
                sink.next(buffer);
            });
        });
    }
}

