/*
 * Decompiled with CFR 0.152.
 */
package io.apicurio.rest.client.auth;

import com.fasterxml.jackson.core.JsonProcessingException;
import io.apicurio.rest.client.auth.AccessTokenResponse;
import io.apicurio.rest.client.auth.Auth;
import io.apicurio.rest.client.auth.request.TokenRequestsProvider;
import io.apicurio.rest.client.spi.ApicurioHttpClient;
import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;
import java.time.Duration;
import java.time.Instant;
import java.util.Map;
import java.util.stream.Collectors;

public class OidcAuth
implements Auth,
AutoCloseable {
    private static final String BEARER = "Bearer ";
    private static final String CLIENT_CREDENTIALS_GRANT = "client_credentials";
    private static final String PASSWORD_GRANT = "password";
    private static final Duration DEFAULT_TOKEN_EXPIRATION_REDUCTION = Duration.ofSeconds(1L);
    private final String clientId;
    private final String clientSecret;
    private final Duration tokenExpirationReduction;
    private String cachedAccessToken;
    private Instant cachedAccessTokenExp;
    private final ApicurioHttpClient apicurioHttpClient;

    public OidcAuth(ApicurioHttpClient httpClient, String clientId, String clientSecret) {
        this(httpClient, clientId, clientSecret, DEFAULT_TOKEN_EXPIRATION_REDUCTION);
    }

    public OidcAuth(ApicurioHttpClient httpClient, String clientId, String clientSecret, Duration tokenExpirationReduction) {
        this.clientId = clientId;
        this.clientSecret = clientSecret;
        this.apicurioHttpClient = httpClient;
        this.tokenExpirationReduction = null == tokenExpirationReduction ? DEFAULT_TOKEN_EXPIRATION_REDUCTION : tokenExpirationReduction;
    }

    @Override
    public void apply(Map<String, String> requestHeaders) {
        if (this.isAccessTokenRequired()) {
            this.requestAccessToken();
        }
        requestHeaders.put("Authorization", BEARER + this.cachedAccessToken);
    }

    private void requestAccessToken() {
        try {
            Map<String, String> params = Map.of("grant_type", CLIENT_CREDENTIALS_GRANT, "client_id", this.clientId, "client_secret", this.clientSecret);
            String paramsEncoded = params.entrySet().stream().map(entry -> String.join((CharSequence)"=", URLEncoder.encode((String)entry.getKey(), StandardCharsets.UTF_8), URLEncoder.encode((String)entry.getValue(), StandardCharsets.UTF_8))).collect(Collectors.joining("&"));
            AccessTokenResponse accessTokenResponse = this.apicurioHttpClient.sendRequest(TokenRequestsProvider.obtainAccessToken(paramsEncoded));
            this.cachedAccessToken = accessTokenResponse.getToken();
            Duration expiresIn = Duration.ofSeconds(accessTokenResponse.getExpiresIn());
            if (expiresIn.compareTo(this.tokenExpirationReduction) > 0) {
                expiresIn = expiresIn.minus(this.tokenExpirationReduction);
            }
            this.cachedAccessTokenExp = Instant.now().plus(expiresIn);
        }
        catch (JsonProcessingException e) {
            throw new IllegalStateException("Error found while trying to request a new token");
        }
    }

    public String authenticate() {
        if (this.isAccessTokenRequired()) {
            this.requestAccessToken();
        }
        return this.cachedAccessToken;
    }

    public String obtainAccessTokenPasswordGrant(String username, String password) {
        try {
            Map<String, String> params = Map.of("grant_type", PASSWORD_GRANT, "client_id", this.clientId, "client_secret", this.clientSecret, "username", username, PASSWORD_GRANT, password);
            String paramsEncoded = params.entrySet().stream().map(entry -> String.join((CharSequence)"=", URLEncoder.encode((String)entry.getKey(), StandardCharsets.UTF_8), URLEncoder.encode((String)entry.getValue(), StandardCharsets.UTF_8))).collect(Collectors.joining("&"));
            return this.apicurioHttpClient.sendRequest(TokenRequestsProvider.obtainAccessToken(paramsEncoded)).getToken();
        }
        catch (JsonProcessingException e) {
            throw new IllegalStateException("Error found while trying to request a new token");
        }
    }

    private boolean isAccessTokenRequired() {
        return null == this.cachedAccessToken || this.isTokenExpired();
    }

    private boolean isTokenExpired() {
        return Instant.now().isAfter(this.cachedAccessTokenExp);
    }

    @Override
    public void close() {
        this.apicurioHttpClient.close();
    }
}

