/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.pubsublite.cloudpubsub.internal;

import com.google.api.core.ApiFuture;
import com.google.api.core.ApiFutures;
import com.google.api.core.ApiService;
import com.google.api.gax.rpc.ApiException;
import com.google.cloud.pubsublite.Message;
import com.google.cloud.pubsublite.MessageMetadata;
import com.google.cloud.pubsublite.MessageTransformer;
import com.google.cloud.pubsublite.cloudpubsub.Publisher;
import com.google.cloud.pubsublite.internal.CheckedApiException;
import com.google.cloud.pubsublite.internal.ExtractStatus;
import com.google.cloud.pubsublite.internal.ProxyService;
import com.google.cloud.pubsublite.internal.wire.SystemExecutors;
import com.google.common.flogger.GoogleLogger;
import com.google.common.util.concurrent.MoreExecutors;
import com.google.pubsub.v1.PubsubMessage;
import java.util.concurrent.Executor;

public class WrappingPublisher
extends ProxyService
implements Publisher {
    private static final GoogleLogger logger = GoogleLogger.forEnclosingClass();
    private final com.google.cloud.pubsublite.internal.Publisher<MessageMetadata> wirePublisher;
    private final MessageTransformer<PubsubMessage, Message> transformer;

    public WrappingPublisher(com.google.cloud.pubsublite.internal.Publisher<MessageMetadata> wirePublisher, MessageTransformer<PubsubMessage, Message> transformer) throws ApiException {
        super(wirePublisher);
        this.wirePublisher = wirePublisher;
        this.transformer = transformer;
        this.addListener(new ApiService.Listener(){

            public void failed(ApiService.State from, Throwable failure) {
                ((GoogleLogger.Api)((GoogleLogger.Api)logger.atWarning()).withCause(failure)).log("Publisher client failed with permanent error.");
            }
        }, SystemExecutors.getFuturesExecutor());
    }

    public ApiFuture<String> publish(PubsubMessage message) {
        Message wireMessage;
        if (this.state().equals((Object)ApiService.State.FAILED)) {
            return ApiFutures.immediateFailedFuture((Throwable)ExtractStatus.toCanonical((Throwable)this.failureCause()).underlying);
        }
        try {
            wireMessage = this.transformer.transform(message);
        }
        catch (Throwable t) {
            CheckedApiException e = ExtractStatus.toCanonical(t);
            this.onPermanentError(e);
            return ApiFutures.immediateFailedFuture((Throwable)e.underlying);
        }
        return ApiFutures.transform(this.wirePublisher.publish(wireMessage), MessageMetadata::encode, (Executor)MoreExecutors.directExecutor());
    }
}

