/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.pubsublite.internal.wire;

import com.google.api.core.ApiFuture;
import com.google.api.core.ApiFutures;
import com.google.api.core.ApiService;
import com.google.api.core.SettableApiFuture;
import com.google.api.gax.batching.BatchingSettings;
import com.google.api.gax.rpc.ApiException;
import com.google.api.gax.rpc.StatusCode;
import com.google.cloud.pubsublite.Message;
import com.google.cloud.pubsublite.Offset;
import com.google.cloud.pubsublite.internal.AlarmFactory;
import com.google.cloud.pubsublite.internal.CheckedApiException;
import com.google.cloud.pubsublite.internal.CheckedApiPreconditions;
import com.google.cloud.pubsublite.internal.CloseableMonitor;
import com.google.cloud.pubsublite.internal.ProxyService;
import com.google.cloud.pubsublite.internal.Publisher;
import com.google.cloud.pubsublite.internal.wire.BatchPublisher;
import com.google.cloud.pubsublite.internal.wire.BatchPublisherFactory;
import com.google.cloud.pubsublite.internal.wire.BatchPublisherImpl;
import com.google.cloud.pubsublite.internal.wire.RetryingConnection;
import com.google.cloud.pubsublite.internal.wire.RetryingConnectionImpl;
import com.google.cloud.pubsublite.internal.wire.RetryingConnectionObserver;
import com.google.cloud.pubsublite.internal.wire.SerialBatcher;
import com.google.cloud.pubsublite.internal.wire.StreamFactories;
import com.google.cloud.pubsublite.proto.InitialPublishRequest;
import com.google.cloud.pubsublite.proto.PubSubMessage;
import com.google.cloud.pubsublite.proto.PublishRequest;
import com.google.cloud.pubsublite.proto.PublishResponse;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import com.google.common.flogger.GoogleLogger;
import com.google.common.util.concurrent.Monitor;
import java.time.Duration;
import java.util.ArrayDeque;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.Queue;
import java.util.concurrent.Future;
import java.util.stream.Collectors;
import javax.annotation.concurrent.GuardedBy;

public final class PublisherImpl
extends ProxyService
implements Publisher<Offset>,
RetryingConnectionObserver<Offset> {
    private static final GoogleLogger logger = GoogleLogger.forEnclosingClass();
    private final AlarmFactory alarmFactory;
    private final PublishRequest initialRequest;
    private final CloseableMonitor monitor = new CloseableMonitor();
    private final Monitor.Guard noneInFlight;
    @GuardedBy(value="monitor.monitor")
    private Optional<Future<?>> alarmFuture;
    @GuardedBy(value="monitor.monitor")
    private final RetryingConnection<PublishRequest, BatchPublisher> connection;
    @GuardedBy(value="monitor.monitor")
    private boolean shutdown;
    @GuardedBy(value="monitor.monitor")
    private Optional<Offset> lastSentOffset;
    private final CloseableMonitor batcherMonitor;
    @GuardedBy(value="batcherMonitor.monitor")
    private final SerialBatcher batcher;
    @GuardedBy(value="monitor.monitor")
    private final Queue<InFlightBatch> batchesInFlight;

    @VisibleForTesting
    PublisherImpl(StreamFactories.PublishStreamFactory streamFactory, BatchPublisherFactory publisherFactory, AlarmFactory alarmFactory, InitialPublishRequest initialRequest, BatchingSettings batchingSettings) throws ApiException {
        super(new ApiService[0]);
        this.noneInFlight = new Monitor.Guard(this.monitor.monitor){

            public boolean isSatisfied() {
                return PublisherImpl.this.batchesInFlight.isEmpty() || PublisherImpl.this.shutdown;
            }
        };
        this.alarmFuture = Optional.empty();
        this.shutdown = false;
        this.lastSentOffset = Optional.empty();
        this.batcherMonitor = new CloseableMonitor();
        this.batchesInFlight = new ArrayDeque<InFlightBatch>();
        this.alarmFactory = alarmFactory;
        Preconditions.checkNotNull((Object)batchingSettings.getRequestByteThreshold());
        Preconditions.checkNotNull((Object)batchingSettings.getElementCountThreshold());
        this.initialRequest = PublishRequest.newBuilder().setInitialRequest(initialRequest).build();
        this.connection = new RetryingConnectionImpl<PublishRequest, PublishResponse, Offset, BatchPublisher>(streamFactory, publisherFactory, this, this.initialRequest);
        this.batcher = new SerialBatcher(batchingSettings.getRequestByteThreshold(), batchingSettings.getElementCountThreshold());
        this.addServices(this.connection);
    }

    public PublisherImpl(StreamFactories.PublishStreamFactory streamFactory, InitialPublishRequest initialRequest, BatchingSettings batchingSettings) throws ApiException {
        this(streamFactory, new BatchPublisherImpl.Factory(), AlarmFactory.create(Duration.ofNanos(Objects.requireNonNull(batchingSettings.getDelayThreshold()).toNanos())), initialRequest, batchingSettings);
    }

    @GuardedBy(value="monitor.monitor")
    private void rebatchForRestart() {
        ArrayDeque<SerialBatcher.UnbatchedMessage> messages = new ArrayDeque<SerialBatcher.UnbatchedMessage>();
        for (InFlightBatch batch : this.batchesInFlight) {
            for (int i = 0; i < batch.messages.size(); ++i) {
                messages.add(SerialBatcher.UnbatchedMessage.of(batch.messages.get(i), batch.messageFutures.get(i)));
            }
        }
        ((GoogleLogger.Api)logger.atFiner()).log("Re-publishing %s messages after reconnection", messages.size());
        long size = 0L;
        int count = 0;
        ArrayDeque<SerialBatcher.UnbatchedMessage> currentBatch = new ArrayDeque<SerialBatcher.UnbatchedMessage>();
        this.batchesInFlight.clear();
        for (SerialBatcher.UnbatchedMessage message : messages) {
            long messageSize = message.message().getSerializedSize();
            if (!(size + messageSize <= 0x380000L && (long)(count + 1) <= 1000L || currentBatch.isEmpty())) {
                this.batchesInFlight.add(new InFlightBatch(currentBatch));
                currentBatch = new ArrayDeque();
                count = 0;
                size = 0L;
            }
            currentBatch.add(message);
            size += messageSize;
            ++count;
        }
        if (!currentBatch.isEmpty()) {
            this.batchesInFlight.add(new InFlightBatch(currentBatch));
        }
    }

    @Override
    public void triggerReinitialize(CheckedApiException streamError) {
        try (CloseableMonitor.Hold h = this.monitor.enter();){
            this.connection.reinitialize(this.initialRequest);
            this.rebatchForRestart();
            Queue<InFlightBatch> batches = this.batchesInFlight;
            this.connection.modifyConnection(connectionOr -> {
                if (!connectionOr.isPresent()) {
                    return;
                }
                batches.forEach(batch -> ((BatchPublisher)connectionOr.get()).publish(batch.messages));
            });
        }
        catch (CheckedApiException e) {
            this.onPermanentError(e);
        }
    }

    @Override
    protected void handlePermanentError(CheckedApiException error) {
        try (CloseableMonitor.Hold h = this.monitor.enter();){
            this.shutdown = true;
            this.alarmFuture.ifPresent(future -> future.cancel(false));
            this.alarmFuture = Optional.empty();
            this.terminateOutstandingPublishes(error);
        }
    }

    @Override
    protected void start() {
        try (CloseableMonitor.Hold h = this.monitor.enter();){
            this.alarmFuture = Optional.of(this.alarmFactory.newAlarm(this::flushToStream));
        }
    }

    @Override
    protected void stop() {
        this.flush();
        try (CloseableMonitor.Hold h = this.monitor.enter();){
            this.shutdown = true;
            this.alarmFuture.ifPresent(future -> future.cancel(false));
            this.alarmFuture = Optional.empty();
        }
        this.flush();
    }

    @GuardedBy(value="monitor.monitor")
    private void terminateOutstandingPublishes(CheckedApiException e) {
        this.batchesInFlight.forEach(batch -> batch.messageFutures.forEach(future -> future.setException((Throwable)e)));
        try (CloseableMonitor.Hold h = this.batcherMonitor.enter();){
            this.batcher.flush().forEach(batch -> batch.forEach(m -> m.future().setException((Throwable)e)));
        }
        this.batchesInFlight.clear();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public ApiFuture<Offset> publish(Message message) {
        PubSubMessage proto = message.toProto();
        try (CloseableMonitor.Hold h = this.batcherMonitor.enter();){
            ApiService.State currentState = this.state();
            CheckedApiPreconditions.checkState(currentState == ApiService.State.RUNNING, "Cannot publish when Publisher state is %s.", currentState.name());
            ApiFuture<Offset> apiFuture = this.batcher.add(proto);
            return apiFuture;
        }
        catch (CheckedApiException e) {
            this.onPermanentError(e);
            return ApiFutures.immediateFailedFuture((Throwable)e);
        }
    }

    @Override
    public void cancelOutstandingPublishes() {
        try (CloseableMonitor.Hold h = this.monitor.enter();){
            this.terminateOutstandingPublishes(new CheckedApiException("Cancelled by client.", StatusCode.Code.CANCELLED));
        }
    }

    private void flushToStream() {
        try (CloseableMonitor.Hold h = this.monitor.enter();){
            List<List<SerialBatcher.UnbatchedMessage>> batches;
            if (this.shutdown) {
                return;
            }
            try (CloseableMonitor.Hold h2 = this.batcherMonitor.enter();){
                batches = this.batcher.flush();
            }
            for (List<SerialBatcher.UnbatchedMessage> batch : batches) {
                this.processBatch(batch);
            }
        }
        catch (CheckedApiException e) {
            this.onPermanentError(e);
        }
    }

    @GuardedBy(value="monitor.monitor")
    private void processBatch(Collection<SerialBatcher.UnbatchedMessage> batch) throws CheckedApiException {
        if (batch.isEmpty()) {
            return;
        }
        InFlightBatch inFlightBatch = new InFlightBatch(batch);
        this.batchesInFlight.add(inFlightBatch);
        this.connection.modifyConnection(connectionOr -> {
            CheckedApiPreconditions.checkState(connectionOr.isPresent(), "Published after the stream shut down.");
            ((BatchPublisher)connectionOr.get()).publish(inFlightBatch.messages);
        });
    }

    @Override
    public void flush() {
        this.flushToStream();
        CloseableMonitor.Hold h = this.monitor.enterWhenUninterruptibly(this.noneInFlight);
        Throwable throwable = null;
        if (h != null) {
            if (throwable != null) {
                try {
                    h.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
            } else {
                h.close();
            }
        }
    }

    @Override
    public void onClientResponse(Offset value) throws CheckedApiException {
        try (CloseableMonitor.Hold h = this.monitor.enter();){
            CheckedApiPreconditions.checkState(!this.batchesInFlight.isEmpty(), "Received publish response with no batches in flight.");
            if (this.lastSentOffset.isPresent() && this.lastSentOffset.get().value() >= value.value()) {
                throw new CheckedApiException(String.format("Received publish response with offset %s that is inconsistent with previous responses max %s", value, this.lastSentOffset.get()), StatusCode.Code.FAILED_PRECONDITION);
            }
            InFlightBatch batch = this.batchesInFlight.remove();
            this.lastSentOffset = Optional.of(Offset.of(value.value() + (long)batch.messages.size() - 1L));
            for (int i = 0; i < batch.messageFutures.size(); ++i) {
                Offset offset = Offset.of(value.value() + (long)i);
                batch.messageFutures.get(i).set((Object)offset);
            }
        }
    }

    private static class InFlightBatch {
        final List<PubSubMessage> messages;
        final List<SettableApiFuture<Offset>> messageFutures;

        InFlightBatch(Collection<SerialBatcher.UnbatchedMessage> toBatch) {
            this.messages = toBatch.stream().map(SerialBatcher.UnbatchedMessage::message).collect(Collectors.toList());
            this.messageFutures = toBatch.stream().map(SerialBatcher.UnbatchedMessage::future).collect(Collectors.toList());
        }
    }
}

