/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.byteman.agent;

import java.lang.reflect.AccessibleObject;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.Member;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import org.jboss.byteman.agent.AccessEnabler;
import org.jboss.byteman.agent.AccessibleConstructorInvoker;
import org.jboss.byteman.agent.AccessibleFieldGetter;
import org.jboss.byteman.agent.AccessibleFieldSetter;
import org.jboss.byteman.agent.AccessibleMethodInvoker;
import org.jboss.byteman.rule.exception.ExecuteException;
import org.jboss.byteman.rule.helper.Helper;

public class DefaultAccessEnabler
implements AccessEnabler {
    @Override
    public boolean requiresAccess(Class<?> klazz) {
        while (Modifier.isPublic(klazz.getModifiers())) {
            if (!klazz.isMemberClass()) {
                return false;
            }
            try {
                klazz = klazz.getDeclaringClass();
            }
            catch (SecurityException se) {
                return true;
            }
        }
        return true;
    }

    @Override
    public boolean requiresAccess(AccessibleObject accessible) {
        Member member = (Member)((Object)accessible);
        if (!Modifier.isPublic(member.getModifiers())) {
            return true;
        }
        Class<?> clazz = member.getDeclaringClass();
        if (!Modifier.isPublic(clazz.getModifiers())) {
            return true;
        }
        while (clazz.isMemberClass()) {
            if (Modifier.isPublic((clazz = clazz.getEnclosingClass()).getModifiers())) continue;
            return true;
        }
        return false;
    }

    @Override
    public void ensureAccess(AccessibleObject accessible) {
        try {
            accessible.setAccessible(true);
        }
        catch (Exception e) {
            Helper.verbose("DefaultAccessEnabler.ensureAccess: error enabling access for member " + e);
            Helper.verboseTraceException(e);
        }
    }

    @Override
    public AccessibleMethodInvoker createMethodInvoker(Method method) {
        return this.createMethodInvoker(method, false);
    }

    public AccessibleMethodInvoker createMethodInvoker(Method method, boolean alreadyAccessible) {
        if (!alreadyAccessible) {
            try {
                method.setAccessible(true);
            }
            catch (Exception e) {
                Helper.verbose("DefaultAccessEnabler.createMethodInvoker: error enabling access for method " + e);
                Helper.verboseTraceException(e);
            }
        }
        return new DefaultAccessibleMethodInvoker(method);
    }

    @Override
    public AccessibleConstructorInvoker createConstructorInvoker(Constructor constructor) {
        return this.createConstructorInvoker(constructor, false);
    }

    public AccessibleConstructorInvoker createConstructorInvoker(Constructor constructor, boolean alreadyAccessible) {
        if (!alreadyAccessible) {
            try {
                constructor.setAccessible(true);
            }
            catch (Exception e) {
                Helper.verbose("DefaultAccessEnabler.createConstructorInvoker: error enabling access for constructor " + e);
                Helper.verboseTraceException(e);
            }
        }
        return new DefaultAccessibleConstructorInvoker(constructor);
    }

    @Override
    public AccessibleFieldGetter createFieldGetter(Field field) {
        return this.createFieldGetter(field, false);
    }

    public AccessibleFieldGetter createFieldGetter(Field field, boolean alreadyAccessible) {
        if (!alreadyAccessible) {
            try {
                field.setAccessible(true);
            }
            catch (Exception e) {
                Helper.verbose("DefaultAccessEnabler.createFieldGetter: error enabling access for field " + e);
                Helper.verboseTraceException(e);
            }
        }
        return new DefaultAccessibleFieldGetter(field);
    }

    @Override
    public AccessibleFieldSetter createFieldSetter(Field field) {
        return this.createFieldSetter(field, false);
    }

    public AccessibleFieldSetter createFieldSetter(Field field, boolean alreadyAccessible) {
        if (!alreadyAccessible) {
            try {
                field.setAccessible(true);
            }
            catch (Exception e) {
                Helper.verbose("DefaultAccessEnabler.createFieldGetter: error enabling access for field " + e);
                Helper.verboseTraceException(e);
            }
        }
        return new DefaultAccessibleFieldSetter(field);
    }

    private static class DefaultAccessibleFieldSetter
    implements AccessibleFieldSetter {
        private Field field;

        public DefaultAccessibleFieldSetter(Field field) {
            this.field = field;
        }

        @Override
        public void set(Object owner, Object value) {
            try {
                this.field.set(owner, value);
            }
            catch (Exception e) {
                throw new ExecuteException("DefaultAccessibleFieldGetter.get : exception writing field " + this.field, e);
            }
        }
    }

    private static class DefaultAccessibleFieldGetter
    implements AccessibleFieldGetter {
        private Field field;

        public DefaultAccessibleFieldGetter(Field field) {
            this.field = field;
        }

        @Override
        public Object get(Object owner) {
            try {
                return this.field.get(owner);
            }
            catch (Exception e) {
                throw new ExecuteException("DefaultAccessibleFieldGetter.get : exception reading field " + this.field, e);
            }
        }
    }

    private static class DefaultAccessibleConstructorInvoker
    implements AccessibleConstructorInvoker {
        private Constructor constructor;

        public DefaultAccessibleConstructorInvoker(Constructor constructor) {
            this.constructor = constructor;
        }

        @Override
        public Object invoke(Object[] args) {
            try {
                return this.constructor.newInstance(args);
            }
            catch (Exception e) {
                throw new ExecuteException("DefaultAccessibleConstructorInvoker.invoke : exception invoking constructor " + this.constructor, e);
            }
        }
    }

    private static class DefaultAccessibleMethodInvoker
    implements AccessibleMethodInvoker {
        private Method method;

        public DefaultAccessibleMethodInvoker(Method method) {
            this.method = method;
        }

        @Override
        public Object invoke(Object receiver, Object[] args) {
            try {
                return this.method.invoke(receiver, args);
            }
            catch (Exception e) {
                throw new ExecuteException("DefaultAccessibleMethodInvoker.invoke : exception invoking method " + this.method, e);
            }
        }
    }
}

