/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.byteman.agent.adapter;

import org.jboss.byteman.agent.TransformContext;
import org.jboss.byteman.agent.adapter.RuleCheckAdapter;
import org.jboss.byteman.agent.adapter.RuleCheckMethodAdapter;
import org.jboss.byteman.objectweb.asm.ClassVisitor;
import org.jboss.byteman.objectweb.asm.MethodVisitor;
import org.jboss.byteman.rule.type.TypeHelper;

public class NewCheckAdapter
extends RuleCheckAdapter {
    private String typeName;
    private int count;
    private boolean whenComplete;

    public NewCheckAdapter(ClassVisitor cv, TransformContext transformContext, String typeName, int count, boolean whenComplete) {
        super(cv, transformContext);
        this.typeName = typeName;
        this.count = count;
        this.whenComplete = whenComplete;
    }

    @Override
    public MethodVisitor visitMethod(int access, String name, String desc, String signature, String[] exceptions) {
        MethodVisitor mv = super.visitMethod(access, name, desc, signature, exceptions);
        if (this.matchTargetMethod(access, name, desc)) {
            this.setVisited();
            return new NewCheckMethodAdapter(mv, this.getTransformContext(), access, name, desc, signature, exceptions);
        }
        return mv;
    }

    private class NewCheckMethodAdapter
    extends RuleCheckMethodAdapter {
        private int access;
        private String name;
        private String descriptor;
        private String signature;
        private String[] exceptions;
        private boolean visited;
        private int visitedCount;
        private boolean triggerReady;
        String matchedBaseName;

        NewCheckMethodAdapter(MethodVisitor mv, TransformContext transformContext, int access, String name, String descriptor, String signature, String[] exceptions) {
            super(mv, transformContext, access, name, descriptor);
            this.access = access;
            this.name = name;
            this.descriptor = descriptor;
            this.signature = signature;
            this.exceptions = exceptions;
            this.triggerReady = false;
            this.visitedCount = 0;
            this.matchedBaseName = null;
        }

        @Override
        public void visitMethodInsn(int opcode, String owner, String name, String descriptor, boolean isInterface) {
            super.visitMethodInsn(opcode, owner, name, descriptor, isInterface);
            if (this.triggerReady && opcode == 183 && name.equals("<init>")) {
                this.setTriggerPoint();
                this.triggerReady = false;
            }
        }

        @Override
        public void visitTypeInsn(int opcode, String type) {
            if (opcode == 187 && (NewCheckAdapter.this.count == 0 || this.visitedCount < NewCheckAdapter.this.count) && this.matchType(type)) {
                ++this.visitedCount;
                if (NewCheckAdapter.this.count == 0 || this.visitedCount == NewCheckAdapter.this.count) {
                    if (NewCheckAdapter.this.whenComplete) {
                        this.triggerReady = true;
                    } else {
                        this.setTriggerPoint();
                    }
                }
            }
            super.visitTypeInsn(opcode, type);
        }

        private boolean matchType(String type) {
            String baseName = TypeHelper.internalizeClass(type, true);
            boolean matched = false;
            if (NewCheckAdapter.this.typeName.length() == 0) {
                matched = true;
            } else if (NewCheckAdapter.this.typeName.equals(baseName)) {
                matched = true;
            } else if (!NewCheckAdapter.this.typeName.contains(".") && baseName.contains(".")) {
                int tailIdx = baseName.lastIndexOf(".");
                matched = NewCheckAdapter.this.typeName.equals(baseName.substring(tailIdx + 1));
            }
            if (matched) {
                this.matchedBaseName = baseName;
            }
            return matched;
        }

        @Override
        public String getNewTypeParamDescriptor() {
            return TypeHelper.externalizeType(this.matchedBaseName);
        }
    }
}

