/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.byteman.agent.adapter.cfg;

import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import org.jboss.byteman.agent.adapter.cfg.CFG;
import org.jboss.byteman.agent.adapter.cfg.CodeLocation;
import org.jboss.byteman.objectweb.asm.Label;

public class TryCatchDetails {
    private CFG cfg;
    private Label start;
    private Label end;
    private Label handler;
    private List<CodeLocation> openEnters;
    private String type;
    private boolean isTriggerHandler;
    private List<TryCatchDetails> shadowRegions;

    public TryCatchDetails(CFG cfg, Label start, Label end, Label handler, String type, boolean isTriggerHandler) {
        this.cfg = cfg;
        this.start = start;
        this.end = end;
        this.handler = handler;
        this.openEnters = new LinkedList<CodeLocation>();
        this.type = type;
        this.isTriggerHandler = isTriggerHandler;
        this.shadowRegions = null;
    }

    public Label getStart() {
        return this.start;
    }

    public Label getEnd() {
        return this.end;
    }

    public Label getHandler() {
        return this.handler;
    }

    public String getType() {
        return this.type;
    }

    public boolean isTriggerHandler() {
        return this.isTriggerHandler;
    }

    public void addOpenEnter(CodeLocation openEnter) {
        Iterator<CodeLocation> iterator = this.openEnters.iterator();
        int pos = 0;
        while (iterator.hasNext()) {
            CodeLocation next = iterator.next();
            int compare = openEnter.compareTo(next);
            if (compare < 0) {
                ++pos;
                continue;
            }
            if (compare > 0) break;
            return;
        }
        this.openEnters.add(pos, openEnter);
    }

    public boolean containsOpenEnter(CodeLocation openEnter) {
        return this.openEnters.contains(openEnter);
    }

    public void addOpenLocations(List<CodeLocation> openMonitorEnters) {
        for (CodeLocation location : this.openEnters) {
            Iterator<CodeLocation> iterator2 = openMonitorEnters.iterator();
            int pos = 0;
            while (iterator2.hasNext()) {
                CodeLocation next = iterator2.next();
                int compare = location.compareTo(next);
                if (compare < 0) {
                    ++pos;
                    continue;
                }
                if (compare != 0) break;
                pos = -1;
                break;
            }
            if (pos < 0) continue;
            openMonitorEnters.add(pos, location);
        }
    }

    public Iterator<CodeLocation> getOpenEnters() {
        return this.openEnters.iterator();
    }

    public void addShadowRegion(TryCatchDetails tryCatchDetails) {
        if (this.shadowRegions == null) {
            this.shadowRegions = new LinkedList<TryCatchDetails>();
        }
        if (!this.shadowRegions.contains(tryCatchDetails)) {
            this.shadowRegions.add(tryCatchDetails);
        }
    }

    public List<TryCatchDetails> getShadowRegions() {
        return this.shadowRegions;
    }

    public boolean hasShadowRegion(TryCatchDetails tryCatchDetails) {
        return this.shadowRegions != null && this.shadowRegions.contains(tryCatchDetails);
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("" + this.type + " try: " + this.cfg.getLocation(this.start) + " catch: " + this.cfg.getLocation(this.end) + " handler: " + this.cfg.getLocation(this.handler));
        return builder.toString();
    }
}

