/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.resteasy.core.se;

import jakarta.ws.rs.SeBootstrap;
import jakarta.ws.rs.core.Application;
import java.io.IOException;
import java.security.AccessController;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionException;
import java.util.concurrent.CompletionStage;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import org.jboss.jandex.Index;
import org.jboss.logging.Logger;
import org.jboss.resteasy.core.AsynchronousDispatcher;
import org.jboss.resteasy.core.scanner.ResourceScanner;
import org.jboss.resteasy.core.se.ConfigurationOption;
import org.jboss.resteasy.core.se.ResteasySeConfiguration;
import org.jboss.resteasy.plugins.server.embedded.EmbeddedServer;
import org.jboss.resteasy.plugins.server.embedded.EmbeddedServers;
import org.jboss.resteasy.resteasy_jaxrs.i18n.Messages;
import org.jboss.resteasy.spi.ResteasyDeployment;

public class ResteasySeInstance
implements SeBootstrap.Instance {
    private static final Logger LOGGER = Logger.getLogger(ResteasySeInstance.class);
    private final EmbeddedServer server;
    private final SeBootstrap.Configuration configuration;

    private ResteasySeInstance(EmbeddedServer server, SeBootstrap.Configuration configuration) {
        this.server = server;
        this.configuration = configuration;
    }

    public static CompletionStage<SeBootstrap.Instance> create(Application application, SeBootstrap.Configuration configuration) {
        return CompletableFuture.supplyAsync(() -> {
            try {
                SeBootstrap.Configuration config = ResteasySeConfiguration.from(configuration);
                EmbeddedServer server = EmbeddedServers.findServer(config);
                ResteasyDeployment deployment = server.getDeployment();
                deployment.setRegisterBuiltin(((Boolean)ConfigurationOption.REGISTER_BUILT_INS.getValue(config)).booleanValue());
                deployment.setApplication(application);
                try {
                    ResteasySeInstance.scanForResources(deployment, application, config);
                }
                catch (IOException e) {
                    throw Messages.MESSAGES.failedToScanResources(e);
                }
                deployment.start();
                if (LOGGER.isDebugEnabled()) {
                    LOGGER.debugf("Application %s used for %s", (Object)deployment.getApplication(), (Object)server);
                    deployment.getResourceClasses().forEach(name -> LOGGER.debugf("Resource %s found for %s", name, (Object)server));
                    deployment.getProviderClasses().forEach(name -> LOGGER.debugf("Provider %s found for %s", name, (Object)server));
                }
                server.start(config);
                return new ResteasySeInstance(server, config);
            }
            catch (Throwable t) {
                throw new CompletionException(t);
            }
        });
    }

    public static CompletionStage<SeBootstrap.Instance> create(Class<? extends Application> applicationClass, SeBootstrap.Configuration configuration) {
        return CompletableFuture.supplyAsync(() -> {
            try {
                SeBootstrap.Configuration config = ResteasySeConfiguration.from(configuration);
                EmbeddedServer server = EmbeddedServers.findServer(config);
                ResteasyDeployment deployment = server.getDeployment();
                deployment.setRegisterBuiltin(((Boolean)ConfigurationOption.REGISTER_BUILT_INS.getValue(config)).booleanValue());
                deployment.setApplicationClass(applicationClass.getName());
                deployment.start();
                Application application = deployment.getApplication();
                try {
                    ResteasySeInstance.scanForResources(deployment, application, config);
                    deployment.registration();
                }
                catch (IOException e) {
                    throw Messages.MESSAGES.failedToScanResources(e);
                }
                if (LOGGER.isDebugEnabled()) {
                    LOGGER.debugf("Application %s used for %s", (Object)deployment.getApplication(), (Object)server);
                    deployment.getResourceClasses().forEach(name -> LOGGER.debugf("Resource %s found for %s", name, (Object)server));
                    deployment.getProviderClasses().forEach(name -> LOGGER.debugf("Provider %s found for %s", name, (Object)server));
                }
                server.start(config);
                return new ResteasySeInstance(server, config);
            }
            catch (Throwable t) {
                throw new CompletionException(t);
            }
        });
    }

    public SeBootstrap.Configuration configuration() {
        return this.configuration;
    }

    public CompletionStage<SeBootstrap.Instance.StopResult> stop() {
        return CompletableFuture.supplyAsync(() -> {
            try {
                this.server.stop();
                return new SeBootstrap.Instance.StopResult(){

                    public <T> T unwrap(Class<T> nativeClass) {
                        if (nativeClass != null && nativeClass.isInstance(ResteasySeInstance.this.server)) {
                            return nativeClass.cast(ResteasySeInstance.this.server);
                        }
                        return null;
                    }
                };
            }
            catch (Throwable t) {
                throw new CompletionException(t);
            }
        });
    }

    public <T> T unwrap(Class<T> nativeClass) {
        if (nativeClass != null && nativeClass.isInstance(this.server)) {
            return nativeClass.cast(this.server);
        }
        return null;
    }

    private static void scanForResources(ResteasyDeployment deployment, Application application, SeBootstrap.Configuration configuration) throws IOException {
        if (application.getClasses() != null && !application.getClasses().isEmpty() || application.getSingletons() != null && !application.getSingletons().isEmpty()) {
            return;
        }
        Index index = (Index)ConfigurationOption.JANDEX_INDEX.getValue(configuration);
        ResourceScanner resourceScanner = index == null ? ResourceScanner.fromClassPath(ResteasySeInstance.classLoader(application.getClass()), (Predicate)ConfigurationOption.JANDEX_CLASS_PATH_FILTER.getValue(configuration)) : ResourceScanner.of(index);
        if (ResteasySeInstance.loadServices(application.getProperties())) {
            Set resources = resourceScanner.getResources().stream().filter(name -> !AsynchronousDispatcher.class.getName().equals(name)).collect(Collectors.toSet());
            deployment.getScannedResourceClasses().addAll(resources);
            deployment.getScannedProviderClasses().addAll(resourceScanner.getProviders());
        }
    }

    private static ClassLoader classLoader() {
        if (System.getSecurityManager() == null) {
            ClassLoader cl = Thread.currentThread().getContextClassLoader();
            if (cl == null) {
                cl = ResteasySeInstance.class.getClassLoader();
            }
            if (cl == null) {
                cl = ClassLoader.getSystemClassLoader();
            }
            return cl;
        }
        return AccessController.doPrivileged(() -> {
            ClassLoader cl = Thread.currentThread().getContextClassLoader();
            if (cl == null) {
                cl = ResteasySeInstance.class.getClassLoader();
            }
            if (cl == null) {
                cl = ClassLoader.getSystemClassLoader();
            }
            return cl;
        });
    }

    private static ClassLoader classLoader(Class<?> c) {
        if (c == null) {
            return ResteasySeInstance.classLoader();
        }
        if (System.getSecurityManager() == null) {
            return c.getClassLoader();
        }
        return AccessController.doPrivileged(c::getClassLoader);
    }

    private static boolean loadServices(Map<String, Object> props) {
        Object value = props.get("jakarta.ws.rs.loadServices");
        if (value instanceof Boolean) {
            return (Boolean)value;
        }
        return true;
    }
}

