/*
 * Decompiled with CFR 0.152.
 */
package com.azure.messaging.eventhubs;

import com.azure.core.amqp.AmqpRetryOptions;
import com.azure.core.amqp.AmqpTransportType;
import com.azure.core.amqp.ProxyAuthenticationType;
import com.azure.core.amqp.ProxyOptions;
import com.azure.core.amqp.client.traits.AmqpTrait;
import com.azure.core.amqp.implementation.AzureTokenManagerProvider;
import com.azure.core.amqp.implementation.ConnectionOptions;
import com.azure.core.amqp.implementation.ConnectionStringProperties;
import com.azure.core.amqp.implementation.MessageSerializer;
import com.azure.core.amqp.implementation.ReactorHandlerProvider;
import com.azure.core.amqp.implementation.ReactorProvider;
import com.azure.core.amqp.implementation.StringUtil;
import com.azure.core.amqp.implementation.TokenManagerProvider;
import com.azure.core.amqp.implementation.TracerProvider;
import com.azure.core.amqp.models.CbsAuthorizationType;
import com.azure.core.annotation.ServiceClientBuilder;
import com.azure.core.annotation.ServiceClientProtocol;
import com.azure.core.client.traits.AzureNamedKeyCredentialTrait;
import com.azure.core.client.traits.AzureSasCredentialTrait;
import com.azure.core.client.traits.ConfigurationTrait;
import com.azure.core.client.traits.ConnectionStringTrait;
import com.azure.core.client.traits.TokenCredentialTrait;
import com.azure.core.credential.AzureNamedKeyCredential;
import com.azure.core.credential.AzureSasCredential;
import com.azure.core.credential.TokenCredential;
import com.azure.core.util.ClientOptions;
import com.azure.core.util.Configuration;
import com.azure.core.util.CoreUtils;
import com.azure.core.util.logging.ClientLogger;
import com.azure.core.util.tracing.Tracer;
import com.azure.messaging.eventhubs.EventHubAsyncClient;
import com.azure.messaging.eventhubs.EventHubClient;
import com.azure.messaging.eventhubs.EventHubConsumerAsyncClient;
import com.azure.messaging.eventhubs.EventHubConsumerClient;
import com.azure.messaging.eventhubs.EventHubMessageSerializer;
import com.azure.messaging.eventhubs.EventHubProducerAsyncClient;
import com.azure.messaging.eventhubs.EventHubProducerClient;
import com.azure.messaging.eventhubs.implementation.ClientConstants;
import com.azure.messaging.eventhubs.implementation.EventHubConnectionProcessor;
import com.azure.messaging.eventhubs.implementation.EventHubReactorAmqpConnection;
import com.azure.messaging.eventhubs.implementation.EventHubSharedKeyCredential;
import java.net.InetSocketAddress;
import java.net.MalformedURLException;
import java.net.Proxy;
import java.net.URL;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.ServiceLoader;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.regex.Pattern;
import org.apache.qpid.proton.engine.SslDomain;
import org.reactivestreams.Subscriber;
import reactor.core.publisher.Flux;
import reactor.core.scheduler.Scheduler;
import reactor.core.scheduler.Schedulers;

@ServiceClientBuilder(serviceClients={EventHubProducerAsyncClient.class, EventHubProducerClient.class, EventHubConsumerAsyncClient.class, EventHubConsumerClient.class}, protocol=ServiceClientProtocol.AMQP)
public class EventHubClientBuilder
implements TokenCredentialTrait<EventHubClientBuilder>,
AzureNamedKeyCredentialTrait<EventHubClientBuilder>,
ConnectionStringTrait<EventHubClientBuilder>,
AzureSasCredentialTrait<EventHubClientBuilder>,
AmqpTrait<EventHubClientBuilder>,
ConfigurationTrait<EventHubClientBuilder> {
    static final int DEFAULT_PREFETCH_COUNT = 500;
    static final int DEFAULT_PREFETCH_COUNT_FOR_SYNC_CLIENT = 1;
    public static final String DEFAULT_CONSUMER_GROUP_NAME = "$Default";
    private static final int MINIMUM_PREFETCH_COUNT = 1;
    private static final int MAXIMUM_PREFETCH_COUNT = 8000;
    private static final String EVENTHUBS_PROPERTIES_FILE = "azure-messaging-eventhubs.properties";
    private static final String NAME_KEY = "name";
    private static final String VERSION_KEY = "version";
    private static final String UNKNOWN = "UNKNOWN";
    private static final String AZURE_EVENT_HUBS_CONNECTION_STRING = "AZURE_EVENT_HUBS_CONNECTION_STRING";
    private static final AmqpRetryOptions DEFAULT_RETRY = new AmqpRetryOptions().setTryTimeout(ClientConstants.OPERATION_TIMEOUT);
    private static final Pattern HOST_PORT_PATTERN = Pattern.compile("^[^:]+:\\d+");
    private static final ClientLogger LOGGER = new ClientLogger(EventHubClientBuilder.class);
    private final Object connectionLock = new Object();
    private final AtomicBoolean isSharedConnection = new AtomicBoolean();
    private TokenCredential credentials;
    private Configuration configuration;
    private ProxyOptions proxyOptions;
    private AmqpRetryOptions retryOptions;
    private Scheduler scheduler;
    private AmqpTransportType transport;
    private String fullyQualifiedNamespace;
    private String eventHubName;
    private String consumerGroup;
    private EventHubConnectionProcessor eventHubConnectionProcessor;
    private Integer prefetchCount;
    private ClientOptions clientOptions;
    private SslDomain.VerifyMode verifyMode;
    private URL customEndpointAddress;
    private final AtomicInteger openClients = new AtomicInteger();

    public EventHubClientBuilder() {
        this.transport = AmqpTransportType.AMQP;
    }

    public EventHubClientBuilder connectionString(String connectionString) {
        ConnectionStringProperties properties = new ConnectionStringProperties(connectionString);
        TokenCredential tokenCredential = this.getTokenCredential(properties);
        return this.credential(properties.getEndpoint().getHost(), properties.getEntityPath(), tokenCredential);
    }

    private TokenCredential getTokenCredential(ConnectionStringProperties properties) {
        EventHubSharedKeyCredential tokenCredential = properties.getSharedAccessSignature() == null ? new EventHubSharedKeyCredential(properties.getSharedAccessKeyName(), properties.getSharedAccessKey(), ClientConstants.TOKEN_VALIDITY) : new EventHubSharedKeyCredential(properties.getSharedAccessSignature());
        return tokenCredential;
    }

    public EventHubClientBuilder clientOptions(ClientOptions clientOptions) {
        this.clientOptions = clientOptions;
        return this;
    }

    public EventHubClientBuilder connectionString(String connectionString, String eventHubName) {
        Objects.requireNonNull(connectionString, "'connectionString' cannot be null.");
        Objects.requireNonNull(eventHubName, "'eventHubName' cannot be null.");
        if (connectionString.isEmpty()) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException("'connectionString' cannot be an empty string."));
        }
        if (eventHubName.isEmpty()) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException("'eventHubName' cannot be an empty string."));
        }
        ConnectionStringProperties properties = new ConnectionStringProperties(connectionString);
        TokenCredential tokenCredential = this.getTokenCredential(properties);
        if (!CoreUtils.isNullOrEmpty((CharSequence)properties.getEntityPath()) && !eventHubName.equals(properties.getEntityPath())) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format(Locale.US, "'connectionString' contains an Event Hub name [%s] and it does not match the given 'eventHubName' parameter [%s]. Please use the credentials(String connectionString) overload. Or supply a 'connectionString' without 'EntityPath' in it.", properties.getEntityPath(), eventHubName)));
        }
        return this.credential(properties.getEndpoint().getHost(), eventHubName, tokenCredential);
    }

    public EventHubClientBuilder configuration(Configuration configuration) {
        this.configuration = configuration;
        return this;
    }

    public EventHubClientBuilder customEndpointAddress(String customEndpointAddress) {
        if (customEndpointAddress == null) {
            this.customEndpointAddress = null;
            return this;
        }
        try {
            this.customEndpointAddress = new URL(customEndpointAddress);
        }
        catch (MalformedURLException e) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(customEndpointAddress + " : is not a valid URL.", e));
        }
        return this;
    }

    public EventHubClientBuilder fullyQualifiedNamespace(String fullyQualifiedNamespace) {
        this.fullyQualifiedNamespace = Objects.requireNonNull(fullyQualifiedNamespace, "'fullyQualifiedNamespace' cannot be null.");
        if (CoreUtils.isNullOrEmpty((CharSequence)fullyQualifiedNamespace)) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException("'fullyQualifiedNamespace' cannot be an empty string."));
        }
        return this;
    }

    private String getAndValidateFullyQualifiedNamespace() {
        if (CoreUtils.isNullOrEmpty((CharSequence)this.fullyQualifiedNamespace)) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException("'fullyQualifiedNamespace' cannot be an empty string."));
        }
        return this.fullyQualifiedNamespace;
    }

    public EventHubClientBuilder eventHubName(String eventHubName) {
        this.eventHubName = Objects.requireNonNull(eventHubName, "'eventHubName' cannot be null.");
        if (CoreUtils.isNullOrEmpty((CharSequence)eventHubName)) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException("'eventHubName' cannot be an empty string."));
        }
        return this;
    }

    private String getEventHubName() {
        if (CoreUtils.isNullOrEmpty((CharSequence)this.eventHubName)) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException("'eventHubName' cannot be an empty string."));
        }
        return this.eventHubName;
    }

    public EventHubClientBuilder shareConnection() {
        this.isSharedConnection.set(true);
        return this;
    }

    public EventHubClientBuilder credential(String fullyQualifiedNamespace, String eventHubName, TokenCredential credential) {
        this.fullyQualifiedNamespace = Objects.requireNonNull(fullyQualifiedNamespace, "'fullyQualifiedNamespace' cannot be null.");
        this.credentials = Objects.requireNonNull(credential, "'credential' cannot be null.");
        this.eventHubName = Objects.requireNonNull(eventHubName, "'eventHubName' cannot be null.");
        if (CoreUtils.isNullOrEmpty((CharSequence)fullyQualifiedNamespace)) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException("'host' cannot be an empty string."));
        }
        if (CoreUtils.isNullOrEmpty((CharSequence)eventHubName)) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException("'eventHubName' cannot be an empty string."));
        }
        return this;
    }

    public EventHubClientBuilder credential(TokenCredential credential) {
        this.credentials = Objects.requireNonNull(credential, "'credential' cannot be null.");
        return this;
    }

    public EventHubClientBuilder credential(String fullyQualifiedNamespace, String eventHubName, AzureNamedKeyCredential credential) {
        this.fullyQualifiedNamespace = Objects.requireNonNull(fullyQualifiedNamespace, "'fullyQualifiedNamespace' cannot be null.");
        this.eventHubName = Objects.requireNonNull(eventHubName, "'eventHubName' cannot be null.");
        if (CoreUtils.isNullOrEmpty((CharSequence)fullyQualifiedNamespace)) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException("'host' cannot be an empty string."));
        }
        if (CoreUtils.isNullOrEmpty((CharSequence)eventHubName)) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException("'eventHubName' cannot be an empty string."));
        }
        Objects.requireNonNull(credential, "'credential' cannot be null.");
        this.credentials = new EventHubSharedKeyCredential(credential.getAzureNamedKey().getName(), credential.getAzureNamedKey().getKey(), ClientConstants.TOKEN_VALIDITY);
        return this;
    }

    public EventHubClientBuilder credential(AzureNamedKeyCredential credential) {
        Objects.requireNonNull(credential, "'credential' cannot be null.");
        this.credentials = new EventHubSharedKeyCredential(credential.getAzureNamedKey().getName(), credential.getAzureNamedKey().getKey(), ClientConstants.TOKEN_VALIDITY);
        return this;
    }

    public EventHubClientBuilder credential(String fullyQualifiedNamespace, String eventHubName, AzureSasCredential credential) {
        this.fullyQualifiedNamespace = Objects.requireNonNull(fullyQualifiedNamespace, "'fullyQualifiedNamespace' cannot be null.");
        this.eventHubName = Objects.requireNonNull(eventHubName, "'eventHubName' cannot be null.");
        if (CoreUtils.isNullOrEmpty((CharSequence)fullyQualifiedNamespace)) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException("'host' cannot be an empty string."));
        }
        if (CoreUtils.isNullOrEmpty((CharSequence)eventHubName)) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException("'eventHubName' cannot be an empty string."));
        }
        Objects.requireNonNull(credential, "'credential' cannot be null.");
        this.credentials = new EventHubSharedKeyCredential(credential.getSignature());
        return this;
    }

    public EventHubClientBuilder credential(AzureSasCredential credential) {
        Objects.requireNonNull(credential, "'credential' cannot be null.");
        this.credentials = new EventHubSharedKeyCredential(credential.getSignature());
        return this;
    }

    public EventHubClientBuilder proxyOptions(ProxyOptions proxyOptions) {
        this.proxyOptions = proxyOptions;
        return this;
    }

    public EventHubClientBuilder transportType(AmqpTransportType transport) {
        this.transport = transport;
        return this;
    }

    @Deprecated
    public EventHubClientBuilder retry(AmqpRetryOptions retryOptions) {
        this.retryOptions = retryOptions;
        return this;
    }

    public EventHubClientBuilder retryOptions(AmqpRetryOptions retryOptions) {
        this.retryOptions = retryOptions;
        return this;
    }

    public EventHubClientBuilder consumerGroup(String consumerGroup) {
        this.consumerGroup = consumerGroup;
        return this;
    }

    public EventHubClientBuilder prefetchCount(int prefetchCount) {
        if (prefetchCount < 1) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format(Locale.US, "PrefetchCount, '%s' has to be above %s", prefetchCount, 1)));
        }
        if (prefetchCount > 8000) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format(Locale.US, "PrefetchCount, '%s', has to be below %s", prefetchCount, 8000)));
        }
        this.prefetchCount = prefetchCount;
        return this;
    }

    Integer getPrefetchCount() {
        return this.prefetchCount;
    }

    EventHubClientBuilder scheduler(Scheduler scheduler) {
        this.scheduler = scheduler;
        return this;
    }

    EventHubClientBuilder verifyMode(SslDomain.VerifyMode verifyMode) {
        this.verifyMode = verifyMode;
        return this;
    }

    public EventHubConsumerAsyncClient buildAsyncConsumerClient() {
        if (CoreUtils.isNullOrEmpty((CharSequence)this.consumerGroup)) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException("'consumerGroup' cannot be null or an empty string. using EventHubClientBuilder.consumerGroup(String)"));
        }
        return this.buildAsyncClient().createConsumer(this.consumerGroup, this.prefetchCount);
    }

    public EventHubConsumerClient buildConsumerClient() {
        return this.buildClient().createConsumer(this.consumerGroup, this.prefetchCount);
    }

    public EventHubProducerAsyncClient buildAsyncProducerClient() {
        return this.buildAsyncClient().createProducer();
    }

    public EventHubProducerClient buildProducerClient() {
        return this.buildClient().createProducer();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    EventHubAsyncClient buildAsyncClient() {
        EventHubConnectionProcessor processor;
        if (this.retryOptions == null) {
            this.retryOptions = DEFAULT_RETRY;
        }
        if (this.scheduler == null) {
            this.scheduler = Schedulers.boundedElastic();
        }
        if (this.prefetchCount == null) {
            this.prefetchCount = 500;
        }
        EventHubMessageSerializer messageSerializer = new EventHubMessageSerializer();
        if (this.isSharedConnection.get()) {
            Object object = this.connectionLock;
            synchronized (object) {
                if (this.eventHubConnectionProcessor == null) {
                    this.eventHubConnectionProcessor = this.buildConnectionProcessor(messageSerializer);
                }
            }
            processor = this.eventHubConnectionProcessor;
            int numberOfOpenClients = this.openClients.incrementAndGet();
            LOGGER.info("# of open clients with shared connection: {}", new Object[]{numberOfOpenClients});
        } else {
            processor = this.buildConnectionProcessor(messageSerializer);
        }
        TracerProvider tracerProvider = new TracerProvider(ServiceLoader.load(Tracer.class));
        return new EventHubAsyncClient(processor, tracerProvider, messageSerializer, this.scheduler, this.isSharedConnection.get(), this::onClientClose);
    }

    EventHubClient buildClient() {
        if (this.prefetchCount == null) {
            this.prefetchCount = 1;
        }
        EventHubAsyncClient client = this.buildAsyncClient();
        return new EventHubClient(client, this.retryOptions);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void onClientClose() {
        Object object = this.connectionLock;
        synchronized (object) {
            int numberOfOpenClients = this.openClients.decrementAndGet();
            LOGGER.info("Closing a dependent client. # of open clients: {}", new Object[]{numberOfOpenClients});
            if (numberOfOpenClients > 0) {
                return;
            }
            if (numberOfOpenClients < 0) {
                LOGGER.warning("There should not be less than 0 clients. actual: {}", new Object[]{numberOfOpenClients});
            }
            LOGGER.info("No more open clients, closing shared connection.");
            if (this.eventHubConnectionProcessor != null) {
                this.eventHubConnectionProcessor.dispose();
                this.eventHubConnectionProcessor = null;
            } else {
                LOGGER.warning("Shared EventHubConnectionProcessor was already disposed.");
            }
        }
    }

    private EventHubConnectionProcessor buildConnectionProcessor(MessageSerializer messageSerializer) {
        ConnectionOptions connectionOptions = this.getConnectionOptions();
        Flux connectionFlux = Flux.create(sink -> sink.onRequest(request -> {
            if (request == 0L) {
                return;
            }
            if (request > 1L) {
                sink.error((Throwable)LOGGER.logExceptionAsWarning((RuntimeException)new IllegalArgumentException("Requested more than one connection. Only emitting one. Request: " + request)));
                return;
            }
            String connectionId = StringUtil.getRandomString((String)"MF");
            LOGGER.atInfo().addKeyValue("connectionId", connectionId).log("Emitting a single connection.");
            AzureTokenManagerProvider tokenManagerProvider = new AzureTokenManagerProvider(connectionOptions.getAuthorizationType(), connectionOptions.getFullyQualifiedNamespace(), connectionOptions.getAuthorizationScope());
            ReactorProvider provider = new ReactorProvider();
            ReactorHandlerProvider handlerProvider = new ReactorHandlerProvider(provider);
            EventHubReactorAmqpConnection connection = new EventHubReactorAmqpConnection(connectionId, connectionOptions, this.getEventHubName(), provider, handlerProvider, (TokenManagerProvider)tokenManagerProvider, messageSerializer);
            sink.next((Object)connection);
        }));
        return (EventHubConnectionProcessor)connectionFlux.subscribeWith((Subscriber)new EventHubConnectionProcessor(connectionOptions.getFullyQualifiedNamespace(), this.getEventHubName(), connectionOptions.getRetry()));
    }

    private ConnectionOptions getConnectionOptions() {
        Configuration buildConfiguration;
        Configuration configuration = buildConfiguration = this.configuration == null ? Configuration.getGlobalConfiguration().clone() : this.configuration;
        if (this.credentials == null) {
            String connectionString = buildConfiguration.get(AZURE_EVENT_HUBS_CONNECTION_STRING);
            if (CoreUtils.isNullOrEmpty((CharSequence)connectionString)) {
                throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException("Credentials have not been set. They can be set using: connectionString(String), connectionString(String, String), credentials(String, String, TokenCredential), or setting the environment variable 'AZURE_EVENT_HUBS_CONNECTION_STRING' with a connection string"));
            }
            this.connectionString(connectionString);
        }
        if (this.proxyOptions == null) {
            this.proxyOptions = this.getDefaultProxyConfiguration(buildConfiguration);
        }
        if (this.proxyOptions != null && this.proxyOptions.isProxyAddressConfigured() && this.transport != AmqpTransportType.AMQP_WEB_SOCKETS) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException("Cannot use a proxy when TransportType is not AMQP Web Sockets."));
        }
        CbsAuthorizationType authorizationType = this.credentials instanceof EventHubSharedKeyCredential ? CbsAuthorizationType.SHARED_ACCESS_SIGNATURE : CbsAuthorizationType.JSON_WEB_TOKEN;
        SslDomain.VerifyMode verificationMode = this.verifyMode != null ? this.verifyMode : SslDomain.VerifyMode.VERIFY_PEER_NAME;
        ClientOptions options = this.clientOptions != null ? this.clientOptions : new ClientOptions();
        Map properties = CoreUtils.getProperties((String)EVENTHUBS_PROPERTIES_FILE);
        String product = properties.getOrDefault(NAME_KEY, UNKNOWN);
        String clientVersion = properties.getOrDefault(VERSION_KEY, UNKNOWN);
        if (this.customEndpointAddress == null) {
            return new ConnectionOptions(this.getAndValidateFullyQualifiedNamespace(), this.credentials, authorizationType, "https://eventhubs.azure.net/.default", this.transport, this.retryOptions, this.proxyOptions, this.scheduler, options, verificationMode, product, clientVersion);
        }
        return new ConnectionOptions(this.getAndValidateFullyQualifiedNamespace(), this.credentials, authorizationType, "https://eventhubs.azure.net/.default", this.transport, this.retryOptions, this.proxyOptions, this.scheduler, options, verificationMode, product, clientVersion, this.customEndpointAddress.getHost(), this.customEndpointAddress.getPort());
    }

    private ProxyOptions getDefaultProxyConfiguration(Configuration configuration) {
        String proxyAddress;
        ProxyAuthenticationType authentication = ProxyAuthenticationType.NONE;
        if (this.proxyOptions != null) {
            authentication = this.proxyOptions.getAuthentication();
        }
        if (CoreUtils.isNullOrEmpty((CharSequence)(proxyAddress = configuration.get("HTTP_PROXY")))) {
            return ProxyOptions.SYSTEM_DEFAULTS;
        }
        return this.getProxyOptions(authentication, proxyAddress, configuration, Boolean.parseBoolean(configuration.get("java.net.useSystemProxies")));
    }

    private ProxyOptions getProxyOptions(ProxyAuthenticationType authentication, String proxyAddress, Configuration configuration, boolean useSystemProxies) {
        if (HOST_PORT_PATTERN.matcher(proxyAddress.trim()).find()) {
            String[] hostPort = proxyAddress.split(":");
            String host = hostPort[0];
            int port = Integer.parseInt(hostPort[1]);
            Proxy proxy = new Proxy(Proxy.Type.HTTP, new InetSocketAddress(host, port));
            String username = configuration.get("PROXY_USERNAME");
            String password = configuration.get("PROXY_PASSWORD");
            return new ProxyOptions(authentication, proxy, username, password);
        }
        if (useSystemProxies) {
            com.azure.core.http.ProxyOptions coreProxyOptions = com.azure.core.http.ProxyOptions.fromConfiguration((Configuration)configuration);
            Proxy.Type proxyType = coreProxyOptions.getType().toProxyType();
            InetSocketAddress coreProxyAddress = coreProxyOptions.getAddress();
            String username = coreProxyOptions.getUsername();
            String password = coreProxyOptions.getPassword();
            return new ProxyOptions(authentication, new Proxy(proxyType, coreProxyAddress), username, password);
        }
        LOGGER.verbose("'HTTP_PROXY' was configured but ignored as 'java.net.useSystemProxies' wasn't set or was false.");
        return ProxyOptions.SYSTEM_DEFAULTS;
    }
}

